/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.ability.magic.SpellSlots;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.SpellReference;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.network.track.MsgTrackedValues;
import com.minelittlepony.unicopia.network.track.ObjectTracker;
import com.minelittlepony.unicopia.network.track.Trackable;
import com.minelittlepony.unicopia.network.track.TrackableObject;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import org.jetbrains.annotations.Nullable;

class MultiSpellSlot
implements SpellSlots,
NbtSerialisable {
    private final Caster<?> owner;
    private final ObjectTracker<Entry<Spell>> tracker;

    public MultiSpellSlot(Caster<?> owner) {
        this.owner = owner;
        this.tracker = Trackable.of(owner.asEntity()).getDataTrackers().checkoutTracker(() -> new Entry(owner));
    }

    public ObjectTracker<?> getTracker() {
        return this.tracker;
    }

    @Override
    public boolean contains(UUID id) {
        return this.tracker.contains(id) || this.tracker.values().stream().anyMatch(s -> s.spell.equalsOrContains(id));
    }

    @Override
    public void put(@Nullable Spell effect) {
        if (effect != null) {
            this.tracker.add(effect.getUuid(), new Entry<Spell>(this.owner, effect));
        }
    }

    @Override
    public void remove(UUID id, boolean force) {
        this.tracker.remove(id, force);
    }

    @Override
    public <T extends Spell> Stream<T> stream(@Nullable SpellPredicate<T> type) {
        return this.tracker.values().stream().flatMap(s -> s.spell.findMatches(type));
    }

    @Override
    public boolean clear(boolean force) {
        return this.tracker.clear(force);
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        compound.method_10566("spells", (class_2520)NbtSerialisable.writeMap(this.tracker.entries(), UUID::toString, entry -> entry.spell.toNBT(lookup)));
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        this.tracker.load(NbtSerialisable.readMap(compound.method_10562("spells"), (String key) -> {
            try {
                return UUID.fromString(key);
            }
            catch (Throwable throwable) {
                return null;
            }
        }, (K key, class_2520 nbt) -> {
            try {
                Entry entry = new Entry(this.owner);
                entry.spell.fromNBT((class_2487)nbt, lookup);
                return entry;
            }
            catch (Throwable t) {
                Unicopia.LOGGER.warn("Exception loading tracked object: {}", (Object)t.getMessage());
                return null;
            }
        }));
    }

    @Override
    public void copyFrom(SpellSlots other, boolean alive) {
        if (alive) {
            other.stream().forEach(this::put);
        } else {
            other.stream().filter(SpellType.PLACE_CONTROL_SPELL).forEach(this::put);
        }
    }

    static final class Entry<T extends Spell>
    implements TrackableObject<Entry<T>> {
        private final Caster<?> owner;
        final SpellReference<T> spell = new SpellReference();
        private boolean hasValue;

        public Entry(Caster<?> owner) {
            this.owner = owner;
        }

        public Entry(Caster<?> owner, T spell) {
            this.owner = owner;
            this.spell.set(spell);
            if (owner instanceof SpellSlots.UpdateCallback) {
                SpellSlots.UpdateCallback callback = (SpellSlots.UpdateCallback)((Object)owner);
                callback.onSpellAdded((Spell)spell);
            }
        }

        @Override
        public void discard(boolean immediate) {
            if (immediate) {
                this.spell.set(null, this.owner);
            } else {
                T s = this.spell.get();
                if (s != null) {
                    s.setDead();
                    s.tickDying(this.owner);
                    if (s.isDead()) {
                        s.destroy(this.owner);
                    }
                }
            }
        }

        @Override
        public TrackableObject.Status getStatus() {
            boolean hasValue;
            boolean bl = hasValue = this.spell.get() != null;
            if (hasValue != this.hasValue) {
                this.hasValue = hasValue;
                return hasValue ? TrackableObject.Status.NEW : TrackableObject.Status.REMOVED;
            }
            return TrackableObject.Status.DEFAULT;
        }

        @Override
        public void readTrackedNbt(class_2487 nbt, class_7225.class_7874 lookup) {
            this.spell.fromNBT(nbt, lookup);
        }

        @Override
        public class_2487 writeTrackedNbt(class_7225.class_7874 lookup) {
            return this.spell.toNBT(lookup);
        }

        @Override
        public void read(class_9129 buffer, class_7225.class_7874 lookup) {
            byte contentType = buffer.readByte();
            if (contentType == 1) {
                this.readTrackedNbt((class_2487)class_9135.field_48556.decode((Object)buffer), lookup);
            } else {
                T spell = this.spell.get();
                if (spell != null) {
                    spell.getDataTracker().load((MsgTrackedValues.TrackerEntries)MsgTrackedValues.TrackerEntries.PACKET_CODEC.decode((Object)buffer), buffer.method_56349());
                }
            }
        }

        @Override
        public Optional<? extends ByteBuf> write(TrackableObject.Status status, class_7225.class_7874 lookup) {
            if (status != TrackableObject.Status.DEFAULT) {
                class_2540 buffer = new class_2540(Unpooled.buffer());
                buffer.writeByte(1);
                class_9135.field_48556.encode((Object)buffer, (Object)this.spell.toNBT(lookup));
                return Optional.of(buffer);
            }
            @Nullable T spell = this.spell.get();
            if (spell == null) {
                return Optional.empty();
            }
            return spell.getDataTracker().getDirtyPairs(lookup).map(entries -> {
                class_9129 buffer = new class_9129(Unpooled.buffer(), this.owner.asEntity().method_56673());
                buffer.method_52997(0);
                MsgTrackedValues.TrackerEntries.PACKET_CODEC.encode((Object)buffer, entries);
                return buffer;
            });
        }

        @Override
        public void copyTo(Entry<T> destination) {
            destination.spell.set(this.spell.get());
        }
    }
}

