/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic;

import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.MultiSpellSlot;
import com.minelittlepony.unicopia.ability.magic.SingleSpellSlot;
import com.minelittlepony.unicopia.ability.magic.SpellInventory;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.util.Copyable;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public interface SpellSlots
extends NbtSerialisable,
Copyable<SpellSlots> {
    public static SpellInventory ofUnbounded(Caster<?> caster) {
        return new SpellInventory(caster, new MultiSpellSlot(caster));
    }

    public static SpellInventory ofSingle(Caster<?> caster) {
        return new SpellInventory(caster, new SingleSpellSlot(caster));
    }

    public <T extends Spell> Stream<T> stream(@Nullable SpellPredicate<T> var1);

    public void put(@Nullable Spell var1);

    public boolean clear(boolean var1);

    public void remove(UUID var1, boolean var2);

    public boolean contains(UUID var1);

    default public <T extends Spell> Optional<T> get() {
        return this.get(null);
    }

    default public boolean contains(@Nullable SpellPredicate<?> type) {
        return this.get(type).isPresent();
    }

    default public <T extends Spell> Optional<T> get(@Nullable SpellPredicate<T> type) {
        return this.stream(type).findFirst();
    }

    default public boolean clear() {
        return this.clear(false);
    }

    default public void remove(UUID spellid) {
        this.remove(spellid, false);
    }

    default public boolean removeIf(SpellPredicate<?> test) {
        return this.removeWhere(spell -> spell.findMatches(test).findFirst().isPresent());
    }

    default public boolean removeWhere(SpellPredicate<?> test) {
        return this.reduce((initial, spell) -> {
            if (test.test(spell)) {
                this.remove(spell.getUuid());
                return true;
            }
            return initial;
        });
    }

    default public Stream<Spell> stream() {
        return this.stream(null);
    }

    default public boolean reduce(BiFunction<Boolean, Spell, Boolean> alteration) {
        return this.stream().reduce(false, alteration, (a, b) -> b);
    }

    public static interface UpdateCallback {
        public void onSpellAdded(Spell var1);
    }
}

