/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell;

import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.AttributeFormat;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttribute;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttributeType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.util.Tickable;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_7225;

public interface TimedSpell
extends Spell {
    public static final int BASE_DURATION = 2400;
    public static final SpellAttribute<Integer> TIME = SpellAttribute.create(SpellAttributeType.DURATION, AttributeFormat.TIME, AttributeFormat.PERCENTAGE, Trait.FOCUS, focus -> 2400 + (int)(class_3532.method_15363((float)focus, (float)0.0f, (float)160.0f) * 19.0f) * 20);

    public Timer getTimer();

    public static class Timer
    implements Tickable,
    NbtSerialisable {
        private int maxDuration;
        private int duration;
        private int prevDuration;

        public Timer(int initial) {
            this.maxDuration = initial;
            this.duration = initial;
        }

        @Override
        public void tick() {
            this.prevDuration = this.duration--;
        }

        public float getPercentTimeRemaining(float tickDelta) {
            return (float)class_3532.method_48781((float)tickDelta, (int)this.prevDuration, (int)this.duration) / (float)this.maxDuration;
        }

        public int getTicksRemaining() {
            return this.duration;
        }

        @Override
        public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
            compound.method_10569("duration", this.duration);
            compound.method_10569("maxDuration", this.maxDuration);
        }

        @Override
        public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
            this.duration = compound.method_10550("duration");
            this.maxDuration = compound.method_10550("maxDuration");
        }
    }
}

