/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.CastingMethod;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.TimedSpell;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.AttributeFormat;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttribute;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttributeType;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.TooltipFactory;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AbstractSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.entity.EntityReference;
import com.minelittlepony.unicopia.entity.mob.FairyEntity;
import com.minelittlepony.unicopia.entity.mob.UEntities;
import com.minelittlepony.unicopia.projectile.MagicProjectileEntity;
import com.minelittlepony.unicopia.projectile.ProjectileDelegate;
import com.minelittlepony.unicopia.util.VecHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_7225;

public class LightSpell
extends AbstractSpell
implements TimedSpell,
ProjectileDelegate.HitListener {
    public static final SpellTraits DEFAULT_TRAITS = new SpellTraits.Builder().with(Trait.LIFE, 10.0f).with(Trait.AIR, 0.3f).with(Trait.KINDNESS, 12.0f).with(Trait.ORDER, 25.0f).build();
    private static final SpellAttribute<Integer> ORB_COUNT = SpellAttribute.create(SpellAttributeType.ORB_COUNT, AttributeFormat.REGULAR, AttributeFormat.PERCENTAGE, Trait.LIFE, life -> 2 + (int)(class_3532.method_15363((float)life, (float)10.0f, (float)20.0f) / 10.0f));
    static final TooltipFactory TOOLTIP = TooltipFactory.of(TIME, ORB_COUNT);
    private final TimedSpell.Timer timer = new TimedSpell.Timer((Integer)TIME.get(this.getTraits()));
    private final List<EntityReference<FairyEntity>> lights = new ArrayList<EntityReference<FairyEntity>>();

    protected LightSpell(CustomisedSpellType<?> type) {
        super(type);
    }

    @Override
    public TimedSpell.Timer getTimer() {
        return this.timer;
    }

    @Override
    public boolean tick(Caster<?> caster, Situation situation) {
        if (situation == Situation.PROJECTILE) {
            return false;
        }
        this.timer.tick();
        if (this.timer.getTicksRemaining() <= 0) {
            return false;
        }
        if (!caster.isClient()) {
            if (this.lights.isEmpty()) {
                int size = caster.asWorld().field_9229.method_43048(2) + ORB_COUNT.get(this.getTraits());
                while (this.lights.size() < size) {
                    this.lights.add(new EntityReference());
                }
            }
            this.lights.forEach(ref -> {
                if (ref.getOrEmpty(caster.asWorld()).isEmpty()) {
                    FairyEntity entity = (FairyEntity)UEntities.TWITTERMITE.method_5883(caster.asWorld());
                    entity.method_33574(ref.getTarget().map(EntityReference.EntityValues::pos).orElseGet(() -> caster.getOriginVector().method_1019(VecHelper.supply(() -> caster.asWorld().field_9229.method_43048(3) - 1))));
                    entity.setMaster(caster);
                    entity.method_37908().method_8649((class_1297)entity);
                    ref.set(entity);
                }
            });
        }
        return true;
    }

    @Override
    public void onImpact(MagicProjectileEntity projectile) {
        Caster.of(projectile.getMaster()).ifPresent(caster -> this.getTypeAndTraits().apply((Caster<?>)caster, CastingMethod.INDIRECT));
    }

    @Override
    protected void onDestroyed(Caster<?> caster) {
        super.onDestroyed(caster);
        if (caster.isClient()) {
            return;
        }
        this.lights.forEach(ref -> ref.ifPresent(caster.asWorld(), e -> {
            e.method_37908().method_8421((class_1297)e, (byte)60);
            e.method_31472();
        }));
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNBT(compound, lookup);
        this.timer.toNBT(compound, lookup);
        if (!this.lights.isEmpty()) {
            class_2499 list = new class_2499();
            this.lights.forEach(light -> list.add((Object)light.toNBT(lookup)));
            compound.method_10566("lights", (class_2520)list);
        }
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNBT(compound, lookup);
        this.timer.fromNBT(compound, lookup);
        this.lights.clear();
        if (compound.method_10573("lights", 9)) {
            compound.method_10554("lights", 10).forEach(nbt -> this.lights.add(new EntityReference((class_2487)nbt, lookup)));
        }
    }
}

