/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.Affinity;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.CastingMethod;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.AttributeFormat;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.CastOn;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttribute;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttributeType;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.TooltipFactory;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AbstractSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AttractionUtils;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.effect.TargetSelecter;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.client.minelittlepony.MineLPDelegate;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.particle.LightningBoltParticleEffect;
import com.minelittlepony.unicopia.particle.MagicParticleEffect;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.projectile.ProjectileUtil;
import com.minelittlepony.unicopia.server.world.Ether;
import com.minelittlepony.unicopia.util.Lerp;
import com.minelittlepony.unicopia.util.shape.Sphere;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import java.util.Optional;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1540;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1672;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5253;

public class ShieldSpell
extends AbstractSpell {
    public static final SpellTraits DEFAULT_TRAITS = new SpellTraits.Builder().with(Trait.FOCUS, 5.0f).with(Trait.KNOWLEDGE, 1.0f).with(Trait.STRENGTH, 50.0f).with(Trait.AIR, 9.0f).build();
    static final SpellAttribute<Float> RANGE = SpellAttribute.create(SpellAttributeType.RANGE, AttributeFormat.REGULAR, AttributeFormat.PERCENTAGE, Trait.POWER, power -> Float.valueOf(Math.max(0.0f, 4.0f + power)));
    protected static final SpellAttribute<CastOn> CAST_ON = SpellAttribute.createEnumerated(SpellAttributeType.CAST_ON, Trait.GENEROSITY, generosity -> generosity > 0.0f ? CastOn.LOCATION : CastOn.SELF);
    static final SpellAttribute<Boolean> TARGET_ITEMS = SpellAttribute.createConditional(SpellAttributeType.PERMIT_ITEMS, Trait.KNOWLEDGE, (Float2ObjectFunction<Boolean>)((Float2ObjectFunction)knowledge -> knowledge > 10.0f));
    static final SpellAttribute<Boolean> PERMIT_PASSIVE = SpellAttribute.createConditional(SpellAttributeType.PERMIT_PASSIVE, Trait.LIFE, (Float2ObjectFunction<Boolean>)((Float2ObjectFunction)l -> l > 0.0f));
    static final SpellAttribute<Boolean> PERMIT_HOSTILE = SpellAttribute.createConditional(SpellAttributeType.PERMIT_HOSTILE, Trait.BLOOD, (Float2ObjectFunction<Boolean>)((Float2ObjectFunction)l -> l > 0.0f));
    static final SpellAttribute<Boolean> PERMIT_PLAYER = SpellAttribute.createConditional(SpellAttributeType.PERMIT_PLAYER, Trait.ICE, (Float2ObjectFunction<Boolean>)((Float2ObjectFunction)l -> l > 0.0f));
    static final TooltipFactory PERMIT_ENTITY = TooltipFactory.of(PERMIT_PASSIVE, PERMIT_HOSTILE, PERMIT_PLAYER);
    static final TooltipFactory TARGET = (type, tooltip) -> (TARGET_ITEMS.get(type.traits()) != false ? TARGET_ITEMS : PERMIT_ENTITY).appendTooltip(type, tooltip);
    static final TooltipFactory TOOLTIP = TooltipFactory.of(RANGE, TARGET, CAST_ON);
    protected final TargetSelecter targetSelecter = new TargetSelecter(this).setFilter(this::isValidTarget);
    private final Lerp radius = new Lerp(0.0f);
    private final Lerp rangeMultiplier = new Lerp(1.0f);
    private int prevTicksDying;
    private int ticksDying;

    protected ShieldSpell(CustomisedSpellType<?> type) {
        super(type);
    }

    @Override
    public Spell prepareForCast(Caster<?> caster, CastingMethod method) {
        return method == CastingMethod.STAFF || CAST_ON.get(this.getTraits()) == CastOn.LOCATION ? this.toPlaceable() : this;
    }

    @Override
    public Affinity getAffinity() {
        return this.getTraits().get(Trait.DARKNESS) > 0.0f ? Affinity.BAD : Affinity.GOOD;
    }

    protected void generateParticles(Caster<?> source) {
        class_243 origin = this.getOrigin(source);
        source.spawnParticles(origin, new Sphere(true, this.radius.getValue()), (int)(this.radius.getValue() * 2.0f), pos -> {
            int hornColor = MineLPDelegate.getInstance().getMagicColor((class_1297)source.getOriginatingCaster().asEntity());
            source.addParticle(new MagicParticleEffect(class_5253.class_5254.method_48780((float)0.6f, (int)this.getType().getColor(), (int)hornColor)), (class_243)pos, class_243.field_1353);
            if (source.asWorld().field_9229.method_43048(10) == 0 && source.asWorld().field_9229.method_43057() < source.getCorruption().getScaled(1.0f)) {
                ParticleUtils.spawnParticle(source.asWorld(), new LightningBoltParticleEffect(true, 3, 2, 0.1f, Optional.empty()), pos, class_243.field_1353);
            }
        });
        if (source.asWorld().field_9229.method_43048(20) == 0 || !this.rangeMultiplier.isFinished() || !this.radius.isFinished()) {
            source.asEntity().method_5783(USounds.SPELL_CAST_SUCCESS, 0.05f, 1.5f);
        }
    }

    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        long costMultiplier;
        Pony pony;
        this.rangeMultiplier.update(source instanceof Pony && ((class_1657)(pony = (Pony)source).asEntity()).method_5715() ? 1 : 2, 500L);
        this.radius.update((float)this.getDrawDropOffRange(source), 200L);
        if (source.isClient()) {
            this.generateParticles(source);
        } else {
            Ether.get(source.asWorld()).getOrCreate(this, source).setRadius(this.radius.getValue());
        }
        if (situation == Situation.PROJECTILE) {
            this.applyEntities(source);
            return true;
        }
        float knowledge = this.getTraits().get(Trait.KNOWLEDGE, -6.0f, 6.0f);
        if (knowledge == 0.0f) {
            knowledge = 1.0f;
        }
        if ((costMultiplier = this.applyEntities(source)) > 0L) {
            this.consumeManage(source, costMultiplier, knowledge);
        }
        return !this.isDead();
    }

    @Override
    public void tickDying(Caster<?> caster) {
        Pony pony;
        this.rangeMultiplier.update(caster instanceof Pony && ((class_1657)(pony = (Pony)caster).asEntity()).method_5715() ? 1 : 2, 10L);
        this.radius.update((float)this.getDrawDropOffRange(caster), 10L);
        this.prevTicksDying = this.ticksDying;
        if (this.ticksDying++ > 25) {
            super.tickDying(caster);
        }
    }

    protected void consumeManage(Caster<?> source, long costMultiplier, float knowledge) {
        double cost = 2.0f - source.getLevel().getScaled(2.0f);
        cost *= (double)((float)costMultiplier / ((float)(1 + source.getLevel().get()) * 3.0f));
        cost /= (double)knowledge;
        if (!source.subtractEnergyCost(cost += (double)(this.radius.getValue() / 10.0f))) {
            this.setDead();
        }
    }

    public float getRadius(float tickDelta) {
        float base = this.radius.getValue();
        float scale = 1.0f - class_3532.method_15363((float)(class_3532.method_16439((float)tickDelta, (float)this.prevTicksDying, (float)this.ticksDying) / 25.0f), (float)0.0f, (float)1.0f);
        return base * scale;
    }

    public double getDrawDropOffRange(Caster<?> source) {
        float min = (float)(source instanceof Pony ? 0 : 2) + RANGE.get(this.getTraits()).floatValue();
        double range = (min + source.getLevel().getScaled(source instanceof Pony ? 4.0f : 40.0f) * (float)(source instanceof Pony ? 2 : 10)) / this.rangeMultiplier.getValue();
        return range;
    }

    protected boolean isValidTarget(Caster<?> source, class_1297 entity) {
        boolean valid;
        if (TARGET_ITEMS.get(this.getTraits()).booleanValue()) {
            return entity instanceof class_1542;
        }
        boolean bl = valid = (entity instanceof class_1309 || entity instanceof class_1541 || entity instanceof class_1540 || ProjectileUtil.isFlyingProjectile(entity) || entity instanceof class_1688) && !(entity instanceof class_1531) && !(entity instanceof class_1672) && !(entity instanceof class_1690);
        if (PERMIT_PASSIVE.get(this.getTraits()).booleanValue()) {
            valid &= !(entity instanceof class_1296);
        }
        if (PERMIT_HOSTILE.get(this.getTraits()).booleanValue()) {
            valid &= !(entity instanceof class_1588);
        }
        if (PERMIT_PLAYER.get(this.getTraits()).booleanValue()) {
            valid &= !(entity instanceof class_1657);
        }
        return valid;
    }

    protected long applyEntities(Caster<?> source) {
        class_243 origin = this.getOrigin(source);
        this.targetSelecter.getEntities(source, this.radius.getValue()).forEach(i -> {
            try {
                this.applyRadialEffect(source, (class_1297)i, i.method_19538().method_1022(origin), this.radius.getValue());
            }
            catch (Throwable e) {
                Unicopia.LOGGER.error("Error updating radial effect", e);
            }
        });
        return this.targetSelecter.getTotalDamaged();
    }

    protected class_243 getOrigin(Caster<?> source) {
        return source.getOriginVector();
    }

    protected void applyRadialEffect(Caster<?> source, class_1297 target, double distance, double radius) {
        class_243 pos = this.getOrigin(source);
        if (ProjectileUtil.isFlyingProjectile(target)) {
            if (!ProjectileUtil.isProjectileThrownBy(target, (class_1309)source.getMaster())) {
                if (distance < 1.0) {
                    target.method_5783(USounds.SPELL_SHIELD_BURN_PROJECTILE, 0.1f, 1.0f);
                    target.method_5650(class_1297.class_5529.field_26999);
                } else {
                    ProjectileUtil.ricochet(target, pos, 0.9f);
                }
            }
        } else if (target instanceof class_1309) {
            double force = Math.max(0.1, radius / 4.0);
            force = this.isFriendlyTogether(source) ? (force *= AttractionUtils.getForceAdjustment(target)) : (force *= 0.75);
            AttractionUtils.applyForce(pos, target, force, distance < 1.0 ? distance : 0.0, false);
        }
    }
}

