/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.block.state;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.block.state.ReversableBlockStateConverter;
import com.minelittlepony.unicopia.block.state.ReversableBlockStateConverterImpl;
import com.minelittlepony.unicopia.util.Resources;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.slf4j.Logger;

public class StateMapLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final class_2960 ID = Unicopia.id("data/state_maps");
    public static final StateMapLoader INSTANCE = new StateMapLoader();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String FILE_SUFFIX = ".json";
    private static final int FILE_SUFFIX_LENGTH = ".json".length();
    private static final String DATA_TYPE = "state_maps";
    final Map<class_2960, ReversableBlockStateConverter> converters = new HashMap<class_2960, ReversableBlockStateConverter>();

    public StateMapLoader() {
        super(Resources.GSON, DATA_TYPE);
    }

    public class_2960 getFabricId() {
        return ID;
    }

    protected Map<class_2960, JsonElement> method_20731(class_3300 resourceManager, class_3695 profiler) {
        HashMap map = Maps.newHashMap();
        int i = DATA_TYPE.length() + 1;
        resourceManager.method_41265(DATA_TYPE, id -> id.method_12832().endsWith(FILE_SUFFIX)).entrySet().stream().forEach(entry -> {
            class_2960 resId = (class_2960)entry.getKey();
            class_2960 id = resId.method_45134(p -> p.substring(i, p.length() - FILE_SUFFIX_LENGTH));
            JsonArray entries = new JsonArray();
            for (class_3298 resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.method_43039();
                    try {
                        JsonObject json = (JsonObject)class_3518.method_15276((Gson)Resources.GSON, (Reader)reader, JsonObject.class);
                        if (json != null) {
                            if (!json.has("entries")) continue;
                            JsonArray incoming = class_3518.method_15261((JsonObject)json, (String)"entries");
                            if (json.has("replace") && json.get("replace").getAsBoolean()) {
                                entries = incoming;
                                continue;
                            }
                            entries.addAll(incoming);
                            continue;
                        }
                        LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)id, (Object)resId);
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (JsonParseException | IOException | IllegalArgumentException e) {
                    LOGGER.error("Couldn't parse data file {} from {}", new Object[]{id, resId, e});
                }
            }
            map.put(id, entries);
        });
        return map;
    }

    protected void apply(Map<class_2960, JsonElement> data, class_3300 manager, class_3695 profiler) {
        this.converters.clear();
        data.forEach((id, json) -> ReversableBlockStateConverterImpl.CODEC.decode((DynamicOps)JsonOps.INSTANCE, json).result().map(Pair::getFirst).ifPresent(map -> this.converters.put((class_2960)id, (ReversableBlockStateConverter)map)));
    }
}

