/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.block.state;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.block.state.ReversableStateChange;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public interface StatePredicate
extends Predicate<class_2680> {
    public static final Codec<StatePredicate> TYPE_CODEC = class_2960.field_25139.dispatch(StatePredicate::getType, type -> REGISTRY.get(type));
    public static final Codec<StatePredicate> CODEC = Codec.xor((Codec)Codec.lazyInitialized(() -> Union.CODEC), TYPE_CODEC).xmap(Either::unwrap, predicate -> {
        Either either;
        if (predicate instanceof Union) {
            Union union = (Union)predicate;
            either = Either.left((Object)union);
        } else {
            either = Either.right((Object)predicate);
        }
        return either;
    });
    public static final Map<class_2960, MapCodec<? extends StatePredicate>> REGISTRY = Map.of(FluidTag.ID, FluidTag.MAP_CODEC, Tag.ID, Tag.MAP_CODEC, State.ID, State.MAP_CODEC, Union.ID, Union.MAP_CODEC, PropertyOp.ID, PropertyOp.MAP_CODEC, Plants.ID, Plants.MAP_CODEC);

    public static void bootstrap() {
        ReversableStateChange.bootstrap();
    }

    public static boolean isFluid(class_2680 state) {
        return state.method_51176();
    }

    public static <T extends Comparable<T>> Optional<class_2769<T>> getProperty(class_2680 state, String name) {
        return state.method_28501().stream().filter(property -> property.method_11899().contentEquals(name)).findFirst();
    }

    default public Optional<ReversableStateChange> getInverse() {
        return Optional.empty();
    }

    public class_2960 getType();

    public record Union(List<StatePredicate> predicates, Combiner combiner) implements StatePredicate
    {
        public static final class_2960 ID = Unicopia.id("union");
        public static final MapCodec<Union> MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)CODEC.listOf().fieldOf("predicates").forGetter(Union::predicates), (App)Combiner.CODEC.fieldOf("combiner").forGetter(Union::combiner)).apply((Applicative)i, Union::new));
        public static final Codec<Union> CODEC = CODEC.listOf().xmap(predicates -> new Union((List<StatePredicate>)predicates, Combiner.OR), Union::predicates);

        @Override
        public class_2960 getType() {
            return ID;
        }

        @Override
        public boolean test(class_2680 state) {
            return this.combiner.func.test(this.predicates.stream(), predicate -> predicate.test(state));
        }

        public static enum Combiner implements class_3542
        {
            AND(Stream::allMatch),
            OR(Stream::anyMatch);

            public static final Codec<Combiner> CODEC;
            private final String name = this.name().toLowerCase(Locale.ROOT);
            private final BiPredicate<Stream<StatePredicate>, Predicate<StatePredicate>> func;

            private Combiner(BiPredicate<Stream<StatePredicate>, Predicate<StatePredicate>> func) {
                this.func = func;
            }

            public String method_15434() {
                return this.name;
            }

            static {
                CODEC = class_3542.method_28140(Combiner::values);
            }
        }
    }

    public record FluidTag(class_6862<class_3611> tag) implements StatePredicate
    {
        public static final class_2960 ID = Unicopia.id("fluid_tag");
        public static final Codec<FluidTag> CODEC = class_6862.method_40093((class_5321)class_7924.field_41270).xmap(FluidTag::new, FluidTag::tag);
        public static final MapCodec<FluidTag> MAP_CODEC = CODEC.fieldOf("tag");

        public FluidTag(String tag) {
            this((class_6862<class_3611>)class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)class_2960.method_60654((String)tag)));
        }

        @Override
        public class_2960 getType() {
            return ID;
        }

        @Override
        public boolean test(class_2680 state) {
            return StatePredicate.isFluid(state) && state.method_26227().method_15767(this.tag);
        }
    }

    public record Tag(class_6862<class_2248> tag, Optional<ReversableStateChange> inverse) implements StatePredicate
    {
        public static final class_2960 ID = Unicopia.id("block_tag");
        public static final Codec<Tag> CODEC = class_6862.method_40093((class_5321)class_7924.field_41254).xmap(Tag::new, Tag::tag);
        public static final MapCodec<Tag> MAP_CODEC = CODEC.fieldOf("tag");

        public Tag(String tag) {
            this((class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)tag)), Optional.empty());
        }

        public Tag(class_6862<class_2248> tag) {
            this(tag, Optional.empty());
        }

        @Override
        public class_2960 getType() {
            return ID;
        }

        @Override
        public boolean test(class_2680 state) {
            return state.method_26164(this.tag);
        }

        @Override
        public Optional<ReversableStateChange> getInverse() {
            return this.inverse.or(() -> Optional.of(new ReversableStateChange.SetRandomState(this)));
        }
    }

    public record State(class_2960 id, List<PropertyOp> properties, Optional<ReversableStateChange> inverse) implements StatePredicate
    {
        public static final class_2960 ID = Unicopia.id("block_state");
        public static final Codec<State> CODEC = Codec.STRING.xmap(State::new, state -> state.id.toString() + (String)(state.properties.isEmpty() ? "" : "{" + state.properties.stream().map(PropertyOp::toString).collect(Collectors.joining(",")) + "}"));
        public static final MapCodec<State> MAP_CODEC = CODEC.fieldOf("state");

        public State(class_2960 id, List<PropertyOp> properties) {
            this(id, properties, Optional.empty());
        }

        public State(String state) {
            this(class_2960.method_60654((String)state.split("\\{")[0]), Optional.of(state).filter(s -> s.contains("{")).stream().flatMap(s -> Stream.of(s.split("\\{")[1].split("\\}")[0].split(","))).map(PropertyOp::of).filter(Optional::isPresent).map(Optional::get).toList(), Optional.empty());
        }

        @Override
        public class_2960 getType() {
            return ID;
        }

        @Override
        public boolean test(class_2680 state) {
            return class_7923.field_41175.method_17966(this.id).filter(arg_0 -> ((class_2680)state).method_27852(arg_0)).isPresent() && (this.properties.isEmpty() || this.properties.stream().allMatch(p -> p.test(state)));
        }

        public class_2680 applyTo(class_1937 world, class_2680 state) {
            for (PropertyOp prop : this.properties) {
                state = prop.applyTo(world, state);
            }
            return state;
        }

        @Override
        public Optional<ReversableStateChange> getInverse() {
            return this.inverse.or(() -> Optional.of(new ReversableStateChange.SetState(this)));
        }
    }

    public record PropertyOp(String name, String value, Comparison op) implements StatePredicate
    {
        public static final class_2960 ID = Unicopia.id("block_state_property");
        public static final Codec<PropertyOp> CODEC = Codec.STRING.flatXmap(pattern -> {
            String[] splitten = pattern.split("[=<>]", 2);
            if (pattern.indexOf(61) == splitten[0].length()) {
                return DataResult.success((Object)new PropertyOp(splitten[0], splitten[1], Comparison.EQUAL));
            }
            if (pattern.indexOf(60) == splitten[0].length()) {
                return DataResult.success((Object)new PropertyOp(splitten[0], splitten[1], Comparison.LESS));
            }
            if (pattern.indexOf(62) == splitten[0].length()) {
                return DataResult.success((Object)new PropertyOp(splitten[0], splitten[1], Comparison.GREATER));
            }
            return DataResult.error(() -> "Invalid pattern: " + pattern);
        }, property -> DataResult.success((Object)property.toString()));
        public static final MapCodec<PropertyOp> MAP_CODEC = CODEC.fieldOf("property");

        public static Optional<PropertyOp> of(String pattern) {
            String[] splitten = pattern.split("[=<>]", 2);
            if (pattern.indexOf(61) == splitten[0].length()) {
                return Optional.of(new PropertyOp(splitten[0], splitten[1], Comparison.EQUAL));
            }
            if (pattern.indexOf(60) == splitten[0].length()) {
                return Optional.of(new PropertyOp(splitten[0], splitten[1], Comparison.LESS));
            }
            if (pattern.indexOf(62) == splitten[0].length()) {
                return Optional.of(new PropertyOp(splitten[0], splitten[1], Comparison.GREATER));
            }
            return Optional.empty();
        }

        @Override
        public class_2960 getType() {
            return ID;
        }

        public class_2680 applyTo(class_1937 world, class_2680 state) {
            return StatePredicate.getProperty(state, this.name).flatMap(property -> property.method_11900(this.value).map(val -> this.applyValidValue(world, (class_2769)property, (Comparable)val, state))).orElse(state);
        }

        @Override
        public String toString() {
            return this.name + this.op.getSymbol() + this.value;
        }

        private <T extends Comparable<T>> class_2680 applyValidValue(class_1937 world, class_2769<T> property, T allowedValue, class_2680 state) {
            List<Comparable> allowedValues;
            if (this.op == Comparison.EQUAL) {
                return (class_2680)state.method_11657(property, allowedValue);
            }
            if (this.op == Comparison.GREATER && !(allowedValues = property.method_11898().stream().filter(v -> this.op.test(v.compareTo(allowedValue))).toList()).contains(state.method_11654(property))) {
                int index = world.field_9229.method_43048(allowedValues.size());
                return (class_2680)state.method_11657(property, allowedValues.remove(index));
            }
            return state;
        }

        @Override
        public boolean test(class_2680 state) {
            return StatePredicate.getProperty(state, this.name).flatMap(property -> property.method_11900(this.value).filter(v -> this.op.test(state.method_11654(property).compareTo(v)))).isPresent();
        }

        public static enum Comparison implements IntPredicate,
        class_3542
        {
            LESS('<'){

                @Override
                public boolean test(int value) {
                    return value < 0;
                }
            }
            ,
            GREATER('>'){

                @Override
                public boolean test(int value) {
                    return value > 0;
                }
            }
            ,
            EQUAL('='){

                @Override
                public boolean test(int value) {
                    return value == 0;
                }
            };

            public static final Codec<Comparison> CODEC;
            private final String name = this.name().toLowerCase(Locale.ROOT);
            private final char symbol;

            private Comparison(char symbol) {
                this.symbol = symbol;
            }

            public char getSymbol() {
                return this.symbol;
            }

            public String method_15434() {
                return this.name;
            }

            @Override
            public abstract boolean test(int var1);

            static {
                CODEC = class_3542.method_28140(Comparison::values);
            }
        }
    }

    public record Plants() implements StatePredicate
    {
        public static final class_2960 ID = Unicopia.id("is_plant");
        public static final Plants INSTANCE = new Plants();
        public static final MapCodec<Plants> MAP_CODEC = MapCodec.unit((Object)INSTANCE);

        @Override
        public class_2960 getType() {
            return ID;
        }

        @Override
        public boolean test(class_2680 state) {
            return state.method_26204() instanceof class_2261;
        }
    }
}

