/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.gui;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5225;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class ParagraphWrappingVisitor
implements class_5348.class_5246<Object> {
    private int line = 0;
    private int pageWidth;
    private final class_327 font;
    private final class_5225 handler;
    private float currentLineCollectedLength;
    private class_5250 currentLine;
    private boolean progressedNonEmpty;
    private final Int2IntFunction widthSupplier;
    private final BiConsumer<class_2561, Integer> lineConsumer;

    public ParagraphWrappingVisitor(Int2IntFunction widthSupplier, BiConsumer<class_2561, Integer> lineConsumer) {
        this.font = class_310.method_1551().field_1772;
        this.handler = this.font.method_27527();
        this.currentLineCollectedLength = 0.0f;
        this.currentLine = class_2561.method_43473();
        this.widthSupplier = widthSupplier;
        this.lineConsumer = lineConsumer;
        Objects.requireNonNull(this.font);
        this.pageWidth = widthSupplier.applyAsInt(this.line * 9);
    }

    public Optional<Object> accept(class_2583 initialStyle, String s) {
        StyleBreakingVisitor visitor = new StyleBreakingVisitor(initialStyle, this::acceptFragment);
        class_5223.method_27473((String)s, (int)0, (class_2583)initialStyle, (class_2583)initialStyle, (class_5224)visitor);
        visitor.flush();
        return Optional.empty();
    }

    private Optional<Object> acceptFragment(class_2583 inlineStyle, String s) {
        int remainingLength = (int)((float)this.pageWidth - this.currentLineCollectedLength);
        while (!s.isEmpty()) {
            class_5250 fragment;
            float grabbedWidth;
            int trimmedLength = this.handler.method_27484(s, remainingLength, inlineStyle);
            int newline = s.indexOf(10);
            if (newline >= 0 && newline < trimmedLength) {
                trimmedLength = newline + 1;
            } else {
                newline = -1;
            }
            if (trimmedLength == 0) {
                trimmedLength = s.length();
            }
            if (!(trimmedLength >= s.length() - 1 || trimmedLength <= 0 || Character.isWhitespace(s.charAt(trimmedLength + 1)) && Character.isWhitespace(s.charAt(trimmedLength - 1)))) {
                String wrappedFragment = s.substring(0, trimmedLength);
                int lastSpace = wrappedFragment.lastIndexOf(32);
                int n = trimmedLength = lastSpace > 0 ? Math.min(lastSpace, trimmedLength) : trimmedLength;
            }
            if (this.currentLineCollectedLength + (grabbedWidth = this.handler.method_27488((class_5348)(fragment = class_2561.method_43470((String)s.substring(0, trimmedLength).trim()).method_10862(inlineStyle)))) > (float)this.pageWidth) {
                this.advance();
            }
            if (this.currentLineCollectedLength > 0.0f && s.startsWith(" ")) {
                this.currentLine.method_27693(" ");
                this.currentLineCollectedLength += this.handler.method_27482(" ");
            }
            this.currentLine.method_10852((class_2561)fragment);
            this.currentLineCollectedLength += grabbedWidth;
            if (this.currentLineCollectedLength > 0.0f && s.endsWith(" ")) {
                this.currentLine.method_27693(" ");
                this.currentLineCollectedLength += this.handler.method_27482(" ");
            }
            if (newline >= 0) {
                this.advance();
            }
            if (trimmedLength <= s.length()) {
                s = s.substring(trimmedLength, s.length());
            }
            remainingLength = this.pageWidth;
        }
        return Optional.empty();
    }

    public void forceAdvance() {
        if (this.currentLineCollectedLength > 0.0f) {
            this.advance();
        }
        this.advance();
    }

    public void advance() {
        ++this.line;
        if (this.progressedNonEmpty || this.currentLineCollectedLength > 0.0f) {
            this.progressedNonEmpty = true;
            Objects.requireNonNull(this.font);
            this.lineConsumer.accept((class_2561)this.currentLine, this.line * 9);
        }
        Objects.requireNonNull(this.font);
        this.pageWidth = this.widthSupplier.applyAsInt(this.line * 9);
        this.currentLine = class_2561.method_43473();
        this.currentLineCollectedLength = 0.0f;
    }

    static final class StyleBreakingVisitor
    implements class_5224 {
        private final class_5348.class_5246<?> fragmentVisitor;
        private final StringBuilder collectedText = new StringBuilder();
        private class_2583 currentStyle;

        public StyleBreakingVisitor(class_2583 initialStyle, class_5348.class_5246<?> fragmentVisitor) {
            this.currentStyle = initialStyle;
            this.fragmentVisitor = fragmentVisitor;
        }

        public boolean accept(int index, class_2583 style, int codepoint) {
            if (!style.equals((Object)this.currentStyle)) {
                this.flush();
            }
            this.currentStyle = style;
            this.collectedText.append((char)codepoint);
            return true;
        }

        public void flush() {
            if (this.collectedText.length() > 0) {
                this.fragmentVisitor.accept(this.currentStyle, this.collectedText.toString());
                this.collectedText.setLength(0);
            }
        }
    }
}

