/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.gui;

import com.minelittlepony.common.client.gui.GameGui;
import com.minelittlepony.common.client.gui.IField;
import com.minelittlepony.common.client.gui.ScrollContainer;
import com.minelittlepony.common.client.gui.element.Button;
import com.minelittlepony.common.client.gui.element.EnumSlider;
import com.minelittlepony.common.client.gui.element.Label;
import com.minelittlepony.common.client.gui.element.Slider;
import com.minelittlepony.common.client.gui.element.Toggle;
import com.minelittlepony.common.client.gui.style.Style;
import com.minelittlepony.unicopia.Config;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.client.gui.DrawableUtil;
import com.minelittlepony.unicopia.client.gui.HudPosition;
import com.minelittlepony.unicopia.client.minelittlepony.MineLPDelegate;
import com.minelittlepony.unicopia.entity.player.SkinFeatures;
import com.minelittlepony.unicopia.server.world.UnicopiaWorldProperties;
import com.minelittlepony.unicopia.util.RegistryIndexer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_1306;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class SettingsScreen
extends GameGui {
    private final Config config = Unicopia.getConfig();
    private final ScrollContainer content = new ScrollContainer();
    @Nullable
    private Style mineLpStatus;
    private long drawingHudOutline;

    public SettingsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"unicopia.options.title"), parent);
        this.content.margin.setVertical(30);
        this.content.getContentPadding().setHorizontal(10);
        this.content.getContentPadding().top = 10;
        this.content.getContentPadding().bottom = 20;
    }

    public void method_25426() {
        this.content.init(this::rebuildContent);
    }

    private void rebuildContent() {
        int LEFT = this.content.field_22789 / 2 - 100;
        this.getChildElements().add(this.content);
        int row = 0;
        ((Label)this.addButton((class_364)new Label(this.field_22789 / 2, 5).setCentered())).getStyle().setText(this.method_25440().getString());
        ((Button)this.addButton((class_364)new Button(this.field_22789 / 2 - 100, this.field_22790 - 25))).onClick(sender -> this.finish()).getStyle().setText("gui.done");
        ((Label)this.content.addButton((class_364)new Label(LEFT, row))).getStyle().setText("unicopia.options.client");
        ((Toggle)this.content.addButton((class_364)new Toggle(LEFT, row += 20, ((Boolean)this.config.ignoreMineLP.get()).booleanValue()))).onChange(v -> {
            this.config.ignoreMineLP.set(v);
            if (this.mineLpStatus != null) {
                this.mineLpStatus.setText(this.getMineLPStatus());
            }
            return v;
        }).getStyle().setText("unicopia.options.ignore_mine_lp");
        row += 10;
        this.mineLpStatus = ((Label)this.content.addButton((class_364)new Label(LEFT, row += 10))).getStyle().setText(this.getMineLPStatus());
        ((Toggle)this.content.addButton((class_364)new Toggle(LEFT, row += 20, ((Boolean)this.config.toggleAbilityKeys.get()).booleanValue()))).onChange(this.config.toggleAbilityKeys).getStyle().setText("unicopia.options.toggle_ability_keys");
        ((EnumSlider)this.content.addButton((class_364)new EnumSlider(LEFT, row += 20, this.config.hudPosition))).onChange(v -> {
            this.drawingHudOutline = System.currentTimeMillis() + 1000L;
            return (HudPosition)((Object)((Object)this.config.hudPosition.set((Object)v)));
        }).setTextFormat(v -> class_2561.method_43469((String)"unicopia.options.hud_position", (Object[])new Object[]{((HudPosition)((Object)((Object)v.getValue()))).name()}));
        RegistryIndexer<Race> races = RegistryIndexer.of(Race.REGISTRY);
        ((Slider)this.content.addButton((class_364)new Slider(LEFT, row += 25, 0.0f, (float)races.size(), (float)races.indexOf((Race)this.config.preferredRace.get())))).onChange(races.createSetter((IField.IChangeCallback<Race>)this.config.preferredRace)).setTextFormat(v -> class_2561.method_43469((String)"unicopia.options.preferred_race", (Object[])new Object[]{((Race)races.valueOf(((Float)v.getValue()).floatValue())).getDisplayName()}));
        ((Label)this.content.addButton((class_364)new Label(LEFT, row += 20))).getStyle().setText("unicopia.options.skin_features");
        ((Toggle)this.content.addButton((class_364)new Toggle(LEFT, row += 20, ((SkinFeatures)this.config.skinFeatures.get()).showHorn()))).onChange(horn -> {
            SkinFeatures features = (SkinFeatures)this.config.skinFeatures.get();
            this.config.skinFeatures.set((Object)new SkinFeatures((boolean)horn, features.showWings(), features.skinColor()));
            return horn;
        }).getStyle().setText("unicopia.options.skin_features.horn");
        ((Toggle)this.content.addButton((class_364)new Toggle(LEFT, row += 20, ((SkinFeatures)this.config.skinFeatures.get()).showWings()))).onChange(wings -> {
            SkinFeatures features = (SkinFeatures)this.config.skinFeatures.get();
            this.config.skinFeatures.set((Object)new SkinFeatures(features.showHorn(), (boolean)wings, features.skinColor()));
            return wings;
        }).getStyle().setText("unicopia.options.skin_features.wings");
        class_1132 server = this.field_22787.method_1576();
        if (server != null) {
            ((Label)this.content.addButton((class_364)new Label(LEFT, row += 20))).getStyle().setText("unicopia.options.world");
            UnicopiaWorldProperties tribes = UnicopiaWorldProperties.forWorld((class_3218)server.method_3760().method_14602(class_310.method_1551().field_1724.method_5667()).method_37908());
            ((Slider)this.content.addButton((class_364)new Slider(LEFT, row += 20, 0.0f, (float)races.size(), (float)races.indexOf(tribes.getDefaultRace())))).onChange(races.createSetter((IField.IChangeCallback<Race>)((IField.IChangeCallback)tribes::setDefaultRace))).setTextFormat(v -> class_2561.method_43469((String)"unicopia.options.world.default_race", (Object[])new Object[]{((Race)races.valueOf(((Float)v.getValue()).floatValue())).getDisplayName()})).setEnabled(this.field_22787.method_1542());
        }
    }

    private class_2561 getMineLPStatus() {
        boolean hasMineLP = FabricLoader.getInstance().isModLoaded("minelp");
        if (hasMineLP) {
            if (((Boolean)this.config.ignoreMineLP.get()).booleanValue()) {
                return class_2561.method_43471((String)"unicopia.options.ignore_mine_lp.undetected").method_27692(class_124.field_1077);
            }
            return class_2561.method_43469((String)"unicopia.options.ignore_mine_lp.detected", (Object[])new Object[]{MineLPDelegate.getInstance().getPlayerPonyRace().getDisplayName()}).method_27692(class_124.field_1060);
        }
        return class_2561.method_43471((String)"unicopia.options.ignore_mine_lp.missing").method_27692(class_124.field_1061);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float tickDelta) {
        super.method_25394(context, mouseX, mouseY, tickDelta);
        this.content.method_25394(context, mouseX, mouseY, tickDelta);
        if (this.drawingHudOutline > System.currentTimeMillis()) {
            int scaledWidth = this.field_22787.method_22683().method_4486();
            int scaledHeight = this.field_22787.method_22683().method_4502();
            HudPosition selectedPos = (HudPosition)((Object)this.config.hudPosition.get());
            for (HudPosition hudPos : HudPosition.values()) {
                HudPosition.Alignment armAlignment;
                HudPosition.Alignment alignment = armAlignment = this.field_22787.field_1690.method_42552().method_41753() == class_1306.field_6182 ? HudPosition.Alignment.START : HudPosition.Alignment.END;
                if (hudPos == HudPosition.OFF_HAND) {
                    armAlignment = armAlignment.opposite();
                }
                int left = hudPos.getHorizontal().pick(2, scaledWidth - 50, (scaledWidth - 50) / 2 + 109 * armAlignment.getSignum());
                int top = hudPos.getVertical().pick(12, scaledHeight - 50, scaledHeight - 50);
                if (hudPos == HudPosition.BOTTOM_CENTER) {
                    top -= 22;
                }
                context.method_51448().method_22903();
                context.method_51448().method_46416((float)(left + 24), (float)(top + 24), 0.0f);
                DrawableUtil.drawArc(context.method_51448(), 0.0, 24.0, 0.0, 6.2831854820251465, hudPos == selectedPos ? -285278043 : -285212891);
                context.method_51448().method_22909();
            }
        }
    }

    public void method_25432() {
        this.config.save();
    }
}

