/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.particle;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.client.particle.AbstractBillboardParticle;
import com.minelittlepony.unicopia.client.render.RenderUtil;
import com.minelittlepony.unicopia.client.render.bezier.BezierSegment;
import com.minelittlepony.unicopia.client.render.bezier.Trail;
import com.minelittlepony.unicopia.particle.TargetBoundParticleEffect;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;

public class RainbowTrailParticle
extends AbstractBillboardParticle {
    private static final class_2960 TEXTURE = Unicopia.id("textures/particles/rainboom_trail.png");
    private final BezierSegment bezier = new BezierSegment();
    private final Trail trail;
    @Nullable
    private class_1297 target;
    private boolean isAbility;

    public RainbowTrailParticle(TargetBoundParticleEffect effect, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.trail = new Trail(new class_243(x, y, z), 1.0f);
        this.method_3077(300);
        this.field_3852 = velocityX;
        this.field_3869 = velocityY;
        this.field_3850 = velocityZ;
        this.target = effect.targetId() <= 0 ? (class_1297)world.method_8335(null, class_238.method_29968((class_243)this.trail.pos)).get(0) : world.method_8469(effect.targetId());
        this.isAbility = Caster.of(this.target).filter(caster -> SpellType.RAINBOOM.isOn((Caster<?>)caster)).isPresent();
    }

    @Override
    protected class_2960 getTexture() {
        return TEXTURE;
    }

    public boolean method_3086() {
        return this.field_3866 < this.method_3082() && (!this.field_3843 || !this.trail.getSegments().isEmpty());
    }

    @Override
    protected void renderQuads(class_289 te, float x, float y, float z, float tickDelta) {
        float alpha = this.field_3841 * (1.0f - (float)this.field_3866 / (float)this.field_3847);
        int light = this.method_3068(tickDelta);
        float scale = this.getScale(tickDelta);
        List<Trail.Segment> segments = this.trail.getSegments();
        class_287 buffer = null;
        for (int i = 0; i < segments.size() - 1; ++i) {
            segments.get(i).getPlane(segments.get(i + 1), this.bezier);
            for (RenderUtil.Vertex corner : this.bezier.corners()) {
                corner.position().mul(scale).add(x, y, z);
            }
            if (buffer == null) {
                RenderSystem.setShader(class_757::method_34543);
                buffer = te.method_60827(class_293.class_5596.field_27382, class_290.field_1584);
            }
            this.quad(buffer, this.bezier.corners(), segments.get(i).getAlpha() * alpha, tickDelta, light);
        }
        if (buffer != null) {
            class_286.method_43433((class_9801)buffer.method_60800());
        }
    }

    public void method_3070() {
        super.method_3070();
        if (this.target != null && this.target.method_5805()) {
            if (this.isAbility) {
                this.field_3866 = 0;
            }
            this.trail.update(this.target.method_33571());
            if (this.isAbility && Caster.of(this.target).filter(caster -> SpellType.RAINBOOM.isOn((Caster<?>)caster)).isEmpty()) {
                this.target = null;
            }
        }
        if (this.trail.tick()) {
            this.method_3085();
        }
    }
}

