/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.particle;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.client.particle.AbstractBillboardParticle;
import com.minelittlepony.unicopia.client.render.RenderUtil;
import com.minelittlepony.unicopia.client.render.bezier.BezierSegment;
import com.minelittlepony.unicopia.client.render.bezier.Trail;
import com.minelittlepony.unicopia.particle.TargetBoundParticleEffect;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;

public class WindParticle
extends AbstractBillboardParticle {
    private static final class_2960 TEXTURE = Unicopia.id("textures/particle/wind.png");
    private final BezierSegment bezier = new BezierSegment();
    private final Trail trail;
    @Nullable
    private class_1297 target;
    private int attachmentTicks;
    private final class_243 offset;
    private final boolean passive;

    public WindParticle(TargetBoundParticleEffect effect, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.trail = new Trail(new class_243(x, y, z), 0.02f);
        this.method_3077(300);
        this.field_3841 = 0.15f;
        this.field_3852 = velocityX;
        this.field_3869 = velocityY;
        this.field_3850 = velocityZ;
        this.attachmentTicks = (int)world.field_9229.method_43385(15.0, 12.0);
        this.passive = effect.targetId() <= 0;
        this.field_3862 = false;
        if (effect.targetId() > 0) {
            this.target = world.method_8469(effect.targetId());
        }
        this.offset = this.target == null ? class_243.field_1353 : new class_243(x, y, z).method_1020(this.target.method_19538());
    }

    @Override
    protected class_2960 getTexture() {
        return TEXTURE;
    }

    public boolean method_3086() {
        return this.field_3866 < this.method_3082() && (!this.field_3843 || !this.trail.getSegments().isEmpty());
    }

    @Override
    protected void renderQuads(class_289 te, float x, float y, float z, float tickDelta) {
        float alpha = this.field_3841 * (1.0f - (float)this.field_3866 / (float)this.field_3847);
        int light = this.method_3068(tickDelta);
        float scale = this.getScale(tickDelta);
        List<Trail.Segment> segments = this.trail.getSegments();
        class_287 buffer = null;
        for (int i = 0; i < segments.size() - 1; ++i) {
            segments.get(i).getPlane(segments.get(i + 1), this.bezier);
            for (RenderUtil.Vertex corner : this.bezier.corners()) {
                corner.position().mul(scale).add(x, y, z);
            }
            if (buffer == null) {
                RenderSystem.setShader(class_757::method_34543);
                buffer = te.method_60827(class_293.class_5596.field_27382, class_290.field_1584);
            }
            this.quad(buffer, this.bezier.corners(), segments.get(i).getAlpha() * alpha, tickDelta, light);
        }
        if (buffer != null) {
            class_286.method_43433((class_9801)buffer.method_60800());
        }
    }

    public void method_3070() {
        super.method_3070();
        float animationFrame = (float)this.field_3866 + class_310.method_1551().method_60646().method_60637(false);
        float sin = class_3532.method_15374((float)(animationFrame / 5.0f)) * 0.1f;
        float cos = class_3532.method_15362((float)(animationFrame / 10.0f)) * 0.2f;
        if (this.passive) {
            this.trail.update(new class_243(this.field_3874 + (double)cos, this.field_3854 + (double)sin, this.field_3871 - (double)cos));
        } else if (this.target != null && this.target.method_5805()) {
            this.trail.update(this.target.method_19538().method_1019(this.target.method_5663().method_1021(-7.0)).method_1019(this.offset).method_1031((double)cos, (double)sin, (double)(-cos)));
            if (this.attachmentTicks > 0 && --this.attachmentTicks <= 0) {
                this.target = null;
            }
        }
        if (this.trail.tick()) {
            this.method_3085();
        }
    }
}

