/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render.bezier;

import com.minelittlepony.unicopia.client.render.RenderUtil;
import java.util.function.Consumer;
import org.joml.Vector3f;

public record BezierSegment(RenderUtil.Vertex[] corners) {
    public BezierSegment() {
        this(new RenderUtil.Vertex[]{new RenderUtil.Vertex(), new RenderUtil.Vertex(), new RenderUtil.Vertex(), new RenderUtil.Vertex()});
    }

    public void set(Vector3f from, Vector3f to, float height) {
        this.corners[0].set(from.x, from.y - height / 2.0f, from.z, 0.0f, 0.0f);
        this.corners[1].set(from.x, from.y + height / 2.0f, from.z, 1.0f, 0.0f);
        this.corners[2].set(to.x, to.y + height / 2.0f, to.z, 1.0f, 1.0f);
        this.corners[3].set(to.x, to.y - height / 2.0f, to.z, 0.0f, 1.0f);
    }

    public void forEachCorner(Consumer<RenderUtil.Vertex> transformer) {
        for (RenderUtil.Vertex corner : this.corners) {
            transformer.accept(corner);
        }
    }
}

