/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render.entity;

import com.minelittlepony.unicopia.entity.mob.AirBalloonEntity;
import java.util.List;
import net.minecraft.class_1690;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;

public class AirBalloonEntityModel
extends class_583<AirBalloonEntity> {
    private final class_630 root;
    private class_630 main;
    private float inflation;
    private boolean isBurner;
    private boolean isBalloon;
    private boolean isSandbags;
    private final List<class_630> ropes;
    private final List<class_630> struts;
    private final List<class_630> sandbags;

    public AirBalloonEntityModel(class_630 root) {
        this.root = root;
        this.isBurner = root.method_41919("burner");
        this.isSandbags = root.method_41919("sandbag_ne");
        this.isBalloon = root.method_41919("canopy");
        if (this.isBurner || this.isBalloon) {
            this.main = root.method_32086(this.isBalloon ? "canopy" : "burner");
            this.ropes = List.of((this.isBurner ? root : this.main).method_32086("rope_a"), (this.isBurner ? root : this.main).method_32086("rope_b"), (this.isBurner ? root : this.main).method_32086("rope_c"), (this.isBurner ? root : this.main).method_32086("rope_d"));
        } else {
            this.ropes = List.of();
        }
        this.struts = this.isBurner ? List.of(root.method_32086("strut_a"), root.method_32086("strut_b")) : List.of();
        this.sandbags = this.isSandbags ? List.of(root.method_32086("sandbag_nw"), root.method_32086("sandbag_sw"), root.method_32086("sandbag_ne"), root.method_32086("sandbag_se")) : List.of();
    }

    public static class_5607 getBasketModelData() {
        class_5609 modelData = new class_5609();
        class_5610 root = modelData.method_32111();
        class_5610 basket = root.method_32117("basket", class_5606.method_32108().method_32101(0, 0).method_32098(-16.0f, -1.0f, -16.0f, 32.0f, 2.0f, 30.0f, class_5605.field_27715), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        basket.method_32117("walls", class_5606.method_32108().method_32101(0, 66).method_32098(-17.0f, -12.0f, -16.0f, 2.0f, 11.0f, 30.0f, class_5605.field_27715).method_32101(64, 68).method_32098(15.0f, -12.0f, -16.0f, 2.0f, 11.0f, 30.0f, class_5605.field_27715).method_32101(80, 38).method_32098(-16.0f, -12.0f, -17.0f, 32.0f, 11.0f, 2.0f, class_5605.field_27715).method_32101(0, 32).method_32098(8.0f, -12.0f, 13.0f, 8.0f, 11.0f, 2.0f, class_5605.field_27715).method_32101(0, 6).method_32098(-16.0f, -12.0f, 13.0f, 8.0f, 11.0f, 2.0f, class_5605.field_27715), class_5603.field_27701);
        basket.method_32117("rim", class_5606.method_32108().method_32101(40, 34).method_32098(-18.0f, -13.0f, -17.0f, 4.0f, 2.0f, 32.0f, class_5605.field_27715).method_32101(0, 32).method_32098(14.0f, -13.0f, -17.0f, 4.0f, 2.0f, 32.0f, class_5605.field_27715).method_32101(80, 32).method_32098(-17.0f, -13.0f, -18.0f, 34.0f, 2.0f, 4.0f, class_5605.field_27715).method_32101(0, 19).method_32098(7.0f, -13.0f, 12.0f, 10.0f, 2.0f, 4.0f, class_5605.field_27715).method_32101(0, 0).method_32098(-17.0f, -13.0f, 12.0f, 10.0f, 2.0f, 4.0f, class_5605.field_27715), class_5603.field_27701);
        return class_5607.method_32110((class_5609)modelData, (int)256, (int)128);
    }

    public static class_5607 getBurnerModelData() {
        class_5609 modelData = new class_5609();
        class_5610 root = modelData.method_32111();
        root.method_32117("burner", class_5606.method_32108().method_32101(8, 0).method_32098(-5.5f, -47.0f, -5.5f, 11.0f, 15.0f, 11.0f, class_5605.field_27715), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        float angle = 0.37854f;
        float half = 1.5707964f;
        root.method_32117("rope_d", class_5606.method_32108().method_32098(0.0f, -68.0f, 0.0f, 2.0f, 66.0f, 2.0f, class_5605.field_27715), class_5603.method_32091((float)0.0f, (float)-20.0f, (float)0.0f, (float)angle, (float)0.0f, (float)(-angle)));
        root.method_32117("rope_c", class_5606.method_32108().method_32098(0.0f, -68.0f, 0.0f, 2.0f, 66.0f, 2.0f, class_5605.field_27715), class_5603.method_32091((float)0.0f, (float)-20.0f, (float)0.0f, (float)(-angle), (float)0.0f, (float)(-angle)));
        root.method_32117("rope_b", class_5606.method_32108().method_32098(0.0f, -68.0f, 0.0f, 2.0f, 66.0f, 2.0f, class_5605.field_27715), class_5603.method_32091((float)0.0f, (float)-20.0f, (float)0.0f, (float)(-angle), (float)0.0f, (float)angle));
        root.method_32117("rope_a", class_5606.method_32108().method_32098(0.0f, -68.0f, 0.0f, 2.0f, 66.0f, 2.0f, class_5605.field_27715), class_5603.method_32091((float)0.0f, (float)-20.0f, (float)0.0f, (float)angle, (float)0.0f, (float)angle));
        root.method_32117("strut_a", class_5606.method_32108().method_32098(-27.0f, -40.0f, -30.0f, 2.0f, 40.0f, 2.0f, class_5605.field_27715).method_32098(-27.0f, 0.0f, -30.0f, 2.0f, 40.0f, 2.0f, class_5605.field_27715).method_32098(27.0f, -40.0f, -30.0f, 2.0f, 40.0f, 2.0f, class_5605.field_27715).method_32098(27.0f, 0.0f, -30.0f, 2.0f, 40.0f, 2.0f, class_5605.field_27715).method_32098(-27.0f, -40.0f, 26.0f, 2.0f, 40.0f, 2.0f, class_5605.field_27715).method_32098(-27.0f, 0.0f, 26.0f, 2.0f, 40.0f, 2.0f, class_5605.field_27715).method_32098(27.0f, -40.0f, 26.0f, 2.0f, 40.0f, 2.0f, class_5605.field_27715).method_32098(27.0f, 0.0f, 26.0f, 2.0f, 40.0f, 2.0f, class_5605.field_27715), class_5603.method_32091((float)0.0f, (float)-80.0f, (float)0.0f, (float)half, (float)0.0f, (float)0.0f));
        root.method_32117("strut_b", class_5606.method_32108().method_32098(-27.0f, -40.0f, -20.0f, 2.0f, 40.0f, 2.0f, class_5605.field_27715).method_32098(-27.0f, 0.0f, -20.0f, 2.0f, 40.0f, 2.0f, class_5605.field_27715).method_32098(27.0f, -40.0f, -20.0f, 2.0f, 40.0f, 2.0f, class_5605.field_27715).method_32098(27.0f, 0.0f, -20.0f, 2.0f, 40.0f, 2.0f, class_5605.field_27715).method_32098(-27.0f, -40.0f, 30.0f, 2.0f, 40.0f, 2.0f, class_5605.field_27715).method_32098(-27.0f, 0.0f, 30.0f, 2.0f, 40.0f, 2.0f, class_5605.field_27715).method_32098(27.0f, -40.0f, 30.0f, 2.0f, 40.0f, 2.0f, class_5605.field_27715).method_32098(27.0f, 0.0f, 30.0f, 2.0f, 40.0f, 2.0f, class_5605.field_27715), class_5603.method_32091((float)0.0f, (float)-80.0f, (float)0.0f, (float)half, (float)half, (float)0.0f));
        return class_5607.method_32110((class_5609)modelData, (int)64, (int)128);
    }

    public static class_5607 getCanopyModelData() {
        class_5609 modelData = new class_5609();
        class_5610 root = modelData.method_32111();
        class_5610 balloon = root.method_32117("canopy", class_5606.method_32108().method_32098(-54.0f, -178.0f, -59.0f, 112.0f, 120.0f, 112.0f, class_5605.field_27715), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        balloon.method_32117("rope_d", class_5606.method_32108().method_32098(-2.0f, -68.0f, 0.0f, 2.0f, 68.0f, 2.0f, class_5605.field_27715), class_5603.method_32091((float)-14.0f, (float)-11.0f, (float)-16.0f, (float)0.4363f, (float)0.0f, (float)-0.4363f));
        balloon.method_32117("rope_c", class_5606.method_32108().method_32098(-2.0f, -68.0f, 0.0f, 2.0f, 68.0f, 2.0f, class_5605.field_27715), class_5603.method_32091((float)-14.0f, (float)-11.0f, (float)11.0f, (float)-0.4363f, (float)0.0f, (float)-0.4363f));
        balloon.method_32117("rope_b", class_5606.method_32108().method_32098(-2.0f, -68.0f, 0.0f, 2.0f, 68.0f, 2.0f, class_5605.field_27715), class_5603.method_32091((float)17.0f, (float)-11.0f, (float)11.0f, (float)-0.4363f, (float)0.0f, (float)0.4363f));
        balloon.method_32117("rope_a", class_5606.method_32108().method_32098(-2.0f, -68.0f, 0.0f, 2.0f, 68.0f, 2.0f, class_5605.field_27715), class_5603.method_32091((float)17.0f, (float)-11.0f, (float)-16.0f, (float)0.4363f, (float)0.0f, (float)0.4363f));
        return class_5607.method_32110((class_5609)modelData, (int)512, (int)256);
    }

    public static class_5607 getSandbagsModelData() {
        class_5609 modelData = new class_5609();
        class_5610 root = modelData.method_32111();
        float offset = 40.0f;
        AirBalloonEntityModel.getHangingBagModelData("sandbag_ne", root, -offset, -offset);
        AirBalloonEntityModel.getHangingBagModelData("sandbag_nw", root, -offset, offset);
        AirBalloonEntityModel.getHangingBagModelData("sandbag_se", root, offset, -offset);
        AirBalloonEntityModel.getHangingBagModelData("sandbag_sw", root, offset, offset);
        return class_5607.method_32110((class_5609)modelData, (int)32, (int)32);
    }

    public static void getHangingBagModelData(String name, class_5610 root, float x, float z) {
        class_5610 bag = root.method_32117(name, class_5606.method_32108().method_32101(16, 19).method_32098(-0.5f, 0.0f, -0.5f, 1.0f, 9.0f, 1.0f, class_5605.field_27715), class_5603.method_32090((float)x, (float)-35.0f, (float)z));
        class_5610 knot = bag.method_32117("knot", class_5606.method_32108().method_32101(0, 0).method_32098(-3.0f, 1.0f, -3.0f, 6.0f, 7.0f, 6.0f, class_5605.field_27715).method_32101(12, 14).method_32098(-2.0f, 0.0f, -2.0f, 4.0f, 1.0f, 4.0f, class_5605.field_27715).method_32101(0, 13).method_32098(-2.0f, 8.0f, -2.0f, 4.0f, 1.0f, 4.0f, class_5605.field_27715), class_5603.method_32090((float)0.0f, (float)9.0f, (float)0.0f));
        knot.method_32117("cube_r1", class_5606.method_32108().method_32101(8, 14).method_32098(0.0f, 8.0f, -2.0f, 0.0f, 4.0f, 4.0f, class_5605.field_27715), class_5603.method_32091((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        knot.method_32117("cube_r2", class_5606.method_32108().method_32101(8, 14).method_32098(0.0f, 8.0f, -2.0f, 0.0f, 4.0f, 4.0f, class_5605.field_27715), class_5603.method_32091((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
    }

    public void setAngles(AirBalloonEntity entity, float limbDistance, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float tickDelta = class_310.method_1551().method_60646().method_60637(false);
        this.inflation = entity.getInflation(tickDelta);
        this.root.field_3675 = (float)Math.PI;
        if (this.isSandbags) {
            this.root.field_3675 -= entity.method_5735().method_10144() * ((float)Math.PI / 180);
        }
        float burnerWiggleProgress = entity.getBurner().getPullProgress(tickDelta);
        if (this.isBurner || this.isBalloon || this.isSandbags) {
            this.root.field_3674 = class_3532.method_15363((float)entity.getXVelocity(tickDelta), (float)-0.5f, (float)0.5f);
            this.root.field_3654 = class_3532.method_15363((float)entity.getZVelocity(tickDelta), (float)-0.5f, (float)0.5f);
            if (entity.method_60953()) {
                this.root.field_3674 *= -1.0f;
                this.root.field_3654 *= -1.0f;
            }
        } else {
            this.root.field_3654 = 0.0f;
            this.root.field_3674 = 0.0f;
        }
        this.ropes.forEach(class_630::method_41923);
        if (this.isBurner) {
            boolean lifted = this.inflation > 0.8f;
            this.root.field_3656 = 32.0f * (1.0f - this.inflation) - 9.0f * this.inflation;
            this.root.field_3657 = this.inflation * class_3532.method_15374((float)(limbSwingAmount + (float)entity.field_6012 / 5.0f)) / 4.0f;
            this.ropes.forEach(rope -> {
                rope.field_3665 = lifted;
            });
            this.struts.forEach(strut -> {
                strut.field_3665 = lifted;
            });
            this.root.field_3657 += burnerWiggleProgress * class_3532.method_15374((float)((float)entity.field_6012 + tickDelta)) * 2.5f;
            this.root.field_3657 += burnerWiggleProgress * class_3532.method_15362((float)((float)entity.field_6012 + tickDelta)) * 2.5f;
            this.root.field_3656 += burnerWiggleProgress * 7.0f;
        }
        if (this.isBalloon || this.isSandbags) {
            this.root.field_3656 = burnerWiggleProgress * 3.0f;
            this.root.field_3657 = this.inflation * class_3532.method_15362((float)(limbSwingAmount + (float)entity.field_6012 / 5.0f)) / 4.0f;
            if (entity.getBasketType().isOf(class_1690.class_1692.field_40161)) {
                this.ropes.forEach(rope -> {
                    rope.field_3656 = 0.0f;
                });
            }
        }
        if (this.isSandbags) {
            float cosWiggle = class_3532.method_15362((float)(limbSwingAmount + (float)entity.field_6012 / 5.0f)) / 80.0f;
            float sinWiggle = class_3532.method_15374((float)(limbSwingAmount + (float)entity.field_6012 / 5.0f)) / 80.0f;
            for (int i = 0; i < this.sandbags.size(); ++i) {
                float pullAmount;
                class_630 bag = this.sandbags.get(i);
                float pullProgress = entity.getSandbag(i).getPullProgress(tickDelta);
                bag.method_41923();
                bag.field_3654 -= this.root.field_3654 * 2.5f * (1.0f + pullProgress) + cosWiggle;
                bag.field_3674 -= this.root.field_3674 * 2.5f * (1.0f + pullProgress) + sinWiggle;
                if (entity.method_60953()) {
                    bag.field_3674 *= -1.0f;
                    bag.field_3654 *= -1.0f;
                }
                bag.field_37939 = pullAmount = 2.0f + 2.0f * pullProgress;
                bag.method_32086((String)"knot").field_37939 = 1.0f / pullAmount;
            }
        }
        for (int i = 0; i < this.ropes.size(); ++i) {
            class_630 rope2 = this.ropes.get(i);
            float rollRatio = this.root.field_3674 / rope2.field_3674;
            float pitchRatio = this.root.field_3654 / rope2.field_3654;
            rope2.field_3656 -= 5.0f * rollRatio;
            rope2.field_3656 -= 5.0f * pitchRatio;
            if (i == 0 || i == 3) {
                rope2.field_3655 -= 5.0f * pitchRatio;
            }
            if (i == 2 || i == 1) {
                rope2.field_3655 += 5.0f * pitchRatio;
            }
            if (i == 2 || i == 3) {
                rope2.field_3657 -= 5.0f * rollRatio;
            }
            if (i == 0 || i == 1) {
                rope2.field_3657 += 5.0f * rollRatio;
            }
            if (this.isBalloon) {
                double speed = Math.abs(entity.method_18798().method_10214()) * 3.0;
                rope2.field_37940 = class_3532.method_15363((float)((float)speed), (float)0.25f, (float)1.0f);
                rope2.field_37938 = 0.001f;
                continue;
            }
            rope2.field_37938 = 0.3f;
            rope2.field_37940 = 0.3f;
        }
    }

    public void method_2828(class_4587 matrices, class_4588 vertexConsumer, int light, int overlay, int color) {
        if (this.isBalloon) {
            matrices.method_22903();
            matrices.method_46416(0.0f, 1.0f * (1.0f - this.inflation), 0.0f);
            matrices.method_22905(1.0f, class_3532.method_16439((float)this.inflation, (float)-0.05f, (float)1.0f), 1.0f);
            this.root.method_22699(matrices, vertexConsumer, light, class_4608.field_21444, color);
            matrices.method_22909();
        } else {
            this.root.method_22699(matrices, vertexConsumer, light, class_4608.field_21444, color);
        }
    }
}

