/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render.entity;

import com.minelittlepony.common.util.Color;
import com.minelittlepony.unicopia.block.ItemJarBlock;
import com.minelittlepony.unicopia.block.jar.EntityJarContents;
import com.minelittlepony.unicopia.block.jar.FakeFluidJarContents;
import com.minelittlepony.unicopia.block.jar.ItemsJarContents;
import com.minelittlepony.unicopia.client.render.model.CubeModel;
import com.minelittlepony.unicopia.util.FluidHelper;
import com.minelittlepony.unicopia.util.PosHelper;
import java.util.Arrays;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_898;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;

public class ItemJarBlockEntityRenderer
implements class_827<ItemJarBlock.TileData> {
    private static final class_2350[] GLASS_SIDES = (class_2350[])Arrays.stream(PosHelper.ALL).filter(i -> i != class_2350.field_11036).toArray(class_2350[]::new);
    private final class_918 itemRenderer;
    private final class_898 dispatcher;

    public ItemJarBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.itemRenderer = ctx.method_43335();
        this.dispatcher = ctx.method_43334();
    }

    public void render(ItemJarBlock.TileData data, float tickDelta, class_4587 matrices, class_4597 vertices, int light, int overlay) {
        FakeFluidJarContents milk;
        ItemJarBlock.FluidJarContents fluid;
        EntityJarContents entity;
        ItemsJarContents items = data.getItems();
        if (items != null) {
            this.renderItemStacks(data, items, tickDelta, matrices, vertices, light, overlay);
        }
        if ((entity = data.getEntity()) != null) {
            this.renderEntity(data, entity, tickDelta, matrices, vertices, light, overlay);
        }
        if ((fluid = data.getFluid()) != null) {
            this.renderFluid(data, fluid, tickDelta, matrices, vertices, light, overlay);
        }
        if ((milk = data.getFakeFluid()) != null) {
            this.renderFluid(data, class_3612.field_15910.method_15785(), milk.color(), 81000L, tickDelta, matrices, vertices, light, overlay);
        }
    }

    private void renderItemStacks(ItemJarBlock.TileData data, ItemsJarContents items, float tickDelta, class_4587 matrices, class_4597 vertices, int light, int overlay) {
        float itemScale = 0.35f;
        matrices.method_22903();
        matrices.method_22904(0.5, 0.0, 0.5);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        matrices.method_22905(itemScale, itemScale, itemScale);
        class_5819 rng = class_5819.method_43049((long)data.method_11016().method_10063());
        float y = 0.0f;
        for (class_1799 stack : items.stacks()) {
            matrices.method_22903();
            matrices.method_22904((double)((rng.method_43057() - 0.5f) * 0.5f), (double)((rng.method_43057() - 0.5f) * 0.8f), -0.05 + (double)y);
            matrices.method_22907(class_7833.field_40714.rotationDegrees(rng.method_43057() * 360.0f - 180.0f));
            matrices.method_22907(class_7833.field_40718.rotationDegrees(rng.method_43057() * 360.0f - 180.0f));
            y -= 0.1f;
            this.itemRenderer.method_23178(stack, class_811.field_4319, light, overlay, matrices, vertices, data.method_10997(), 0);
            matrices.method_22909();
        }
        matrices.method_22909();
    }

    private void renderEntity(ItemJarBlock.TileData data, EntityJarContents entity, float tickDelta, class_4587 matrices, class_4597 vertices, int light, int overlay) {
        class_1297 e = entity.entity().get();
        if (e != null) {
            class_746 player = class_310.method_1551().field_1724;
            int age = player == null ? 0 : player.field_6012;
            float fullTick = (float)age + tickDelta;
            float size = Math.max(e.method_17681(), e.method_17682());
            float desiredSize = 0.25f;
            float scale = desiredSize / size;
            float eyePos = e.method_18381(e.method_18376()) * scale;
            float yaw = 0.0f;
            if (player != null) {
                class_243 center = data.method_11016().method_46558();
                class_243 observerPos = class_310.method_1551().field_1773.method_19418().method_19326();
                e.method_33574(center);
                e.method_5702(class_2183.class_2184.field_9853, observerPos);
            }
            matrices.method_22903();
            matrices.method_22904(0.5, 0.48 + (double)(class_3532.method_15374((float)(fullTick / 19.0f)) * 0.02f) - (double)eyePos, 0.5);
            matrices.method_22905(scale, scale, scale);
            matrices.method_22907(class_7833.field_40714.rotationDegrees(10.0f * class_3532.method_15374((float)(fullTick / 19.0f))));
            this.dispatcher.method_3954(e, 0.0, 0.0, 0.0, yaw * ((float)Math.PI / 180), tickDelta, matrices, vertices, light);
            matrices.method_22909();
        }
    }

    private void renderFluid(ItemJarBlock.TileData data, ItemJarBlock.FluidJarContents fluid, float tickDelta, class_4587 matrices, class_4597 vertices, int light, int overlay) {
        class_3610 state = FluidHelper.getFullFluidState(fluid.fluid());
        int color = this.getFluidColor(data.method_10997(), data.method_11016(), state);
        this.renderFluid(data, state, color, fluid.amount(), tickDelta, matrices, vertices, light, overlay);
    }

    private void renderFluid(ItemJarBlock.TileData data, class_3610 state, int color, long amount, float tickDelta, class_4587 matrices, class_4597 vertices, int light, int overlay) {
        class_1058[] sprite = this.getFluidSprite(data.method_10997(), data.method_11016(), state);
        matrices.method_22903();
        class_1058 topSprite = sprite[0];
        float height = 0.6f * ((float)amount / 81000.0f);
        boolean opaque = Color.a((int)color) >= 1.0f;
        CubeModel.render(matrices, vertices.getBuffer(opaque ? class_1921.method_23572((class_2960)topSprite.method_45852()) : class_1921.method_23580((class_2960)topSprite.method_45852())), topSprite.method_4594(), topSprite.method_4593(), topSprite.method_4577(), topSprite.method_4575(), 0.28f, 0.01f, 0.28f, 0.73f, 0.01f + height, 0.73f, color | 0xFF000000, light, overlay, class_2350.field_11036);
        class_1058 sideSprite = sprite[sprite.length - 1];
        CubeModel.render(matrices, vertices.getBuffer(opaque ? class_1921.method_23572((class_2960)sideSprite.method_45852()) : class_1921.method_23580((class_2960)sideSprite.method_45852())), sideSprite.method_4594(), sideSprite.method_4593(), sideSprite.method_4577(), sideSprite.method_4575(), 0.28f, 0.01f, 0.28f, 0.73f, 0.01f + height, 0.73f, color | 0xFF000000, light, overlay, GLASS_SIDES);
        matrices.method_22909();
    }

    private int getFluidColor(class_1937 world, class_2338 pos, class_3610 state) {
        return this.getFluidHandler(state.method_15772()).getFluidColor((class_1920)world, pos, state);
    }

    private class_1058[] getFluidSprite(@Nullable class_1937 world, class_2338 pos, class_3610 state) {
        return this.getFluidHandler(state.method_15772()).getFluidSprites((class_1920)world, pos, state);
    }

    private FluidRenderHandler getFluidHandler(class_3611 fluid) {
        FluidRenderHandler handler = FluidRenderHandlerRegistry.INSTANCE.get(fluid);
        if (handler == null) {
            return FluidRenderHandlerRegistry.INSTANCE.get((class_3611)class_3612.field_15910);
        }
        return handler;
    }
}

