/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render.entity;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.client.render.entity.SpellbookModel;
import com.minelittlepony.unicopia.entity.mob.SpellbookEntity;
import com.minelittlepony.unicopia.server.world.Altar;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import net.minecraft.class_922;
import org.joml.Matrix4f;

public class SpellbookEntityRenderer
extends class_922<SpellbookEntity, SpellbookModel> {
    private static final class_2960 TEXTURE = Unicopia.id("textures/entity/spellbook/normal.png");
    private static final class_2960 ALTAR_BEAM_TEXTURE = class_2960.method_60656((String)"textures/entity/end_crystal/end_crystal_beam.png");

    public SpellbookEntityRenderer(class_5617.class_5618 context) {
        super(context, (class_583)new SpellbookModel(SpellbookModel.getTexturedModelData().method_32109()), 0.0f);
        this.method_4046(new AltarBeamFeature((class_3883<SpellbookEntity, SpellbookModel>)this));
    }

    public class_2960 getTexture(SpellbookEntity entity) {
        return TEXTURE;
    }

    protected float getLyingAngle(SpellbookEntity entity) {
        return 0.0f;
    }

    protected void setupTransforms(SpellbookEntity entity, class_4587 matrices, float animationProgress, float bodyYaw, float tickDelta, float scale) {
        super.method_4058((class_1309)entity, matrices, animationProgress, bodyYaw + 90.0f, tickDelta, scale);
        if (entity.isOpen()) {
            matrices.method_46416(-1.25f, -0.35f, 0.0f);
            float floatPosition = class_3532.method_15374((float)((animationProgress + (float)entity.method_5628()) / 20.0f)) * 0.04f;
            matrices.method_46416(0.0f, floatPosition, 0.0f);
            matrices.method_22907(class_7833.field_40717.rotationDegrees(60.0f));
        } else {
            matrices.method_46416(-1.5f, 0.1f, 0.2f);
            matrices.method_22907(class_7833.field_40717.rotationDegrees(90.0f));
            matrices.method_22907(class_7833.field_40715.rotationDegrees(90.0f));
        }
    }

    protected boolean hasLabel(SpellbookEntity targetEntity) {
        return super.method_4055((class_1309)targetEntity) && (targetEntity.method_5807() || targetEntity.method_16914() && targetEntity == this.field_4676.field_4678);
    }

    public static void renderBeam(class_243 offset, float tickDelta, int age, class_4587 matrices, class_4597 buffers, int light, float r, float g, float b) {
        float horizontalDistance = (float)offset.method_37267();
        float distance = (float)offset.method_1033();
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40716.rotation((float)(-Math.atan2(offset.field_1350, offset.field_1352)) - 1.5707964f));
        matrices.method_22907(class_7833.field_40714.rotation((float)(-Math.atan2(horizontalDistance, offset.field_1351)) - 1.5707964f));
        class_4588 buffer = buffers.getBuffer(class_1921.method_23580((class_2960)ALTAR_BEAM_TEXTURE));
        float minV = -((float)age + tickDelta) * 0.01f;
        float maxV = minV + distance / 32.0f;
        int sides = 8;
        float diameter = 0.35f;
        float segmentX = 0.0f;
        float segmentY = 0.35f;
        float minU = 0.0f;
        class_4587.class_4665 entry = matrices.method_23760();
        Matrix4f positionMat = entry.method_23761();
        for (int i = 1; i <= 8; ++i) {
            float o = class_3532.method_15374((float)((float)i * ((float)Math.PI * 2) / 8.0f)) * 0.35f;
            float p = class_3532.method_15362((float)((float)i * ((float)Math.PI * 2) / 8.0f)) * 0.35f;
            float maxU = (float)i / 8.0f;
            buffer.method_22918(positionMat, segmentX * 0.2f, segmentY * 0.2f, 0.0f).method_1336(0, 0, 0, 255).method_22913(minU, minV).method_22922(class_4608.field_21444).method_60803(light).method_60831(entry, 0.0f, -1.0f, 0.0f);
            buffer.method_22918(positionMat, segmentX, segmentY, distance).method_22915(r, g, b, 1.0f).method_22913(minU, maxV).method_22922(class_4608.field_21444).method_60803(light).method_60831(entry, 0.0f, -1.0f, 0.0f);
            buffer.method_22918(positionMat, o, p, distance).method_22915(r, g, b, 1.0f).method_22913(maxU, maxV).method_22922(class_4608.field_21444).method_60803(light).method_60831(entry, 0.0f, -1.0f, 0.0f);
            buffer.method_22918(positionMat, o * 0.2f, p * 0.2f, 0.0f).method_1336(0, 0, 0, 255).method_22913(maxU, minV).method_22922(class_4608.field_21444).method_60803(light).method_60831(entry, 0.0f, -1.0f, 0.0f);
            segmentX = o;
            segmentY = p;
            minU = maxU;
        }
        matrices.method_22909();
    }

    static class AltarBeamFeature
    extends class_3887<SpellbookEntity, SpellbookModel> {
        public AltarBeamFeature(class_3883<SpellbookEntity, SpellbookModel> context) {
            super(context);
        }

        public void render(class_4587 matrices, class_4597 vertices, int light, SpellbookEntity entity, float limbPos, float limbSpeed, float tickDelta, float animationProgress, float yaw, float pitch) {
            if (!entity.hasBeams()) {
                return;
            }
            matrices.method_23760();
            matrices.method_22909();
            matrices.method_22903();
            Altar altar = entity.getAltar().get();
            class_243 center = altar.origin().method_46558().method_1031(0.0, -1.0, 0.0);
            float x = (float)class_3532.method_16436((double)tickDelta, (double)entity.field_6014, (double)entity.method_23317());
            float y = (float)class_3532.method_16436((double)tickDelta, (double)entity.field_6036, (double)entity.method_23318());
            float z = (float)class_3532.method_16436((double)tickDelta, (double)entity.field_5969, (double)entity.method_23321());
            class_243 bookPos = new class_243((double)x, (double)y, (double)z);
            class_243 shift = bookPos.method_1020(center);
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            matrices.method_22904(shift.field_1352, shift.field_1351 - 1.0, shift.field_1350);
            for (class_2338 pillar : altar.pillars()) {
                SpellbookEntityRenderer.renderBeam(center.method_1020(pillar.method_46558()), -tickDelta, -entity.field_6012, matrices, vertices, light, 1.0f, 0.0f, 1.0f);
            }
            matrices.method_22909();
        }

        public static float getYOffset(float animationProgress) {
            animationProgress = class_3532.method_15374((float)(animationProgress * 0.2f)) * 0.5f + 0.5f;
            return (animationProgress * animationProgress + animationProgress) * 0.4f - 1.4f;
        }
    }
}

