/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.command;

import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.InteractionManager;
import com.minelittlepony.unicopia.ability.Abilities;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.ability.magic.spell.CastingMethod;
import com.minelittlepony.unicopia.ability.magic.spell.DispersableDisguiseSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2179;
import net.minecraft.class_2186;
import net.minecraft.class_2321;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;

public class DisguiseCommand {
    private static final SimpleCommandExceptionType FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.disguise.notfound"));

    public static LiteralArgumentBuilder<class_2168> create(class_7157 registries) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"disguise").requires(s -> s.method_9259(2))).executes(context -> DisguiseCommand.reveal((class_2168)context.getSource(), (class_1657)((class_2168)context.getSource()).method_44023()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9308()).then(DisguiseCommand.buildEntityDisguise(context -> class_2186.method_9315((CommandContext)context, (String)"target"), registries))).then(DisguiseCommand.buildPlayerDisguise(context -> class_2186.method_9315((CommandContext)context, (String)"target"))))).then(DisguiseCommand.buildEntityDisguise(context -> ((class_2168)context.getSource()).method_44023(), registries))).then(DisguiseCommand.buildPlayerDisguise(context -> ((class_2168)context.getSource()).method_44023()));
    }

    private static ArgumentBuilder<class_2168, ?> buildEntityDisguise(Arg<class_3222> targetOp, class_7157 registries) {
        return ((RequiredArgumentBuilder)class_2170.method_9244((String)"entity", (ArgumentType)class_7733.method_45603((class_7157)registries, (class_5321)class_7924.field_41266)).suggests(class_2321.field_10935).executes(context -> DisguiseCommand.disguise((class_2168)context.getSource(), (class_1657)targetOp.apply((CommandContext<class_2168>)context), DisguiseCommand.loadEntity((class_2168)context.getSource(), class_7733.method_45610((CommandContext)context, (String)"entity"), new class_2487())))).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> DisguiseCommand.disguise((class_2168)context.getSource(), (class_1657)targetOp.apply((CommandContext<class_2168>)context), DisguiseCommand.loadEntity((class_2168)context.getSource(), class_7733.method_45610((CommandContext)context, (String)"entity"), class_2179.method_9285((CommandContext)context, (String)"nbt")))));
    }

    private static ArgumentBuilder<class_2168, ?> buildPlayerDisguise(Arg<class_3222> targetOp) {
        return class_2170.method_9244((String)"playername", (ArgumentType)StringArgumentType.string()).executes(context -> DisguiseCommand.disguise((class_2168)context.getSource(), (class_1657)targetOp.apply((CommandContext<class_2168>)context), DisguiseCommand.loadPlayer((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"playername"))));
    }

    static int disguise(class_2168 source, class_1657 player, class_1297 entity) throws CommandSyntaxException {
        if (entity == null || !EquinePredicates.VALID_FOR_DISGUISE.test(entity)) {
            throw FAILED_EXCEPTION.create();
        }
        Pony iplayer = Pony.of(player);
        iplayer.getSpellSlot().get(SpellType.CHANGELING_DISGUISE).orElseGet(() -> {
            DispersableDisguiseSpell spell = SpellType.CHANGELING_DISGUISE.withTraits().apply(iplayer, CastingMethod.INNATE);
            if (!iplayer.canUse(Abilities.DISGUISE)) {
                spell.setForced();
            }
            return spell;
        }).setDisguise(entity);
        if (source.method_9228() == player) {
            source.method_9226(() -> class_2561.method_43469((String)"commands.disguise.success.self", (Object[])new Object[]{entity.method_5477()}), true);
        } else {
            if (player.method_5770().method_8450().method_8355(class_1928.field_19400)) {
                player.method_43496((class_2561)class_2561.method_43469((String)"commands.disguise.success", (Object[])new Object[]{entity.method_5477()}));
            }
            source.method_9226(() -> class_2561.method_43469((String)"commands.disguise.success.other", (Object[])new Object[]{player.method_5477(), entity.method_5477()}), true);
        }
        return 0;
    }

    static class_1297 loadEntity(class_2168 source, class_6880.class_6883<class_1299<?>> entityType, class_2487 nbt) {
        nbt = nbt.method_10553();
        nbt.method_10582("id", entityType.method_40237().method_29177().toString());
        return class_1299.method_17842((class_2487)nbt, (class_1937)source.method_9225(), Function.identity());
    }

    static class_1297 loadPlayer(class_2168 source, String username) {
        return InteractionManager.getInstance().createPlayer((class_1937)source.method_9225(), new GameProfile(null, username));
    }

    static int reveal(class_2168 source, class_1657 player) {
        Pony iplayer = Pony.of(player);
        iplayer.getSpellSlot().removeIf(SpellPredicate.IS_DISGUISE);
        if (source.method_9228() == player) {
            source.method_9226(() -> class_2561.method_43471((String)"commands.disguise.removed.self"), true);
        } else {
            if (player.method_5770().method_8450().method_8355(class_1928.field_19400)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"commands.disguise.removed"));
            }
            source.method_9226(() -> class_2561.method_43469((String)"commands.disguise.removed.other", (Object[])new Object[]{player.method_5477()}), true);
        }
        return 0;
    }

    static interface Arg<T> {
        public T apply(CommandContext<class_2168> var1) throws CommandSyntaxException;
    }
}

