/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity;

import com.minelittlepony.unicopia.entity.Physics;
import com.minelittlepony.unicopia.entity.mob.UEntityAttributes;
import com.minelittlepony.unicopia.network.track.DataTracker;
import com.minelittlepony.unicopia.network.track.Trackable;
import com.minelittlepony.unicopia.network.track.TrackableDataType;
import com.minelittlepony.unicopia.util.Copyable;
import com.minelittlepony.unicopia.util.Tickable;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_4050;
import net.minecraft.class_7225;

public class EntityPhysics<T extends class_1297>
implements Physics,
Copyable<EntityPhysics<T>>,
Tickable {
    protected final T entity;
    private float lastGravity = 1.0f;
    private final DataTracker tracker;
    protected final DataTracker.Entry<Float> gravity;

    public EntityPhysics(T entity) {
        this.entity = entity;
        this.tracker = Trackable.of(entity).getDataTrackers().getPrimaryTracker();
        this.gravity = this.tracker.startTracking(TrackableDataType.FLOAT, Float.valueOf(1.0f));
    }

    @Override
    public void tick() {
        float gravity;
        if (this.isGravityNegative() && this.entity.method_23318() > (double)(this.entity.method_37908().method_31605() + 64)) {
            this.entity.method_5643(this.entity.method_48923().method_48829(), 4.0f);
        }
        if ((gravity = this.getGravityModifier()) != this.lastGravity) {
            this.lastGravity = gravity;
            this.onGravitychanged();
        }
    }

    @Override
    public class_238 getBoxAtPosition(class_243 pos, boolean inverted) {
        class_238 box = this.entity.method_18377(this.entity.method_18376()).method_30757(pos);
        if (inverted) {
            double yOffset = pos.method_10214() + 1.0 + box.field_1325;
            box = box.method_989(0.0, yOffset, 0.0);
        }
        return box;
    }

    protected void onGravitychanged() {
        this.entity.method_18382();
        if (!this.entity.method_37908().field_9236 && this.entity instanceof class_1308) {
            ((class_1308)this.entity).method_5942().method_6340();
            ((class_1308)this.entity).method_5980(null);
        }
    }

    @Override
    public boolean isFlying() {
        return false;
    }

    @Override
    public class_243 getMotionAngle() {
        return new class_243((double)this.entity.method_5695(1.0f), (double)this.entity.method_5705(1.0f), 0.0);
    }

    @Override
    public double calcGravity(double worldConstant) {
        return worldConstant * (double)this.getGravityModifier();
    }

    @Override
    public class_2338 getHeadPosition() {
        class_2338 pos = class_2338.method_49637((double)this.entity.method_23317(), (double)(this.entity.method_23318() + (double)this.entity.method_18381(class_4050.field_18076)), (double)this.entity.method_23321());
        if (this.entity.method_37908().method_8320(pos).method_26215()) {
            class_2338 below = pos.method_10074();
            class_2680 block = this.entity.method_37908().method_8320(below);
            if (block.method_26164(class_3481.field_16584) || block.method_26164(class_3481.field_15504) || block.method_26204() instanceof class_2349) {
                // empty if block
            }
        }
        return pos;
    }

    @Override
    public void setBaseGravityModifier(float constant) {
        this.gravity.set(Float.valueOf(constant));
    }

    @Override
    public float getBaseGravityModifier() {
        return this.gravity.get().floatValue();
    }

    @Override
    public float getGravityModifier() {
        if (this.entity instanceof class_1309) {
            if (((class_1309)this.entity).method_6127() == null) {
                return this.getBaseGravityModifier();
            }
            if (((class_1309)this.entity).method_6113()) {
                return 1.0f;
            }
            return this.getBaseGravityModifier() * (float)((class_1309)this.entity).method_45325(UEntityAttributes.ENTITY_GRAVITY_MODIFIER);
        }
        return this.getBaseGravityModifier();
    }

    @Override
    public void copyFrom(EntityPhysics<T> other, boolean alive) {
        if (alive) {
            this.setBaseGravityModifier(other.getBaseGravityModifier());
        }
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        compound.method_10548("gravity", this.getBaseGravityModifier());
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        this.setBaseGravityModifier(compound.method_10583("gravity"));
    }
}

