/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity;

import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.util.Copyable;
import com.minelittlepony.unicopia.util.Tickable;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ItemTracker
implements NbtSerialisable,
Copyable<ItemTracker>,
Tickable {
    public static final long TICKS = 1L;
    public static final long SECONDS = 20L;
    public static final long HOURS = 1000L;
    public static final long DAYS = 24000L;
    private final Map<Trackable, Long> items = new HashMap<Trackable, Long>();
    private final Living<?> living;

    public static String formatTicks(long ticks, float tickRate) {
        ticks = class_3532.method_15375((float)((float)ticks / tickRate));
        long days = ticks / 28800L;
        long hours = (ticks %= 1728000L) / 72000L;
        long minutes = (ticks %= 72000L) / 1200L;
        long seconds = (ticks %= 1200L) / 20L;
        return String.format("%dd, %dh %dm %ds", days, hours, minutes, seconds);
    }

    public static Predicate<class_1309> wearing(class_1935 charm, Predicate<Long> range) {
        return e -> Living.getOrEmpty((class_1297)e).map(Living::getArmour).map(a -> a.getTicks(charm)).filter(range).isPresent();
    }

    public static Predicate<Long> between(long minTime, long maxTime) {
        return ItemTracker.before(maxTime).and(ItemTracker.after(minTime));
    }

    public static Predicate<Long> before(long maxTime) {
        return ticks -> ticks <= maxTime;
    }

    public static Predicate<Long> after(long maxTime) {
        return ticks -> ticks <= maxTime;
    }

    public ItemTracker(Living<?> living) {
        this.living = living;
    }

    @Override
    public void tick() {
        this.update(this.living.getArmourStacks());
    }

    private void update(Stream<class_1799> stacks) {
        HashSet found = new HashSet();
        HashSet foundStacks = new HashSet();
        stacks.forEach(stack -> {
            class_1792 patt0$temp = stack.method_7909();
            if (patt0$temp instanceof Trackable) {
                Trackable trackable = (Trackable)patt0$temp;
                if (this.items.compute(trackable, (item, prev) -> prev == null ? 1L : prev + 1L) == 1L) {
                    trackable.onEquipped(this.living);
                }
                found.add(trackable);
                foundStacks.add(stack);
            }
        });
        this.items.entrySet().removeIf(e -> {
            if (!found.contains(e.getKey())) {
                ((Trackable)e.getKey()).onUnequipped(this.living, (Long)e.getValue());
                return true;
            }
            return false;
        });
        if (!(this.living instanceof Pony)) {
            foundStacks.forEach(stack -> stack.method_7917(this.living.asWorld(), this.living.asEntity(), 0, false));
        }
    }

    public long forceRemove(Trackable charm) {
        @Nullable Long time = this.items.remove(charm);
        return time == null ? 0L : time;
    }

    public long getTicks(Trackable charm) {
        return this.items.getOrDefault(charm.method_8389(), 0L);
    }

    public long getTicks(class_1935 charm) {
        long l;
        class_1792 class_17922 = charm.method_8389();
        if (class_17922 instanceof Trackable) {
            Trackable t = (Trackable)class_17922;
            l = this.items.getOrDefault(t, 0L);
        } else {
            l = 0L;
        }
        return l;
    }

    public boolean contains(class_1935 charm) {
        Trackable t;
        class_1792 class_17922 = charm.method_8389();
        return class_17922 instanceof Trackable && this.getTicks(t = (Trackable)class_17922) > 0L;
    }

    public boolean contains(Trackable charm) {
        return this.getTicks(charm) > 0L;
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        this.items.forEach((charm, count) -> compound.method_10544(class_7923.field_41178.method_10221((Object)charm.method_8389()).toString(), count.longValue()));
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        this.items.clear();
        compound.method_10541().stream().map(class_2960::method_12829).filter(Objects::nonNull).map(id -> Map.entry((class_1792)class_7923.field_41178.method_10223(id), compound.method_10537(id.toString()))).filter(i -> i.getKey() instanceof Trackable && (Long)i.getValue() > 0L).forEach(item -> this.items.put((Trackable)item.getKey(), (Long)item.getValue()));
    }

    @Override
    public void copyFrom(ItemTracker other, boolean alive) {
        this.items.clear();
        if (alive) {
            this.items.putAll(other.items);
        }
    }

    public static interface Trackable
    extends class_1935 {
        public void onUnequipped(Living<?> var1, long var2);

        public void onEquipped(Living<?> var1);
    }
}

