/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity;

import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.util.Tickable;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1309;
import org.jetbrains.annotations.Nullable;

public class LandingEventHandler
implements Tickable {
    private final Living<?> living;
    @Nullable
    private final AtomicReference<Callback> callback = new AtomicReference();
    private double prevY;
    private float prevFallDistance;

    public LandingEventHandler(Living<?> living) {
        this.living = living;
    }

    public void setCallback(Callback callback) {
        if (this.living.asEntity().method_24828()) {
            callback.dispatch(0.0f);
        } else {
            this.updateCallback(callback);
        }
    }

    public void beforeTick() {
    }

    @Override
    public void tick() {
        if (this.living.asEntity().method_23318() > this.prevY) {
            this.discard();
        }
        this.prevY = this.living.asEntity().method_23318();
        if (this.living.asEntity().method_24828() && this.living.landedChanged()) {
            this.fire(this.prevFallDistance);
        }
        this.prevFallDistance = ((class_1309)this.living.asEntity()).field_6017;
    }

    float fire(float fallDistance) {
        Callback event = this.callback.getAndSet(null);
        return event == null ? fallDistance : event.dispatch(fallDistance);
    }

    void discard() {
        this.updateCallback(null);
    }

    void updateCallback(@Nullable Callback callback) {
        Callback event = this.callback.getAndSet(callback);
        if (event != null) {
            event.onCancelled();
        }
    }

    public static interface Callback {
        public float dispatch(float var1);

        public void onCancelled();
    }
}

