/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity;

import com.minelittlepony.unicopia.advancement.UCriteria;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.collision.MultiBoundingBoxEntity;
import com.minelittlepony.unicopia.entity.duck.EntityDuck;
import com.minelittlepony.unicopia.entity.mob.AirBalloonEntity;
import com.minelittlepony.unicopia.util.Tickable;
import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class Transportation<T extends class_1309>
implements Tickable {
    private final Living<T> living;
    @Nullable
    private MultiBoundingBoxEntity vehicle;
    @Nullable
    private class_1297 vehicleEntity;
    @Nullable
    private class_238 vehicleBox;
    private int ticksInVehicle;
    private class_243 lastVehiclePosition = class_243.field_1353;

    Transportation(Living<T> living) {
        this.living = living;
    }

    public <E extends class_1297> void setVehicle(@Nullable E vehicle) {
        this.vehicle = (MultiBoundingBoxEntity)vehicle;
        this.vehicleEntity = vehicle;
        this.updatePreviousPosition();
    }

    @Override
    public void tick() {
        AirBalloonEntity b;
        MultiBoundingBoxEntity multiBoundingBoxEntity;
        this.ticksInVehicle = this.vehicle != null ? ++this.ticksInVehicle : 0;
        if (this.ticksInVehicle > 20 && (multiBoundingBoxEntity = this.vehicle) instanceof AirBalloonEntity && !(b = (AirBalloonEntity)multiBoundingBoxEntity).method_24828() && b.hasBalloon() && b.hasBurner() && b.isAscending()) {
            UCriteria.RIDE_BALLOON.trigger((class_1297)this.living.asEntity());
        }
    }

    public void updatePreviousPosition() {
        this.vehicleBox = this.getVehicleBox();
        this.lastVehiclePosition = this.vehicleEntity == null ? class_243.field_1353 : this.vehicleEntity.method_19538();
        T entity = this.living.asEntity();
        if (this.vehicleBox != null && this.living.asEntity().method_5829().method_994(this.vehicleBox.method_1009(0.001, 0.5001, 0.001))) {
            entity.method_24830(true);
            entity.method_38785();
            ((class_1297)entity).field_5992 = true;
            ((class_1297)entity).field_36331 = true;
            ((class_1297)entity).field_6007 = true;
            ((class_1297)entity).field_6037 = true;
        }
    }

    public void onMove(class_1313 movementType) {
        if (this.vehicleBox == null || this.vehicleEntity == null) {
            return;
        }
        T entity = this.living.asEntity();
        class_238 passengerBox = entity.method_5829().method_1014(0.001);
        class_243 vehicleMovement = this.vehicleEntity.method_19538().method_1020(this.lastVehiclePosition);
        ArrayList shapes = new ArrayList();
        this.vehicle.getCollissionShapes(class_3726.method_16195(entity), shapes::add);
        vehicleMovement = vehicleMovement.method_1019(this.vehicleEntity.method_18798());
        vehicleMovement = class_1297.method_20736(entity, (class_243)vehicleMovement, (class_238)passengerBox, (class_1937)entity.method_37908(), shapes);
        class_243 newPos = entity.method_19538().method_1019(vehicleMovement);
        if (!this.vehicleEntity.method_24828()) {
            if (newPos.method_10214() > this.vehicleBox.field_1322 + 0.1 || newPos.method_10214() < this.vehicleBox.field_1322 + 0.1) {
                newPos = new class_243(newPos.method_10216(), this.vehicleBox.field_1322 + 0.01, newPos.method_10215());
            }
            if (newPos.method_10214() < this.vehicleEntity.method_19538().method_10214() + 3.0) {
                double maxDeviation = 0.1;
                double z = class_3532.method_15350((double)newPos.method_10215(), (double)(this.vehicleBox.field_1321 + maxDeviation), (double)(this.vehicleBox.field_1324 - maxDeviation));
                double x = class_3532.method_15350((double)newPos.method_10216(), (double)(this.vehicleBox.field_1323 + maxDeviation), (double)(this.vehicleBox.field_1320 - maxDeviation));
                newPos = new class_243(x, newPos.method_10214(), z);
            }
            entity.method_33574(newPos);
            entity.method_43391(newPos.field_1352, newPos.field_1351, newPos.field_1350);
            entity.method_18799(class_243.field_1353);
        }
        entity.method_24830(true);
        entity.method_38785();
        ((class_1297)entity).field_5992 = true;
        ((class_1297)entity).field_36331 = true;
        if (((class_1297)entity).field_5994 > ((EntityDuck)entity).getNextStepSoundDistance()) {
            ((class_1297)entity).field_5994 = (float)((double)((class_1297)entity).field_5994 - 0.5);
            entity.method_5783(this.vehicle.getWalkedOnSound(entity.method_23318()), 0.5f, 1.0f);
            if (!entity.method_21751()) {
                entity.method_37908().method_33596(entity, (class_6880)class_5712.field_28155, entity.method_24515());
            }
        }
    }

    @Nullable
    private class_238 getVehicleBox() {
        if (!class_1301.field_6155.test(this.living.asEntity())) {
            return null;
        }
        if (this.vehicle == null) {
            return null;
        }
        class_238 entityBox = this.living.asEntity().method_5829().method_18804(this.living.asEntity().method_18798());
        for (class_238 box : this.vehicle.getGravityZoneBoxes()) {
            if (!entityBox.method_994(box.method_1014(0.001).method_18804(this.vehicleEntity.method_18798().method_1021(1.0)))) continue;
            return box;
        }
        this.setVehicle(null);
        return null;
    }
}

