/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.ai;

import com.minelittlepony.unicopia.entity.Creature;
import com.minelittlepony.unicopia.entity.Living;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1541;
import net.minecraft.class_1701;
import net.minecraft.class_243;
import net.minecraft.class_4135;
import net.minecraft.class_5532;
import org.jetbrains.annotations.Nullable;

public class FleeExplosionGoal
extends class_1352 {
    private static final Predicate<class_1297> SOURCE_PREDICATE = e -> e instanceof class_1701 || e instanceof class_1541;
    private final class_1314 mob;
    private final double slowSpeed;
    private final double fastSpeed;
    private final Comparator<class_1297> sorting;
    @Nullable
    private class_1297 targetEntity;
    @Nullable
    private class_11 fleePath;

    public FleeExplosionGoal(class_1314 mob, float distance, double slowSpeed, double fastSpeed) {
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        this.mob = mob;
        this.slowSpeed = slowSpeed;
        this.fastSpeed = fastSpeed;
        this.sorting = Comparator.comparingDouble(e -> e.method_5858((class_1297)mob));
    }

    public void setFleeTarget(@Nullable class_1297 target) {
        this.targetEntity = target;
    }

    public boolean method_6264() {
        if (this.targetEntity == null || this.targetEntity.method_31481()) {
            this.targetEntity = this.mob.method_37908().method_8333((class_1297)this.mob, this.mob.method_5829().method_1009(5.0, 3.0, 5.0), SOURCE_PREDICATE).stream().sorted(this.sorting).findFirst().orElse(null);
        }
        if (this.targetEntity == null) {
            return false;
        }
        class_243 targetPosition = class_5532.method_31511((class_1314)this.mob, (int)16, (int)7, (class_243)this.targetEntity.method_19538());
        if (targetPosition == null || this.targetEntity.method_5649(targetPosition.field_1352, targetPosition.field_1351, targetPosition.field_1350) < this.targetEntity.method_5858((class_1297)this.mob)) {
            return false;
        }
        this.fleePath = this.mob.method_5942().method_6352(targetPosition.field_1352, targetPosition.field_1351, targetPosition.field_1350, 0);
        return this.fleePath != null;
    }

    public boolean method_6266() {
        return !this.mob.method_5942().method_6357();
    }

    public void method_6269() {
        this.mob.method_5942().method_6334(this.fleePath, this.slowSpeed);
    }

    public void method_6270() {
        this.targetEntity = null;
    }

    public void method_6268() {
        if (this.mob.method_5858(this.targetEntity) < 49.0) {
            this.mob.method_5942().method_6344(this.fastSpeed);
        } else {
            this.mob.method_5942().method_6344(this.slowSpeed);
        }
    }

    public static void notifySurroundings(class_1297 explosionSource, float radius) {
        explosionSource.method_37908().method_8333(explosionSource, explosionSource.method_5829().method_1014((double)radius), e -> Living.getOrEmpty(e).filter(l -> l instanceof Creature).isPresent()).forEach(e -> FleeExplosionGoal.getGoals((Creature)Living.living(e)).forEach(goal -> goal.setFleeTarget(explosionSource)));
    }

    private static Stream<FleeExplosionGoal> getGoals(Creature creature) {
        return creature.getGoals().stream().flatMap(goals -> goals.method_35115().stream()).map(class_4135::method_19058).filter(g -> g instanceof FleeExplosionGoal).map(FleeExplosionGoal.class::cast);
    }
}

