/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.collision;

import com.google.common.base.Suppliers;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;

public final class MultiBox
extends class_238 {
    private final class_238 first;
    private final BoxChildren children;

    public static MultiBox of(class_238 first, List<class_238> children) {
        return new MultiBox(first, new BoxChildren(children));
    }

    public static class_238 unbox(class_238 box) {
        class_238 class_2383;
        if (box instanceof MultiBox) {
            MultiBox m = (MultiBox)box;
            class_2383 = m.first;
        } else {
            class_2383 = box;
        }
        return class_2383;
    }

    public static void forEach(class_238 box, Consumer<class_238> consumer) {
        if (box instanceof MultiBox) {
            MultiBox m = (MultiBox)box;
            m.children.forEach(consumer);
        }
    }

    private MultiBox(class_238 first, BoxChildren children) {
        super(first.field_1323, first.field_1322, first.field_1321, first.field_1320, first.field_1325, first.field_1324);
        this.first = MultiBox.unbox(first);
        this.children = children;
    }

    public Optional<class_243> method_992(class_243 min, class_243 max) {
        return super.method_992(min, max).or(() -> this.children.raycast(min, max));
    }

    public boolean method_1003(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return super.method_1003(minX, minY, minZ, maxX, maxY, maxZ) || this.children.intersects(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public boolean method_1008(double x, double y, double z) {
        return super.method_1008(x, y, z) || this.children.contains(x, y, z);
    }

    public class_238 method_35574(double minX) {
        return new MultiBox(super.method_35574(minX), this.children);
    }

    public class_238 method_35575(double minY) {
        return new MultiBox(super.method_35575(minY), this.children);
    }

    public class_238 method_35576(double minZ) {
        return new MultiBox(super.method_35576(minZ), this.children);
    }

    public class_238 method_35577(double maxX) {
        return new MultiBox(super.method_35577(maxX), this.children);
    }

    public class_238 method_35578(double maxY) {
        return new MultiBox(super.method_35578(maxY), this.children);
    }

    public class_238 method_35579(double maxZ) {
        return new MultiBox(super.method_35579(maxZ), this.children);
    }

    public class_238 method_1002(double x, double y, double z) {
        return new MultiBox(super.method_1002(x, y, z), this.children.altered(b -> b.method_1002(x, y, z)));
    }

    public class_238 method_1012(double x, double y, double z) {
        return new MultiBox(super.method_1012(x, y, z), this.children.altered(b -> b.method_1012(x, y, z)));
    }

    public class_238 method_1009(double x, double y, double z) {
        return new MultiBox(super.method_1009(x, y, z), this.children.altered(b -> b.method_1009(x, y, z)));
    }

    public class_238 method_999(class_238 box) {
        return new MultiBox(super.method_999(box), this.children);
    }

    public class_238 method_991(class_238 box) {
        return new MultiBox(super.method_991(box), this.children);
    }

    public class_238 method_989(double x, double y, double z) {
        return new MultiBox(super.method_989(x, y, z), this.children.altered(b -> b.method_989(x, y, z)));
    }

    public class_238 method_996(class_2338 blockPos) {
        return new MultiBox(super.method_996(blockPos), this.children.altered(b -> b.method_996(blockPos)));
    }

    public String toString() {
        return "MULTI_AABB[" + this.field_1323 + ", " + this.field_1322 + ", " + this.field_1321 + "] -> [" + this.field_1320 + ", " + this.field_1325 + ", " + this.field_1324 + "]{" + String.valueOf(this.children) + "}";
    }

    static final class BoxChildren {
        private final class_238[] children;
        private final Supplier<String> toString;

        private BoxChildren(class_238[] children) {
            this.children = children;
            this.toString = Suppliers.memoize(() -> Arrays.stream(this.children).map(class_238::toString).collect(Collectors.joining(",")));
        }

        public BoxChildren(List<class_238> children) {
            this((class_238[])children.stream().map(MultiBox::unbox).toArray(class_238[]::new));
        }

        public BoxChildren altered(Function<class_238, class_238> alteration) {
            BoxChildren copy = new BoxChildren(new class_238[this.children.length]);
            for (int i = 0; i < this.children.length; ++i) {
                copy.children[i] = alteration.apply(this.children[i]);
            }
            return copy;
        }

        public Optional<class_243> raycast(class_243 min, class_243 max) {
            Optional trace = Optional.empty();
            for (int i = 0; trace.isEmpty() && i < this.children.length; ++i) {
                trace = this.children[i].method_992(min, max);
            }
            return trace;
        }

        public boolean intersects(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            for (int i = 0; i < this.children.length; ++i) {
                if (!this.children[i].method_1003(minX, minY, minZ, maxX, maxY, maxZ)) continue;
                return true;
            }
            return false;
        }

        public boolean contains(double x, double y, double z) {
            for (int i = 0; i < this.children.length; ++i) {
                if (!this.children[i].method_1008(x, y, z)) continue;
                return true;
            }
            return false;
        }

        public void forEach(Consumer<class_238> consumer) {
            for (int i = 0; i < this.children.length; ++i) {
                consumer.accept(this.children[i]);
            }
        }

        public String toString() {
            return this.toString.get();
        }
    }
}

