/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.mob;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.WeaklyOwned;
import com.minelittlepony.unicopia.entity.DynamicLightSource;
import com.minelittlepony.unicopia.entity.EntityReference;
import com.minelittlepony.unicopia.entity.MagicImmune;
import com.minelittlepony.unicopia.particle.LightningBoltParticleEffect;
import com.minelittlepony.unicopia.particle.MagicParticleEffect;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.class_11;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1379;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5535;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class FairyEntity
extends class_1314
implements DynamicLightSource,
WeaklyOwned.Mutable<class_1309>,
MagicImmune {
    private final EntityReference<class_1309> owner = new EntityReference();
    private final EntityReference<class_1309> assignment = new EntityReference();
    private final DynamicLightSource.LightEmitter<?> emitter = new DynamicLightSource.LightEmitter<FairyEntity>(this);
    private Optional<class_2338> stayingPos = Optional.empty();

    protected FairyEntity(class_1299<FairyEntity> type, class_1937 world) {
        super(type, world);
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1407 birdNavigation = new class_1407((class_1308)this, world);
        birdNavigation.method_6332(true);
        birdNavigation.method_6354(true);
        birdNavigation.method_6331(true);
        return birdNavigation;
    }

    public static class_5132.class_5133 createMobAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 3.0).method_26868(class_5134.field_23717, 100.0).method_26868(class_5134.field_23719, 0.25);
    }

    protected void method_5959() {
        this.field_6201.method_6277(5, (class_1352)new StayGoal());
        this.field_6201.method_6277(6, (class_1352)new FollowEntityGoal(2.0, 2.0f, 30.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1379((class_1314)this, 1.0));
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return USounds.ENTITY_TWITTERMITE_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return USounds.ENTITY_TWITTERMITE_DEATH;
    }

    @Override
    public int getLightLevel() {
        return 15;
    }

    @Override
    public EntityReference<class_1309> getMasterReference() {
        return this.owner;
    }

    @Override
    public class_1937 asWorld() {
        return this.method_37908();
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition) {
    }

    public boolean method_6101() {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    public boolean isStaying() {
        return this.stayingPos.isPresent();
    }

    public void setStaying(class_2338 pos) {
        this.stayingPos = Optional.ofNullable(pos);
    }

    public void method_5773() {
        this.method_24830(true);
        super.method_5773();
        this.emitter.tick();
        if (this.method_37908().field_9229.method_43048(20) == 3) {
            this.method_37908().method_8406((class_2394)new MagicParticleEffect(0xFFFFFF), this.method_23322(1.0), this.method_23318(), this.method_23325(1.0), 0.0, 0.0, 0.0);
        }
        if (this.field_6012 % 60 == 0) {
            this.method_5783(USounds.ITEM_MAGIC_AURA, 0.1f, 6.0f);
        }
    }

    public void method_6091(class_243 movementInput) {
        if (this.method_5799()) {
            this.method_5724(0.02f, movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021((double)0.8f));
        } else if (this.method_5771()) {
            this.method_5724(0.02f, movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.5));
        } else {
            float f = 0.91f;
            if (this.method_24828()) {
                f = this.method_37908().method_8320(this.method_24515().method_10074()).method_26204().method_9499() * 0.91f;
            }
            float g = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.method_24828()) {
                f = this.method_37908().method_8320(this.method_24515().method_10074()).method_26204().method_9499() * 0.91f;
            }
            this.method_5724(this.method_24828() ? 0.1f * g : 0.02f, movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021((double)f));
        }
        this.method_29242(false);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (hand == class_1268.field_5808) {
            if (this.isStaying()) {
                this.stayingPos = Optional.empty();
                if (player != this.getMaster()) {
                    this.assignment.set((class_1309)player);
                }
            } else {
                this.assignment.set(null);
                this.setStaying(this.method_24515());
            }
            this.method_5783(USounds.ENTITY_TWITTERMITE_AMBIENT, this.method_6107() / 3.0f, this.method_6017() * 3.0f);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public boolean method_5698(class_1297 attacker) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_1538 lightning = (class_1538)class_1299.field_6112.method_5883(this.method_37908());
            lightning.method_24203(this.method_23317(), this.method_23318(), this.method_23321());
            attacker.method_5800(serverWorld, lightning);
        }
        this.method_32876((class_6880)class_5712.field_28152);
        ParticleUtils.spawnParticle(this.method_37908(), LightningBoltParticleEffect.DEFAULT, this.method_19538(), class_243.field_1353);
        return false;
    }

    public void method_36209() {
        super.method_36209();
        this.emitter.remove();
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10566("owner", (class_2520)this.owner.toNBT((class_7225.class_7874)this.method_56673()));
        this.stayingPos.ifPresent(pos -> tag.method_10566("stayingPos", class_2512.method_10692((class_2338)pos)));
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10545("owner")) {
            this.owner.fromNBT(tag.method_10562("owner"), (class_7225.class_7874)this.method_56673());
        }
        this.stayingPos = tag.method_10545("stayingPos") ? class_2512.method_10691((class_2487)tag, (String)"stayingPos") : Optional.empty();
    }

    class StayGoal
    extends class_1352 {
        private int updateCountdownTicks;

        public StayGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return FairyEntity.this.isStaying();
        }

        public boolean method_6266() {
            return FairyEntity.this.isStaying() && !FairyEntity.this.method_5942().method_6357();
        }

        public void method_6269() {
            this.updateCountdownTicks = 0;
        }

        public void method_6270() {
            FairyEntity.this.method_5942().method_6340();
        }

        public void method_6268() {
            if (--this.updateCountdownTicks > 0 || !FairyEntity.this.isStaying()) {
                return;
            }
            this.updateCountdownTicks = this.method_38847(10);
            FairyEntity.this.stayingPos.ifPresent(pos -> {
                if (pos.method_10262((class_2382)FairyEntity.this.method_24515()) <= 1.0) {
                    FairyEntity.this.method_5942().method_6340();
                } else {
                    FairyEntity.this.method_5942().method_6337((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, (double)FairyEntity.this.field_28627);
                }
            });
        }
    }

    class FollowEntityGoal
    extends class_1352 {
        @Nullable
        private class_1309 target;
        private final double speed;
        private int updateCountdownTicks;
        private final float minDistance;
        private final float maxDistance;
        private float oldWaterPathFindingPenalty;

        public FollowEntityGoal(double speed, float minDistance, float maxDistance) {
            this.speed = speed;
            this.minDistance = minDistance;
            this.maxDistance = maxDistance;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            this.target = FairyEntity.this.assignment.get(FairyEntity.this.method_37908());
            if (this.target == null) {
                this.target = (class_1309)FairyEntity.this.getMaster();
            }
            if (this.target == null) {
                this.target = FairyEntity.this.method_37908().method_18460((class_1297)FairyEntity.this, (double)this.maxDistance);
            }
            return this.target != null;
        }

        public boolean method_6266() {
            return this.target != null && !FairyEntity.this.isStaying() && !FairyEntity.this.method_5942().method_6357() && FairyEntity.this.method_5858((class_1297)this.target) > (double)(this.minDistance * this.minDistance);
        }

        public void method_6269() {
            this.updateCountdownTicks = 0;
            this.oldWaterPathFindingPenalty = FairyEntity.this.method_5944(class_7.field_18);
            FairyEntity.this.method_5941(class_7.field_18, 0.0f);
        }

        public void method_6270() {
            this.target = null;
            FairyEntity.this.method_5942().method_6340();
            FairyEntity.this.method_5941(class_7.field_18, this.oldWaterPathFindingPenalty);
        }

        public void method_6268() {
            if (this.target == null || FairyEntity.this.method_60953() || FairyEntity.this.isStaying()) {
                return;
            }
            FairyEntity.this.method_5988().method_6226((class_1297)this.target, 10.0f, (float)FairyEntity.this.method_5978());
            class_11 currentPath = FairyEntity.this.method_5942().method_6345();
            if (currentPath != null && this.target.method_23320() < FairyEntity.this.method_23318() - 0.5 && FairyEntity.this.method_37908().method_8320(FairyEntity.this.method_24515().method_10087(3)).method_26215()) {
                FairyEntity.this.method_5762(0.0, -this.speed, 0.0);
            }
            double distance = FairyEntity.this.method_19538().method_1025(this.target.method_19538());
            double speed = this.speed;
            if (distance > 100.0) {
                FairyEntity.this.method_5814(this.target.method_23317() + (double)(FairyEntity.this.method_37908().field_9229.method_43057() / 2.0f) - 0.5, this.target.method_23320(), this.target.method_23321() + (double)(FairyEntity.this.method_37908().field_9229.method_43057() / 2.0f) - 0.5);
                FairyEntity.this.method_18799(this.target.method_18798());
                return;
            }
            if (distance > 40.0) {
                speed *= 10.0;
            } else if (distance > 25.0) {
                speed *= 4.0;
            } else if (distance > 8.0) {
                speed *= 2.0;
            }
            FairyEntity.this.method_5942().method_6344(speed);
            if (--this.updateCountdownTicks > 0) {
                return;
            }
            this.updateCountdownTicks = this.method_38847(10);
            if (distance <= (double)(this.minDistance * this.minDistance)) {
                class_2338 pos = class_5535.method_31541((class_5819)FairyEntity.this.method_37908().field_9229, (int)5, (int)5);
                if (pos != null) {
                    FairyEntity.this.method_5942().method_6337((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), speed);
                } else {
                    FairyEntity.this.method_5942().method_6340();
                }
            } else {
                FairyEntity.this.method_5942().method_6335((class_1297)this.target, speed);
            }
        }
    }
}

