/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.mob;

import com.minelittlepony.unicopia.EquineContext;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.entity.MagicImmune;
import com.minelittlepony.unicopia.entity.mob.CrystalShardsEntity;
import com.minelittlepony.unicopia.entity.mob.SombraEntity;
import com.minelittlepony.unicopia.entity.mob.UEntities;
import com.minelittlepony.unicopia.particle.UParticles;
import com.minelittlepony.unicopia.server.world.WeatherConditions;
import com.minelittlepony.unicopia.util.PosHelper;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class StormCloudEntity
extends class_1297
implements MagicImmune {
    private static final class_2940<Integer> CLEAR_TICKS = class_2945.method_12791(StormCloudEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> STORM_TICKS = class_2945.method_12791(StormCloudEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> TARGET_SIZE = class_2945.method_12791(StormCloudEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> DISSIPATING = class_2945.method_12791(StormCloudEntity.class, (class_2941)class_2943.field_13323);
    static final float MAX_SIZE = 30.0f;
    static final int CLEAR_TARGET_ALTITUDE = 90;
    static final int STORMY_TARGET_ALTITUDE = 20;
    private float prevSize;
    private float currentSize;
    public boolean cursed;
    private int phase;
    private int nextPhase;
    @Nullable
    private class_3213 bossBar;
    private final Set<class_3222> trackingPlayers = new HashSet<class_3222>();

    public StormCloudEntity(class_1299<StormCloudEntity> type, class_1937 world) {
        super(type, world);
        this.setSize(1 + this.field_5974.method_43048(4));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(STORM_TICKS, (Object)0);
        builder.method_56912(CLEAR_TICKS, (Object)0);
        builder.method_56912(TARGET_SIZE, (Object)Float.valueOf(1.0f));
        builder.method_56912(DISSIPATING, (Object)false);
    }

    public boolean isStormy() {
        return this.getStormTicks() != 0;
    }

    public int getStormTicks() {
        return (Integer)this.field_6011.method_12789(STORM_TICKS);
    }

    public void setStormTicks(int stormTicks) {
        this.field_6011.method_12778(STORM_TICKS, (Object)stormTicks);
        this.setClearTicks(stormTicks);
    }

    public void setDissipating(boolean dissipating) {
        this.field_6011.method_12778(DISSIPATING, (Object)dissipating);
    }

    public boolean isDissipating() {
        return (Boolean)this.field_6011.method_12789(DISSIPATING);
    }

    private void setClearTicks(int clearTicks) {
        this.field_6011.method_12778(CLEAR_TICKS, (Object)clearTicks);
    }

    private int getClearTicks() {
        return (Integer)this.field_6011.method_12789(CLEAR_TICKS);
    }

    public boolean tickClear() {
        int clearTicks = this.getClearTicks();
        if (clearTicks > 0) {
            this.setClearTicks(--clearTicks);
        }
        return clearTicks > 0;
    }

    public float getSize(float tickDelta) {
        return class_3532.method_15363((float)class_3532.method_16439((float)tickDelta, (float)this.prevSize, (float)this.currentSize), (float)1.0f, (float)30.0f);
    }

    public void setSize(float size) {
        this.field_6011.method_12778(TARGET_SIZE, (Object)Float.valueOf(size));
    }

    public int getSizeInBlocks() {
        return (int)(this.method_17681() * (this.getSize(1.0f) / 15.0f));
    }

    public void method_5773() {
        int stormTicks;
        this.method_20803(1);
        this.prevSize = this.currentSize;
        float targetSize = ((Float)this.field_6011.method_12789(TARGET_SIZE)).floatValue();
        if (this.currentSize != targetSize) {
            float sizeDifference = ((Float)this.field_6011.method_12789(TARGET_SIZE)).floatValue() - this.currentSize;
            float f = this.currentSize = Math.abs(sizeDifference) < 0.01f ? targetSize : this.currentSize + sizeDifference * 0.02f;
        }
        if (this.isStormy() && (stormTicks = this.getStormTicks()) > 0) {
            this.setStormTicks(stormTicks - 1);
        }
        if (this.method_5787()) {
            float groundY = PosHelper.findNearestSurface(this.method_37908(), this.method_24515()).method_10264();
            float targetY = this.isStormy() ? 20.0f : 90.0f;
            float cloudY = (float)this.method_23318() - targetY;
            this.method_5762(0.0, 3.0E-4f * (groundY - cloudY), 0.0);
            if (!this.cursed && !this.isStormy()) {
                class_243 wind = WeatherConditions.get(this.method_37908()).getWindDirection();
                this.method_5762(wind.field_1352 * (double)0.001f, 0.0, wind.field_1350 * (double)0.001f);
            }
            class_243 velocity = this.method_18798();
            this.method_33574(this.method_19538().method_1019(velocity.method_1021((double)0.7f)));
            this.method_18799(velocity.method_1021((double)0.9f));
            float randomYaw = this.field_5974.method_43057() * 360.0f;
            class_243 randomVelocity = class_243.method_1030((float)0.0f, (float)randomYaw).method_1021(0.002);
            for (StormCloudEntity cloud : this.method_37908().method_8390(StormCloudEntity.class, this.method_5829(), class_1301.field_6154)) {
                if (cloud == this) continue;
                cloud.method_60491(randomVelocity);
            }
        }
        super.method_5773();
        float size = this.getSize(1.0f);
        if (this.method_37908().method_8608()) {
            if (this.isStormy()) {
                WeatherConditions.get(this.method_37908()).addStorm(this);
                float sizeInBlocks = this.getSizeInBlocks();
                int area = (int)class_3532.method_27285((float)sizeInBlocks);
                sizeInBlocks /= this.method_17681();
                for (int i = 0; i < area; ++i) {
                    float x = (float)this.method_23322(sizeInBlocks);
                    float z = (float)this.method_23325(sizeInBlocks);
                    this.method_37908().method_8406((class_2394)UParticles.RAIN_DROPS, (double)x, this.method_23318(), (double)z, 0.0, (double)-0.2f, 0.0);
                }
            }
        } else {
            if (!this.isStormy() && !this.cursed && size > 10.0f && this.field_5974.method_43048(1 + (int)(4000.0f / size)) == 0) {
                this.split(this.field_5974.method_39332(1, 3));
                return;
            }
            if (this.cursed) {
                float percent = Math.min(1.0f, (size + 1.0f) / 30.0f);
                this.getBossBar().method_5408(percent);
            }
            if (this.currentSize == targetSize) {
                if (this.isDissipating()) {
                    if (size < 2.0f) {
                        this.method_5768();
                    } else if (this.field_5974.method_43048(4) == 0) {
                        this.split(2);
                    } else {
                        this.setSize(size - 1.0f);
                    }
                } else if (size < 30.0f && this.cursed) {
                    this.setSize(size + 1.0f);
                    this.setStormTicks(-1);
                    this.spawnLightningStrike(this.method_24515(), false, false);
                    this.method_5783(USounds.AMBIENT_WIND_GUST, 1.0f, 1.0f);
                }
            }
            if (size >= 30.0f) {
                if (this.cursed) {
                    this.setStormTicks(-1);
                    if (this.nextPhase-- == 0) {
                        ++this.phase;
                        this.nextPhase = this.field_5974.method_39332(17, 120);
                        if (this.phase == 1) {
                            this.method_5783(USounds.ENTITY_SOMBRA_SNICKER, 10.0f, 1.0f);
                        }
                        if (++this.phase >= 7) {
                            this.pickRandomPoints(13, pos -> this.spawnLightningStrike((class_2338)pos, true, false));
                            this.cursed = false;
                            SombraEntity sombra = new SombraEntity(UEntities.SOMBRA, this.method_37908(), this.getBossBar());
                            sombra.method_33574(this.method_19538());
                            sombra.setHomePos(this.method_37908().method_8598(class_2902.class_2903.field_13203, this.method_24515()));
                            sombra.setScaleFactor(8.0f);
                            sombra.stormCloud.set(this);
                            this.method_37908().method_8649((class_1297)sombra);
                            this.method_5783(USounds.ENTITY_SOMBRA_LAUGH, 10.0f, 1.0f);
                        } else {
                            this.pickRandomPoints(3, pos -> this.spawnLightningStrike((class_2338)pos, true, false));
                        }
                    }
                } else if (!this.isStormy() && !this.tickClear()) {
                    this.setStormTicks(this.field_5974.method_39332(30, 120));
                }
            }
            if (this.isStormy() && this.field_6012 % 170 == 0) {
                this.pickRandomPoints(3, pos -> this.spawnLightningStrike((class_2338)pos, false, this.field_5974.method_43048(30) == 0));
            }
        }
    }

    private void pickRandomPoints(int count, Consumer<class_2338> action) {
        class_2338.method_34848((class_5819)this.field_5974, (int)3, (class_2338)this.method_24515(), (int)this.getSizeInBlocks()).forEach(pos -> action.accept(PosHelper.findNearestSurface(this.method_37908(), pos)));
    }

    private void spawnLightningStrike(class_2338 pos, boolean cosmetic, boolean infect) {
        if (infect && !CrystalShardsEntity.infestBlock((class_3218)this.method_37908(), pos)) {
            return;
        }
        class_1538 lightning = (class_1538)class_1299.field_6112.method_5883(this.method_37908());
        lightning.method_24203((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        lightning.method_29498(cosmetic);
        this.method_37908().method_8649((class_1297)lightning);
    }

    public boolean method_5643(class_1282 source, float amount) {
        super.method_5643(source, amount);
        if (!this.cursed && (this.field_5974.method_43048(35) == 0 || source.method_49708(class_8111.field_42320) && EquineContext.of(source.method_5529()).collidesWithClouds())) {
            if (this.getSize(1.0f) < 2.0f) {
                if (!this.method_37908().method_8608() && this.method_37908().method_8450().method_8355(class_1928.field_19391)) {
                    class_5321 table = this.method_5864().method_16351();
                    class_8567.class_8568 builder = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1231, (Object)source).method_51877(class_181.field_1230, (Object)source.method_5529()).method_51877(class_181.field_1227, (Object)source.method_5526());
                    class_1297 class_12972 = source.method_5529();
                    if (class_12972 instanceof class_1657) {
                        class_1657 player = (class_1657)class_12972;
                        builder = builder.method_51874(class_181.field_1233, (Object)player).method_51871(player.method_7292());
                    }
                    ((class_52)this.method_56673().method_30530(class_7924.field_50079).method_29107(table)).method_51880(builder.method_51875(class_173.field_1173), 0L, this::method_5775);
                }
                this.method_5768();
                this.method_37908().method_8421((class_1297)this, (byte)60);
            } else {
                this.split(2 + this.field_5974.method_43048(4));
            }
        }
        return false;
    }

    @Nullable
    public class_1542 method_5775(class_1799 stack) {
        stack = stack.method_7972();
        while (!stack.method_7960()) {
            class_1542 drop = super.method_5775(stack.method_7971(1));
            if (drop == null) continue;
            drop.method_5762(this.field_5974.method_43385(0.0, 0.3), 0.0, this.field_5974.method_43385(0.0, 0.3));
        }
        return null;
    }

    public void split(int splitCount) {
        class_243 center = this.method_19538();
        float totalAngle = 360.0f / (float)splitCount + (float)this.field_5974.method_43059() * 360.0f;
        float size = this.getSize(1.0f) / (float)splitCount;
        int stormTicks = this.getStormTicks() / splitCount;
        if (size < 1.0f) {
            return;
        }
        this.method_31472();
        for (int i = 0; i < splitCount; ++i) {
            StormCloudEntity lump = (StormCloudEntity)this.method_5864().method_5883(this.method_37908());
            lump.setSize(size);
            lump.setStormTicks(stormTicks);
            lump.method_33574(center);
            lump.setDissipating(this.isDissipating());
            lump.method_18799(class_243.method_1030((float)0.0f, (float)(totalAngle * (float)i)).method_1029().method_1021((double)1.8f));
            this.method_37908().method_8649((class_1297)lump);
        }
    }

    public void method_5711(byte status) {
        switch (status) {
            case 60: {
                for (int i = 0; i < 20; ++i) {
                    double d = this.field_5974.method_43059() * 0.02;
                    double e = this.field_5974.method_43059() * 0.02;
                    double f = this.field_5974.method_43059() * 0.02;
                    this.method_37908().method_8406((class_2394)class_2398.field_11203, this.method_23322(1.0), this.method_23319(), this.method_23325(1.0), d, e, f);
                }
                break;
            }
            default: {
                super.method_5711(status);
            }
        }
    }

    public boolean method_49108() {
        return false;
    }

    public final boolean method_5863() {
        return true;
    }

    private class_3213 getBossBar() {
        if (this.bossBar == null) {
            this.bossBar = SombraEntity.createBossBar((class_2561)class_2561.method_43471((String)"unicopia.entity.sombra").method_27692(class_124.field_1051));
            this.trackingPlayers.removeIf(class_1297::method_31481);
            this.trackingPlayers.forEach(arg_0 -> ((class_3213)this.bossBar).method_14088(arg_0));
        }
        return this.bossBar;
    }

    public void method_5652(class_2487 nbt) {
        nbt.method_10569("stormTicks", this.getStormTicks());
        nbt.method_10569("clearTicks", this.getClearTicks());
        nbt.method_10548("size", this.getSize(1.0f));
        nbt.method_10556("cursed", this.cursed);
        nbt.method_10569("phase", this.phase);
        nbt.method_10569("nextPhase", this.nextPhase);
    }

    public void method_5749(class_2487 nbt) {
        this.setStormTicks(nbt.method_10550("stormTicks"));
        this.setClearTicks(nbt.method_10550("clearTicks"));
        if (nbt.method_10573("size", 5)) {
            this.currentSize = nbt.method_10583("size");
            this.setSize(this.currentSize);
        }
        this.cursed = nbt.method_10577("cursed");
        this.phase = nbt.method_10550("phase");
        this.nextPhase = nbt.method_10550("nextPhase");
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.trackingPlayers.removeIf(class_1297::method_31481);
        this.trackingPlayers.add(player);
        if (this.bossBar != null) {
            this.bossBar.method_14088(player);
        }
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.trackingPlayers.removeIf(class_1297::method_31481);
        this.trackingPlayers.remove(player);
        if (this.bossBar != null) {
            this.bossBar.method_14089(player);
        }
    }
}

