/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.player;

import com.minelittlepony.unicopia.InteractionManager;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.entity.effect.UEffects;
import com.minelittlepony.unicopia.entity.player.MagicReserves;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.AmuletItem;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.util.Tickable;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1935;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_5819;

public class CorruptionHandler
implements Tickable {
    private final Pony pony;

    public CorruptionHandler(Pony pony) {
        this.pony = pony;
    }

    public boolean hasCorruptingMagic() {
        return this.pony.getSpellSlot().get(SpellPredicate.IS_CORRUPTING).isPresent() || AmuletItem.isApplicable(this.pony.asEntity(), (class_1935)UItems.ALICORN_AMULET);
    }

    @Override
    public void tick() {
        float corruptionPercentage;
        if (this.pony.isClient() || ((class_1657)this.pony.asEntity()).field_6012 % 5 != 0) {
            return;
        }
        class_1657 entity = (class_1657)this.pony.asEntity();
        class_5819 random = ((class_1657)this.pony.asEntity()).method_59922();
        if (!AmuletItem.isApplicable((class_1309)entity, (class_1935)UItems.ALICORN_AMULET) && (long)entity.field_6012 % 200L == 0L) {
            if (random.method_43048(100) == 0) {
                this.pony.getCorruption().add(-1);
            }
            if (entity.method_6032() >= entity.method_6063() - 1.0f && !entity.method_7344().method_7587()) {
                this.pony.getCorruption().add(-random.method_43048(4));
            }
        }
        if (((class_1657)this.pony.asEntity()).field_6012 % 100 == 0 && this.hasCorruptingMagic()) {
            this.pony.getCorruption().add(random.method_43048(4));
        }
        if ((corruptionPercentage = this.pony.getCorruption().getScaled(1.0f)) > 0.5f && random.method_43057() < corruptionPercentage - 0.25f) {
            this.pony.findAllEntitiesInRange(10.0, e -> e instanceof class_1309 && !((class_1309)e).method_6059(UEffects.CORRUPT_INFLUENCE)).forEach(e -> {
                ((class_1309)e).method_6092(new class_1293(UEffects.CORRUPT_INFLUENCE, 100, 1));
                this.recover(0.1f);
            });
        }
        if (corruptionPercentage > 0.25f && random.method_43048(200) == 0 && !((class_1657)this.pony.asEntity()).method_6059(UEffects.BUTTER_FINGERS)) {
            ((class_1657)this.pony.asEntity()).method_6092(new class_1293(UEffects.BUTTER_FINGERS, 2100, 1));
            this.recover(0.25f);
        }
        if (random.method_43057() < corruptionPercentage) {
            this.pony.spawnParticles((class_2394)class_2398.field_22247, 10);
        }
    }

    private void recover(float percentage) {
        this.pony.getCorruption().set((int)((float)this.pony.getCorruption().get() * (1.0f - percentage)));
        InteractionManager.getInstance().playLoopingSound((class_1297)this.pony.asEntity(), 6, 0L);
        MagicReserves reserves = this.pony.getMagicalReserves();
        reserves.getExertion().addPercent(10.0f);
        reserves.getEnergy().add(10.0f);
    }
}

