/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.player;

import com.minelittlepony.unicopia.entity.mob.LevitatingItemEntity;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.ForageableItem;
import com.minelittlepony.unicopia.util.Copyable;
import com.minelittlepony.unicopia.util.Tickable;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class LevitatedItemsInventory
implements Copyable<LevitatedItemsInventory>,
NbtSerialisable,
Tickable {
    private final Pony player;
    private final Int2ObjectMap<LevitatingItemEntity> stacks = new Int2ObjectAVLTreeMap();
    private final List<LevitatingItemEntity> pending = new ArrayList<LevitatingItemEntity>();
    private int nextSlot = 0;
    private final Map<class_2338, BlockBreakingRecord> blockBreakingRecords = new HashMap<class_2338, BlockBreakingRecord>();

    public LevitatedItemsInventory(Pony player) {
        this.player = player;
    }

    public void onEntitySpawned(LevitatingItemEntity entity) {
        this.stacks.put(entity.getSlot(), (Object)entity);
    }

    public void onEntityDespawned(LevitatingItemEntity entity) {
        if (this.stacks.containsKey(entity.getSlot())) {
            this.stacks.remove(entity.getSlot());
        }
    }

    public boolean addStack(class_1799 stack) {
        LevitatingItemEntity entity = new LevitatingItemEntity(this.nextSlot++, (class_1657)this.player.asEntity(), stack);
        this.onEntitySpawned(entity);
        this.player.asWorld().method_8649((class_1297)entity);
        this.player.playSound(class_3417.field_15197, 1.0f);
        return true;
    }

    public boolean addPassenger(class_1297 passenger) {
        double yOffset = 0.1;
        class_1297 class_12972 = passenger.method_5668();
        if (class_12972 instanceof LevitatingItemEntity) {
            LevitatingItemEntity root = (LevitatingItemEntity)class_12972;
            boolean isOnlyPassenger = root.method_5685().size() == 1 && root.method_5685().get(0) == passenger;
            passenger.method_5848();
            passenger.method_33574(root.method_19538());
            yOffset = 0.0;
            if (root.method_5685().isEmpty()) {
                root.method_5768();
            }
            if (root.getMaster() == this.player.asEntity() && isOnlyPassenger) {
                this.player.playSound(class_3417.field_15197, 1.0f);
                return true;
            }
        }
        LevitatingItemEntity entity = new LevitatingItemEntity(this.nextSlot++, (class_1657)this.player.asEntity(), class_1799.field_8037);
        entity.method_33574(passenger.method_19538());
        entity.setHoldingPosition(passenger.method_19538().method_1031(0.0, yOffset, 0.0));
        if (passenger instanceof class_1542) {
            class_1542 i = (class_1542)passenger;
            entity.setStack(i.method_6983());
            i.method_31472();
            return this.addStack(i.method_6983());
        }
        this.onEntitySpawned(entity);
        passenger.method_5873((class_1297)entity, true);
        this.player.asWorld().method_8649((class_1297)entity);
        this.player.playSound(class_3417.field_15197, 1.0f);
        return true;
    }

    public void dropEverything() {
        ArrayList copy = new ArrayList(this.stacks.values());
        if (!copy.isEmpty()) {
            this.player.playSound(class_3417.field_15197, 1.0f);
        }
        this.stacks.clear();
        this.nextSlot = 0;
        copy.forEach(stack -> stack.method_5768());
    }

    public class_1269 interact(@Nullable class_3965 hit) {
        for (LevitatingItemEntity i : this.stacks.values()) {
            class_1799 stack = i.getStack();
            if (((class_1657)this.player.asEntity()).method_7357().method_7904(stack.method_7909())) continue;
            if (ForageableItem.use((class_1657)this.player.asEntity(), stack, this.player.asWorld(), class_1268.field_5808, hit).method_23665()) {
                return class_1269.field_5812;
            }
            class_1269 result = stack.method_7981(new class_1838(this.player.asWorld(), (class_1657)this.player.asEntity(), class_1268.field_5808, stack, hit));
            if (!result.method_23665()) continue;
            Object t = this.player.asEntity();
            if (t instanceof class_3222) {
                class_3222 spe = (class_3222)t;
                class_174.field_24478.method_23889(spe, hit.method_17777(), stack);
            }
            return result;
        }
        return class_1269.field_5811;
    }

    public class_1269 interact(class_1297 entity, @Nullable class_3966 hit) {
        if (!(entity instanceof class_1309)) {
            return class_1269.field_5811;
        }
        class_1309 l = (class_1309)entity;
        for (LevitatingItemEntity i : this.stacks.values()) {
            class_1269 result;
            class_1799 stack = i.getStack();
            if (((class_1657)this.player.asEntity()).method_7357().method_7904(stack.method_7909()) || !(result = stack.method_7920((class_1657)this.player.asEntity(), l, class_1268.field_5808)).method_23665()) continue;
            return result;
        }
        return class_1269.field_5811;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public class_1269 attack(class_1297 entity, @Nullable class_3966 hit) {
        double playerAttackDamage = ((class_1657)this.player.asEntity()).method_45325(class_5134.field_23721);
        LevitatingItemEntity chosenAttacker = null;
        double chosenAttackerDamage = playerAttackDamage;
        for (LevitatingItemEntity i : this.stacks.values()) {
            if (((class_1657)this.player.asEntity()).method_7357().method_7904(i.getStack().method_7909()) || i.getMiningPos().isPresent() || !i.canChangePositionHoldingFreely() || i.isSwinging()) continue;
            double damage = i.getAttackDamage((class_1657)this.player.asEntity());
            if (damage > chosenAttackerDamage) {
                chosenAttacker = i;
                chosenAttackerDamage = damage;
            }
            ((class_1657)this.player.asEntity()).method_7324(entity);
        }
        if (chosenAttacker != null) {
            chosenAttacker.swingAt(entity.method_24515().method_10069(0, (int)entity.method_17682(), 0));
            class_1799 oldStack = ((class_1657)this.player.asEntity()).method_5998(class_1268.field_5808);
            try {
                ((class_1657)this.player.asEntity()).method_6122(class_1268.field_5808, chosenAttacker.getStack());
                ((class_1657)this.player.asEntity()).method_7324(entity);
            }
            finally {
                chosenAttacker.setStack(((class_1657)this.player.asEntity()).method_5998(class_1268.field_5808));
                ((class_1657)this.player.asEntity()).method_6122(class_1268.field_5808, oldStack);
            }
        }
        return class_1269.field_5811;
    }

    public boolean startMining(class_2680 state, class_2338 pos, class_2350 direction) {
        this.blockBreakingRecords.values().removeIf(BlockBreakingRecord::tryDiscard);
        BlockBreakingRecord record = this.blockBreakingRecords.computeIfAbsent(pos, p -> new BlockBreakingRecord((class_2338)p, state));
        for (LevitatingItemEntity i : this.stacks.values()) {
            if (!i.startMining((class_1657)this.player.asEntity(), record, direction)) continue;
            return true;
        }
        return false;
    }

    public void stopMining(class_2338 pos) {
        for (LevitatingItemEntity i : this.stacks.values()) {
            i.stopMining(pos);
        }
    }

    @Override
    public void tick() {
        if (!this.player.isClient()) {
            ArrayList<LevitatingItemEntity> copy = new ArrayList<LevitatingItemEntity>(this.pending);
            this.pending.clear();
            copy.forEach(arg_0 -> ((class_1937)this.player.asWorld()).method_8649(arg_0));
        }
        this.blockBreakingRecords.values().removeIf(BlockBreakingRecord::tryDiscard);
        this.stacks.values().removeIf(class_1297::method_31481);
        if (!this.player.isClient()) {
            float cost = 0.0f;
            for (LevitatingItemEntity a : this.stacks.values()) {
                cost += 0.01f * (float)a.getStack().method_7947();
                cost += 0.1f * (float)a.method_5685().size();
                for (LevitatingItemEntity b : this.stacks.values()) {
                    if (a == b || !(a.getRelativePosition().method_1022(b.getRelativePosition()) < 0.8)) continue;
                    class_243 delta = a.getRelativePosition().method_1020(b.getRelativePosition()).method_1021(0.5);
                    a.setPolarPositionOffset(a.getRelativePosition().method_1019(delta));
                    b.setPolarPositionOffset(b.getRelativePosition().method_1020(delta));
                }
            }
            this.player.subtractEnergyCost(cost);
        }
    }

    @Override
    public void copyFrom(LevitatedItemsInventory other, boolean alive) {
        if (alive) {
            for (LevitatingItemEntity stack : other.stacks.values()) {
                this.addStack(stack.getStack());
                stack.method_31472();
            }
        }
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        class_2499 stacks = new class_2499();
        for (LevitatingItemEntity stack : this.stacks.values()) {
            stacks.add((Object)stack.method_5647(new class_2487()));
        }
        compound.method_10566("stacks", (class_2520)stacks);
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        class_2499 stacks = compound.method_10554("stacks", 10);
        this.stacks.clear();
        for (int i = 0; i < stacks.size(); ++i) {
            LevitatingItemEntity stack = new LevitatingItemEntity(i, (class_1657)this.player.asEntity(), class_1799.field_8037);
            stack.method_5651(stacks.method_10602(i));
            stack.setSlot(i);
            this.onEntitySpawned(stack);
            if (this.player.isClient()) continue;
            this.pending.add(stack);
        }
        this.nextSlot = this.stacks.size();
    }

    public class BlockBreakingRecord {
        public final class_2338 pos;
        public final class_2680 state;
        public float breakingProgress;
        public int breakingStage;
        public final Set<LevitatingItemEntity> claimants = new HashSet<LevitatingItemEntity>();

        public BlockBreakingRecord(class_2338 pos, class_2680 state) {
            this.pos = pos;
            this.state = state;
        }

        public boolean tryDiscard() {
            if (this.breakingProgress >= 1.0f || LevitatedItemsInventory.this.player.asWorld().method_8320(this.pos) != this.state || this.claimants.isEmpty()) {
                new HashSet<LevitatingItemEntity>(this.claimants).forEach(claimant -> claimant.stopMining(this.pos));
                this.claimants.clear();
                return true;
            }
            return false;
        }
    }
}

