/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.player;

import com.minelittlepony.unicopia.entity.player.MagicReserves;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.network.track.DataTracker;
import com.minelittlepony.unicopia.network.track.TrackableDataType;
import com.minelittlepony.unicopia.util.Copyable;
import com.minelittlepony.unicopia.util.Tickable;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_7225;

class ManaContainer
implements MagicReserves,
Tickable,
NbtSerialisable,
Copyable<ManaContainer> {
    private final Pony pony;
    private final Map<String, BarInst> bars = new HashMap<String, BarInst>();
    private final BarInst energy;
    private final BarInst exhaustion;
    private final BarInst exertion;
    private final BarInst mana;
    private final BarInst xp;
    private final BarInst charge;

    public ManaContainer(Pony pony, DataTracker tracker) {
        this.pony = pony;
        this.energy = this.addBar("energy", new BarInst(this, tracker, 100.0f, 0.0f));
        this.exhaustion = this.addBar("exhaustion", new BarInst(this, tracker, 100.0f, 0.0f));
        this.exertion = this.addBar("exertion", new BarInst(this, tracker, 10.0f, 0.0f));
        this.xp = this.addBar("xp", new BarInst(this, tracker, 1.0f, 0.0f));
        this.mana = this.addBar("mana", new XpCollectingBar(tracker, 100.0f, 1.0f));
        this.charge = this.addBar("charge", new BarInst(this, tracker, 10.0f, 0.0f){

            @Override
            protected float applyLimits(float value) {
                return Math.max(0.0f, value);
            }
        });
    }

    protected BarInst addBar(String name, BarInst bar) {
        this.bars.put(name, bar);
        return bar;
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        this.bars.forEach((key, bar) -> compound.method_10566(key, (class_2520)bar.toNBT(lookup)));
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        this.bars.forEach((key, bar) -> bar.fromNBT(compound.method_10562(key), lookup));
    }

    @Override
    public MagicReserves.Bar getExertion() {
        return this.exertion;
    }

    @Override
    public MagicReserves.Bar getExhaustion() {
        return this.exhaustion;
    }

    @Override
    public MagicReserves.Bar getEnergy() {
        return this.energy;
    }

    @Override
    public MagicReserves.Bar getMana() {
        return this.mana;
    }

    @Override
    public MagicReserves.Bar getXp() {
        return this.xp;
    }

    @Override
    public MagicReserves.Bar getCharge() {
        return this.charge;
    }

    @Override
    public void tick() {
        this.bars.values().forEach(BarInst::tick);
        this.exertion.addPercent(-10.0f);
        if (this.energy.get() > 5.0f) {
            this.energy.multiply(0.8f);
        } else {
            this.energy.addPercent(-1.0f);
        }
        if (this.pony.getCompositeRace().canFly() && !this.pony.getPhysics().isFlying() && ((class_1657)this.pony.asEntity()).method_24828()) {
            this.exhaustion.multiply(0.99f);
        } else {
            this.exhaustion.addPercent(-1.0f);
        }
        if ((!this.pony.getCompositeRace().canFly() || !this.pony.getPhysics().isFlying() && ((class_1657)this.pony.asEntity()).method_24828()) && this.mana.getPercentFill() < 1.0f && this.mana.getShadowFill(1.0f) <= this.mana.getPercentFill(1.0f)) {
            this.mana.addPercent((float)class_3532.method_15340((int)(1 + this.pony.getLevel().get()), (int)1, (int)50) / 4.0f);
        }
        if (this.xp.getPercentFill() >= 1.0f) {
            this.xp.set(0.0f);
            this.pony.getLevel().add(1);
        }
    }

    @Override
    public void copyFrom(ManaContainer other, boolean alive) {
        if (alive) {
            this.mana.resetTo(this.mana.getMax());
            this.xp.resetTo(other.xp.get());
        } else {
            this.energy.resetTo(0.6f);
            this.exhaustion.resetTo(0.0f);
            this.exertion.resetTo(0.0f);
        }
    }

    class BarInst
    implements MagicReserves.Bar,
    NbtSerialisable {
        private final DataTracker.Entry<Float> marker;
        private final float max;
        private float trailingValue;
        private float prevTrailingValue;
        private float prevValue;

        BarInst(ManaContainer this$0, DataTracker tracker, float max, float initial) {
            this.max = max;
            this.trailingValue = initial;
            this.prevTrailingValue = initial;
            this.prevValue = initial;
            this.marker = tracker.startTracking(TrackableDataType.FLOAT, Float.valueOf(max * this.trailingValue));
        }

        @Override
        public float get() {
            return this.applyLimits(this.marker.get().floatValue());
        }

        @Override
        public float get(float tickDelta) {
            return class_3532.method_16439((float)tickDelta, (float)this.prevValue, (float)this.get());
        }

        @Override
        public float getShadowFill(float tickDelta) {
            return class_3532.method_16439((float)tickDelta, (float)this.prevTrailingValue, (float)this.trailingValue);
        }

        @Override
        public void set(float value) {
            this.load(this.applyLimits(value));
        }

        private void load(float value) {
            this.marker.set(Float.valueOf(value));
        }

        protected float getInitial(float initial) {
            return initial;
        }

        protected float applyLimits(float value) {
            return class_3532.method_15363((float)value, (float)0.0f, (float)this.getMax());
        }

        void resetTo(float value) {
            this.trailingValue = class_3532.method_15363((float)(value / this.getMax()), (float)0.0f, (float)1.0f);
            this.load(value);
        }

        @Override
        public float getMax() {
            return this.max;
        }

        void tick() {
            float trailingIncrement;
            this.prevValue = this.get();
            this.prevTrailingValue = this.trailingValue;
            float fill = this.getPercentFill();
            if (this.trailingValue > fill - (trailingIncrement = 0.003f) && this.trailingValue < fill + trailingIncrement) {
                this.trailingValue = fill;
            }
            if (this.trailingValue < fill) {
                this.trailingValue += trailingIncrement;
            }
            if (this.trailingValue > fill) {
                this.trailingValue -= trailingIncrement;
            }
        }

        @Override
        public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
            compound.method_10548("shadow", this.trailingValue);
            compound.method_10548("value", this.get());
        }

        @Override
        public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
            this.trailingValue = compound.method_10583("shadow");
            this.load(compound.method_10583("value"));
        }
    }

    class XpCollectingBar
    extends BarInst {
        XpCollectingBar(DataTracker tracker, float max, float initial) {
            super(ManaContainer.this, tracker, max, initial);
        }

        @Override
        public float getMax() {
            return super.getMax() + (float)(50 * ManaContainer.this.pony.getLevel().get());
        }

        @Override
        public void set(float value) {
            float diff = value - this.get();
            if (diff > 0.0f) {
                if (ManaContainer.this.pony.getLevel().canLevelUp()) {
                    ManaContainer.this.xp.add(0.001f / (float)ManaContainer.this.pony.getLevel().get());
                }
                value = this.get() + diff / (float)(1 + ManaContainer.this.pony.getLevel().get());
            }
            super.set(value);
        }
    }
}

