/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.player;

import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.entity.effect.EffectUtils;
import com.minelittlepony.unicopia.entity.effect.UEffects;
import com.minelittlepony.unicopia.entity.mob.UEntityAttributes;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.util.Tickable;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class PlayerAttributes
implements Tickable {
    private static final List<ToggleableAttribute> ATTRIBUTES = List.of(new ToggleableAttribute(new class_1322(Unicopia.id("earth_pony_strength"), 0.6, class_1322.class_1323.field_6331), List.of(class_5134.field_23721, class_5134.field_23718), pony -> pony.getCompositeRace().canUseEarth()), new ToggleableAttribute(new class_1322(Unicopia.id("earth_pony_knockback_resistance"), 6.0, class_1322.class_1323.field_6328), List.of(class_5134.field_23718), pony -> pony.getCompositeRace().canUseEarth() && ((class_1657)pony.asEntity()).method_5715()), new ToggleableAttribute(new class_1322(Unicopia.id("earth_pony_mining_speed"), 0.5, class_1322.class_1323.field_6331), List.of(UEntityAttributes.EXTRA_MINING_SPEED), pony -> pony.getCompositeRace().canUseEarth()), new ToggleableAttribute(new class_1322(Unicopia.id("pegasus_speed"), 0.2, class_1322.class_1323.field_6331), List.of(class_5134.field_23719, class_5134.field_23723), pony -> pony.getCompositeRace().canFly() && !pony.getCompositeRace().includes(Race.HIPPOGRIFF)), new ToggleableAttribute(new class_1322(Unicopia.id("pegasus_reach"), 1.5, class_1322.class_1323.field_6328), List.of(UEntityAttributes.EXTENDED_REACH_DISTANCE), pony -> pony.getCompositeRace().canFly() && !pony.getCompositeRace().includes(Race.HIPPOGRIFF)), new ToggleableAttribute(new class_1322(Unicopia.id("hippogriff_speed"), 0.1, class_1322.class_1323.field_6331), List.of(class_5134.field_23719, class_5134.field_23723), pony -> pony.getCompositeRace().includes(Race.HIPPOGRIFF)), new ToggleableAttribute(new class_1322(Unicopia.id("hippogriff_reach"), 1.3, class_1322.class_1323.field_6328), List.of(UEntityAttributes.EXTENDED_REACH_DISTANCE), pony -> pony.getCompositeRace().includes(Race.HIPPOGRIFF)), new ToggleableAttribute(new class_1322(Unicopia.id("kirin_knockback_vulneravility"), -2.0, class_1322.class_1323.field_6328), List.of(class_5134.field_23718), pony -> pony.getCompositeRace().includes(Race.KIRIN)), new ToggleableAttribute(new class_1322(Unicopia.id("kirin_rage"), 0.7, class_1322.class_1323.field_6331), List.of(class_5134.field_23719, class_5134.field_23723, class_5134.field_23721, class_5134.field_23718, class_5134.field_23722), SpellType.RAGE::isOn));
    public static final class_2960 HEALTH_SWAPPING_MODIFIER_ID = Unicopia.id("health_swap");
    private final Pony pony;

    public static class_1322 healthChange(float addition) {
        return new class_1322(HEALTH_SWAPPING_MODIFIER_ID, (double)addition, class_1322.class_1323.field_6328);
    }

    public PlayerAttributes(Pony pony) {
        this.pony = pony;
    }

    @Override
    public void tick() {
        ATTRIBUTES.forEach(attribute -> attribute.update(this.pony));
        EffectUtils.applyStatusEffect(this.pony.asEntity(), UEffects.FORTIFICATION, this.pony.getCompositeRace().canUseEarth() && ((class_1657)this.pony.asEntity()).method_5715());
    }

    record ToggleableAttribute(class_1322 modifier, List<class_6880<class_1320>> attributes, Predicate<Pony> test) {
        public void update(Pony pony) {
            boolean enable = this.test.test(pony);
            this.attributes.forEach(attribute -> pony.applyAttributeModifier((class_6880<class_1320>)attribute, this.modifier, true, enable));
        }
    }
}

