/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.input;

import com.minelittlepony.unicopia.input.Heuristic;
import com.minelittlepony.unicopia.util.Tickable;
import java.util.function.BooleanSupplier;

public class Interactable
implements Tickable {
    private final BooleanSupplier stateGetter;
    private boolean prevState;
    private boolean currentState;
    private long prevActivationTime;
    private long activationTime;

    public Interactable(BooleanSupplier stateGetter) {
        this.stateGetter = stateGetter;
    }

    @Override
    public void tick() {
        this.prevState = this.currentState;
        this.currentState = this.stateGetter.getAsBoolean();
        if (this.prevState != this.currentState && this.currentState) {
            this.prevActivationTime = this.activationTime;
            this.activationTime = System.currentTimeMillis();
        }
    }

    public boolean getState() {
        return this.currentState;
    }

    public boolean hasChanged(Heuristic changeType) {
        if (changeType == Heuristic.ONCE) {
            return this.prevState != this.currentState;
        }
        long stageDuration = 250L;
        long now = System.currentTimeMillis();
        return this.activationTime > now - 250L && this.prevActivationTime > this.activationTime - 250L;
    }
}

