/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.item;

import com.google.common.base.Predicates;
import com.minelittlepony.unicopia.InteractionManager;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.block.UBlocks;
import com.minelittlepony.unicopia.compat.trinkets.TrinketsDelegate;
import com.minelittlepony.unicopia.entity.IItemEntity;
import com.minelittlepony.unicopia.entity.ItemImpl;
import com.minelittlepony.unicopia.entity.ItemTracker;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.damage.UDamageTypes;
import com.minelittlepony.unicopia.entity.effect.UEffects;
import com.minelittlepony.unicopia.entity.mob.SombraEntity;
import com.minelittlepony.unicopia.entity.mob.SpellbookEntity;
import com.minelittlepony.unicopia.entity.player.MagicReserves;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.AmuletItem;
import com.minelittlepony.unicopia.item.DamageChecker;
import com.minelittlepony.unicopia.item.ItemStackDuck;
import com.minelittlepony.unicopia.item.TickableItem;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.item.component.Charges;
import com.minelittlepony.unicopia.particle.FollowingParticleEffect;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.particle.UParticles;
import com.minelittlepony.unicopia.server.world.UnicopiaWorldProperties;
import com.minelittlepony.unicopia.util.VecHelper;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMaps;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1533;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1924;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import net.minecraft.class_9331;
import net.minecraft.class_9701;

public class AlicornAmuletItem
extends AmuletItem
implements ItemTracker.Trackable,
ItemImpl.ClingyItem,
TickableItem,
DamageChecker {
    private static final class_2960 EFFECT_ID = Unicopia.id("alicorn_amulet_modifiers");
    private static final Object2FloatMap<class_6880<class_1320>> EFFECT_SCALES = Object2FloatMaps.unmodifiable((Object2FloatMap)new Object2FloatOpenHashMap(Map.of(class_5134.field_23721, Float.valueOf(0.2f), class_5134.field_23722, Float.valueOf(0.05f), class_5134.field_23723, Float.valueOf(0.2f), class_5134.field_23725, Float.valueOf(0.001f), class_5134.field_23724, Float.valueOf(0.01f))));
    private static final Float2ObjectFunction<class_1322> EFFECT_FACTORY = v -> new class_1322(EFFECT_ID, (double)v, class_1322.class_1323.field_6328);

    public AlicornAmuletItem(class_1792.class_1793 settings) {
        super(settings, 0);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        ItemStackDuck.of(stack).getTransientComponents().getCarrier().flatMap(Pony::of).ifPresent(pony -> {
            long ticks;
            if (pony.getArmourStacks().anyMatch(i -> i == stack) && (ticks = pony.getArmour().getTicks(this)) > 0L) {
                tooltip.add((class_2561)class_2561.method_43470((String)ItemTracker.formatTicks(ticks, context.method_59531()).formatted(class_124.field_1080)));
            }
        });
    }

    @Override
    public class_2394 getParticleEffect(IItemEntity entity) {
        return ((class_1542)entity).method_37908().field_9229.method_43056() ? class_2398.field_11237 : class_2398.field_11240;
    }

    @Override
    public boolean isClingy(class_1799 stack) {
        return true;
    }

    @Override
    public boolean takesDamageFrom(class_1282 source) {
        return source.method_48789(class_8103.field_42242);
    }

    @Override
    public float getFollowDistance(IItemEntity entity) {
        return Math.max(20.0f, ItemImpl.ClingyItem.super.getFollowDistance(entity));
    }

    @Override
    public float getFollowSpeed(IItemEntity entity) {
        return Math.max(0.12f, ItemImpl.ClingyItem.super.getFollowSpeed(entity));
    }

    @Override
    public void interactWithPlayer(IItemEntity item, class_1657 player) {
        class_1542 entity = (class_1542)item;
        if (!player.method_37908().field_9236 && !entity.method_31481() && !player.method_7337() && player.method_19538().method_1022(entity.method_19538()) < 0.5 && entity.method_37908().field_9229.method_43048(150) == 0) {
            class_1271<class_1799> result;
            entity.method_6982(0);
            entity.method_5694(player);
            if (player.method_6047().method_7909() == this && (result = this.method_7836(player.method_37908(), player, class_1268.field_5808)).method_5467() == class_1269.field_5812) {
                entity.method_6982(1000);
                entity.method_31745(class_1297.class_5529.field_26999);
            }
        }
    }

    @Override
    public void onEquipped(Living<?> wearer) {
        wearer.playSound(USounds.ITEM_ALICORN_AMULET_CURSE, 0.5f, 1.0f);
    }

    @Override
    public void onUnequipped(Living<?> wearer, long timeWorn) {
        class_1657 player;
        Object entity = wearer.asEntity();
        if (entity instanceof class_1657 && (player = (class_1657)entity).method_7337()) {
            return;
        }
        float attachedTime = timeWorn / 1000L;
        class_1266 difficulty = wearer.asWorld().method_8404(wearer.getOrigin());
        float amount = Math.min(entity.method_6063() - 1.0f, attachedTime / 4.0f * (1.0f + difficulty.method_5458()));
        if (timeWorn > 24000L) {
            amount += 1.0f;
        }
        if (entity instanceof class_1657) {
            class_1657 player2 = (class_1657)entity;
            player2.method_7344().method_7580(1);
        }
        entity.method_5643((class_1282)wearer.damageOf(UDamageTypes.ALICORN_AMULET), amount);
        entity.method_6092(new class_1293(class_1294.field_5916, 200, 1));
        if (timeWorn > 1000L) {
            entity.method_6092(new class_1293(class_1294.field_5911, 200, 3));
        }
        if (attachedTime > 500.0f) {
            entity.method_6005(1.0, 1.0, 1.0);
            wearer.updateVelocity();
        }
        AlicornAmuletItem.updateAttributes(wearer, 0.0f);
    }

    public static void updateAttributes(Living<?> wearer, float effectScale) {
        EFFECT_SCALES.object2FloatEntrySet().forEach(entry -> wearer.updateAttributeModifier(EFFECT_ID, (class_6880<class_1320>)((class_6880)entry.getKey()), entry.getFloatValue() * effectScale, EFFECT_FACTORY, false));
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        boolean fullSecond;
        Living<class_1297> living;
        if (world.field_9236) {
            return;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (selected && !AlicornAmuletItem.isApplicable((class_1309)player, (class_1935)this) && world.field_9229.method_43048(320) == 0) {
                this.method_7836(world, player, class_1268.field_5808);
                return;
            }
        }
        if ((living = Living.living(entity)) == null || !living.getArmour().contains(this)) {
            return;
        }
        if (entity instanceof class_1657 && entity.method_5809() && world.method_8320(entity.method_24515().method_10084()).method_27852(UBlocks.SPECTRAL_FIRE) && UnicopiaWorldProperties.forWorld((class_3218)world).isActiveAltar(entity)) {
            if (living.asEntity().method_6032() < 2.0f) {
                entity.method_20803(0);
                world.method_8650(entity.method_24515().method_10084(), false);
                stack.method_7934(1);
                world.method_8437(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), 0.0f, class_1937.class_7867.field_40888);
                world.method_8396(null, entity.method_24515(), USounds.ENTITY_SOMBRA_LAUGH, class_3419.field_15256, 10.0f, 1.0f);
                world.method_8390(SpellbookEntity.class, entity.method_5829().method_1014(6.0), (Predicate)Predicates.alwaysTrue()).forEach(class_1297::method_5768);
                SombraEntity.startEncounter(world, entity.method_24515());
            }
            return;
        }
        long attachedTicks = living.getArmour().getTicks(this);
        long daysAttached = attachedTicks / 24000L;
        boolean bl = fullSecond = attachedTicks % 20L == 0L;
        if (entity instanceof class_1657) {
            MagicReserves reserves;
            TrinketsDelegate.EquippedStack equipped;
            class_1657 player = (class_1657)entity;
            if (daysAttached <= 4L) {
                if (player.method_6032() < player.method_6063()) {
                    player.method_6025(0.5f);
                } else if (player.method_7332(false)) {
                    player.method_7344().method_7585(1, 0.0f);
                }
            }
            Pony pony = (Pony)living;
            if (daysAttached >= 2L) {
                if (pony.asWorld().field_9229.method_43048(200) == 0 && !((class_1657)pony.asEntity()).method_6059(UEffects.BUTTER_FINGERS)) {
                    ((class_1657)pony.asEntity()).method_6092(new class_1293(UEffects.BUTTER_FINGERS, 2100, 1));
                }
                pony.findAllEntitiesInRange(10.0, e -> e instanceof class_1309 && !((class_1309)e).method_6059(UEffects.CORRUPT_INFLUENCE)).forEach(e -> ((class_1309)e).method_6092(new class_1293(UEffects.CORRUPT_INFLUENCE, 100, 1)));
            }
            if (!(daysAttached < 3L || ((class_1657)pony.asEntity()).method_7337() || (equipped = AlicornAmuletItem.getForEntity((class_1309)living.asEntity(), this)).stack().method_7960() || class_1890.method_60142((class_1799)equipped.stack(), (class_9331)class_9701.field_51656))) {
                pony.playSound(USounds.ITEM_ALICORN_AMULET_HALLUCINATION, 3.0f, 1.0f);
                stack.method_7978(pony.entryFor(class_1893.field_9113), 1);
                equipped.sendUpdate().run();
            }
            if ((reserves = pony.getMagicalReserves()).getExertion().get() < reserves.getExertion().getMax()) {
                reserves.getExertion().add(0.02f);
            }
            if (fullSecond && world.field_9229.method_43048(12) == 0 && !((class_1657)pony.asEntity()).method_7337()) {
                reserves.getEnergy().add(10.0f);
                pony.getCorruption().add((int)class_3532.method_53062((long)(attachedTicks / 1000L), (long)1L, (long)pony.getCorruption().getMax()));
            }
            if (attachedTicks % 1000L < 90L && world.field_9229.method_43048(900) == 0) {
                pony.playSound(USounds.ITEM_ALICORN_AMULET_HALLUCINATION, 3.0f, 1.0f);
            } else if (attachedTicks < 2L || attachedTicks % 200L < 9L && world.field_9229.method_43048(90) == 0) {
                if (attachedTicks % 5L == 0L) {
                    InteractionManager.getInstance().playLoopingSound((class_1297)player, 6, 0L);
                }
                reserves.getExertion().addPercent(10.0f);
                reserves.getEnergy().add(10.0f);
                living.asEntity().method_6016(class_1294.field_5911);
                living.asEntity().method_6016(class_1294.field_5916);
            }
            if (daysAttached >= 4L) {
                if (attachedTicks % 100L == 0L) {
                    player.method_7344().method_7583(90.0f);
                    float healthDrop = class_3532.method_15363((float)(player.method_6063() - player.method_6032()), (float)2.0f, (float)5.0f);
                    player.method_5643((class_1282)pony.damageOf(UDamageTypes.ALICORN_AMULET), healthDrop);
                }
                return;
            }
        }
        if (fullSecond) {
            AlicornAmuletItem.updateAttributes(living, (float)attachedTicks / 20.0f);
        }
    }

    @Override
    public class_1269 onGroundTick(IItemEntity item) {
        class_1542 entity = (class_1542)item;
        if (entity.method_37908().field_9229.method_43048(500) == 0) {
            entity.method_37908().method_8396(null, entity.method_24515(), USounds.ITEM_ALICORN_AMULET_AMBIENT, class_3419.field_15251, 0.5f, 1.0f);
        }
        return class_1269.field_5811;
    }

    @Override
    public void inFrameTick(class_1533 entity) {
        class_5819 rng = entity.method_37908().field_9229;
        if (rng.method_43048(1500) == 0) {
            entity.method_37908().method_8396(null, entity.method_24515(), USounds.ITEM_ALICORN_AMULET_AMBIENT, class_3419.field_15251, 0.5f, 1.0f);
            for (int i = 0; i < 5; ++i) {
                entity.method_37908().method_8406((class_2394)(rng.method_43056() ? class_2398.field_11237 : class_2398.field_11240), rng.method_43385(entity.method_23317(), 0.5), rng.method_43385(entity.method_23318(), 0.5), rng.method_43385(entity.method_23321(), 0.5), 0.0, 0.0, 0.0);
            }
        }
        if (entity.field_6012 / 1000 % 10 == 0 && entity.field_6012 % 50 == 0) {
            for (class_1297 target : VecHelper.findInRange((class_1297)entity, (class_1924)entity.method_37908(), entity.method_19538(), 10.0, class_1301.field_6156)) {
                if (!(target instanceof class_1309)) continue;
                class_1309 l = (class_1309)target;
                for (class_1799 equipment : l.method_56675()) {
                    if (!equipment.method_31574(UItems.GROGARS_BELL) || !Charges.discharge(equipment, 3)) continue;
                    ParticleUtils.spawnParticle(entity.method_37908(), new FollowingParticleEffect(UParticles.HEALTH_DRAIN, (class_1297)entity, 0.4f).withChild((class_2394)class_2398.field_17741), target.method_33571(), class_243.field_1353);
                }
            }
        }
    }
}

