/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.item;

import com.google.common.base.Suppliers;
import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.UTags;
import com.minelittlepony.unicopia.advancement.UCriteria;
import com.minelittlepony.unicopia.entity.damage.UDamageTypes;
import com.minelittlepony.unicopia.entity.mob.FloatingArtefactEntity;
import com.minelittlepony.unicopia.entity.mob.UEntities;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.particle.FollowingParticleEffect;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.particle.UParticles;
import com.minelittlepony.unicopia.util.VecHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1321;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1924;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3988;
import net.minecraft.class_5146;
import net.minecraft.class_5551;

public class CrystalHeartItem
extends class_1792
implements FloatingArtefactEntity.Artifact {
    static final Predicate<class_1297> TARGET_PREDICATE = class_1301.field_6156.and(class_1301.field_6154).and(e -> e instanceof class_1657 || e instanceof class_1308);
    private static final Supplier<Map<class_1792, class_1792>> ITEM_MAP = Suppliers.memoize(() -> Map.of(class_1802.field_8550, UItems.LOVE_BUCKET, class_1802.field_8469, UItems.LOVE_BOTTLE, UItems.MUG, UItems.LOVE_MUG));

    private static boolean isFillable(class_1799 stack) {
        return ITEM_MAP.get().containsKey(stack.method_7909());
    }

    private static class_1799 fill(class_1799 stack) {
        class_1792 item = ITEM_MAP.get().getOrDefault(stack.method_7909(), stack.method_7909());
        return item == stack.method_7909() ? stack : stack.method_60503((class_1935)item);
    }

    public CrystalHeartItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 blockPos = new class_1750(context).method_8037();
        class_238 placementArea = UEntities.FLOATING_ARTEFACT.method_18386().method_30757(class_243.method_24955((class_2382)blockPos));
        if (!world.method_8587(null, placementArea)) {
            return class_1269.field_5814;
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            Consumer consumer = class_1299.method_48009((class_3218)serverWorld, (class_1799)context.method_8041(), (class_1657)context.method_8036());
            FloatingArtefactEntity entity = (FloatingArtefactEntity)UEntities.FLOATING_ARTEFACT.method_5888(serverWorld, consumer, blockPos, class_3730.field_16465, false, true);
            if (entity == null) {
                return class_1269.field_5814;
            }
            entity.setStack(context.method_8041().method_7971(1));
            serverWorld.method_8649((class_1297)entity);
            if (this.findStructure(entity)) {
                entity.method_5783(USounds.ENTITY_CRYSTAL_HEART_ACTIVATE, 0.75f, 0.8f);
                UCriteria.POWER_UP_HEART.trigger((class_1297)context.method_8036());
            }
        } else {
            context.method_8041().method_7934(1);
        }
        return class_1269.method_29236((boolean)world.field_9236);
    }

    @Override
    public void onArtifactTick(FloatingArtefactEntity entity) {
        if (entity.getState() == FloatingArtefactEntity.State.INITIALISING) {
            if (entity.field_6012 % 30 == 0 && this.findStructure(entity)) {
                entity.setState(FloatingArtefactEntity.State.RUNNING);
                entity.setRotationSpeed(4.0f, 30);
            }
        } else {
            if (entity.field_6012 % 30 == 0 && !this.findStructure(entity)) {
                entity.setState(FloatingArtefactEntity.State.INITIALISING);
            }
            class_2338 pos = entity.method_24515();
            entity.method_37908().method_8406((class_2394)class_2398.field_17741, (double)((float)pos.method_10263() + entity.method_37908().method_8409().method_43057()), (double)((float)pos.method_10264() + entity.method_37908().method_8409().method_43057()), (double)((float)pos.method_10260() + entity.method_37908().method_8409().method_43057()), 0.0, 0.0, 0.0);
            if (entity.field_6012 % 80 == 0 && !entity.method_37908().field_9236) {
                ArrayList inputs = new ArrayList();
                ArrayList outputs = new ArrayList();
                ArrayList containers = new ArrayList();
                VecHelper.findInRange(entity, (class_1924)entity.method_37908(), entity.method_19538(), 20.0, TARGET_PREDICATE).forEach(e -> {
                    class_5146 s;
                    class_1321 t;
                    class_1309 living = (class_1309)e;
                    if (e instanceof class_1657 || e instanceof class_1321 && (t = (class_1321)e).method_6181() || e instanceof class_5146 && (s = (class_5146)e).method_6725() || e instanceof class_3988) {
                        if (living.method_6032() < living.method_6063()) {
                            outputs.add(living);
                        }
                    } else if (e.method_5864().method_5891() == class_1311.field_6302) {
                        inputs.add(living);
                    }
                });
                VecHelper.findInRange(entity, (class_1924)entity.method_37908(), entity.method_19538(), 20.0, i -> {
                    class_1542 ie;
                    return i instanceof class_1542 && CrystalHeartItem.isFillable((ie = (class_1542)i).method_6983()) && EquinePredicates.CHANGELING.test((class_1297)i);
                }).forEach(i -> containers.add((class_1542)i));
                int demand = outputs.size() + containers.stream().mapToInt(i -> i.method_6983().method_7947()).sum();
                int supply = inputs.size();
                if (demand == 0 || supply == 0) {
                    return;
                }
                float gives = supply > demand ? (float)(supply / demand) : 1.0f;
                float takes = demand > supply ? (float)(demand / supply) : 1.0f;
                inputs.forEach(input -> {
                    input.method_5643((class_1282)entity.damageOf(UDamageTypes.LIFE_DRAINING), takes);
                    ParticleUtils.spawnParticles(new FollowingParticleEffect(UParticles.HEALTH_DRAIN, entity, 0.2f), (class_1297)input, 1);
                });
                outputs.forEach(output -> {
                    ParticleUtils.spawnParticles(new FollowingParticleEffect(UParticles.HEALTH_DRAIN, (class_1297)output, 0.2f), entity, 1);
                    output.method_6025(gives);
                });
                containers.forEach(container -> {
                    ParticleUtils.spawnParticles(new FollowingParticleEffect(UParticles.HEALTH_DRAIN, (class_1297)container, 0.2f), entity, 1);
                    container.method_6979(CrystalHeartItem.fill(container.method_6983()));
                });
                if (gives > 0.0f) {
                    entity.setRotationSpeed(37.0f, 80);
                }
            }
        }
    }

    @Override
    public class_1269 onArtifactDestroyed(FloatingArtefactEntity entity) {
        entity.method_5783(USounds.ENTITY_CRYSTAL_HEART_DEACTIVATE, 0.75f, 1.0f);
        entity.method_5699(new class_1799((class_1935)UItems.CRYSTAL_SHARD, 1 + entity.method_37908().field_9229.method_43048(5)), 0.0f);
        return class_1269.field_5812;
    }

    private boolean findStructure(FloatingArtefactEntity entity) {
        return this.findPyramid(entity, class_2350.field_11036) && this.findPyramid(entity, class_2350.field_11033);
    }

    private boolean findPyramid(FloatingArtefactEntity entity, class_2350 direction) {
        class_2338 tip = entity.method_24515().method_10093(direction);
        class_2680 tipState = entity.method_37908().method_8320(tip);
        if (!tipState.method_26164(UTags.Blocks.CRYSTAL_HEART_ORNAMENT) || !tipState.method_28498((class_2769)class_5551.field_10927) || tipState.method_11654((class_2769)class_5551.field_10927) != direction.method_10153()) {
            return false;
        }
        tip = tip.method_10093(direction);
        if (!this.isDiamond(entity.method_37908().method_8320(tip))) {
            return false;
        }
        class_2338 center = tip = tip.method_10093(direction);
        return class_2338.method_25998((class_2338)center, (int)1, (int)0, (int)1).filter(p -> p.method_10263() == center.method_10263() || p.method_10260() == center.method_10260()).map(arg_0 -> ((class_1937)entity.method_37908()).method_8320(arg_0)).allMatch(this::isDiamond);
    }

    private boolean isDiamond(class_2680 state) {
        return state.method_26164(UTags.Blocks.CRYSTAL_HEART_BASE);
    }
}

