/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.item;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.CastingMethod;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.client.render.PlayerPoser;
import com.minelittlepony.unicopia.entity.mob.CastSpellEntity;
import com.minelittlepony.unicopia.entity.mob.UEntities;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.EnchantableItem;
import com.minelittlepony.unicopia.item.StaffItem;
import com.minelittlepony.unicopia.item.component.Charges;
import com.minelittlepony.unicopia.item.component.UDataComponentTypes;
import com.minelittlepony.unicopia.item.group.MultiItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3419;

public class EnchantedStaffItem
extends StaffItem
implements EnchantableItem,
MultiItem,
Charges.ChargeChangeCallback {
    private static final Map<class_1299<?>, SpellType<?>> ENTITY_TYPE_TO_SPELL = new HashMap();

    public static <T extends Spell> SpellType<T> register(class_1299<?> entityType, SpellType<T> spellType) {
        ENTITY_TYPE_TO_SPELL.put(entityType, spellType);
        return spellType;
    }

    public static SpellType<?> getSpellType(class_1297 entity, boolean remove) {
        if (entity instanceof CastSpellEntity) {
            CastSpellEntity cast = (CastSpellEntity)entity;
            return cast.getSpellSlot().get(SpellType.PLACE_CONTROL_SPELL.negate()).map(Spell::getTypeAndTraits).map(CustomisedSpellType::type).orElse(SpellType.empty());
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (remove) {
                return Pony.of(player).getCharms().equipSpell(class_1268.field_5808, SpellType.EMPTY_KEY.withTraits()).type();
            }
            return Pony.of(player).getCharms().getEquippedSpell(class_1268.field_5808).type();
        }
        return ENTITY_TYPE_TO_SPELL.getOrDefault(entity.method_5864(), SpellType.empty());
    }

    public EnchantedStaffItem(class_1792.class_1793 settings) {
        super(settings.method_57349(UDataComponentTypes.CHARGES, (Object)new Charges(3, 3, 3, true)).method_7895(500));
    }

    @Override
    public List<class_1799> getDefaultStacks() {
        return Stream.concat(Stream.of(this.method_7854()), ENTITY_TYPE_TO_SPELL.values().stream().distinct().map(type -> EnchantableItem.enchant(this.method_7854(), type))).toList();
    }

    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> lines, class_1836 type) {
        if (EnchantableItem.isEnchanted(stack)) {
            SpellType key = EnchantableItem.getSpellKey(stack);
            lines.add((class_2561)class_2561.method_43471((String)key.getTranslationKey()).method_27692(key.getAffinity().getColor()));
        }
    }

    @Override
    public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 target, class_1268 hand) {
        if (EnchantableItem.isEnchanted(stack)) {
            return class_1269.field_5811;
        }
        super.method_7847(stack, player, target, hand);
        boolean remove = class_1301.field_6156.test(target);
        SpellType<?> type = EnchantedStaffItem.getSpellType((class_1297)target, remove);
        if (!type.isEmpty()) {
            if (remove) {
                target.method_6033(1.0f);
                target.method_32317(9000);
            }
            stack = EnchantableItem.enchant(stack, type);
            Charges.recharge(stack);
            player.method_6122(hand, stack);
        }
        return class_1269.field_5812;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        player.method_6019(hand);
        return class_1271.method_22428((Object)itemstack);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 entity, int timeLeft) {
        int i = this.method_7881(stack, entity) - timeLeft;
        if (i > 5 && EnchantableItem.isEnchanted(stack)) {
            CustomisedSpellType<?> spellType = EnchantableItem.getSpellEffect(stack);
            if (Charges.discharge(stack, 1)) {
                Pony.of((class_1297)entity).ifPresent(pony -> {
                    spellType.apply((Caster<?>)pony, CastingMethod.STAFF);
                    pony.setAnimation(PlayerPoser.Animation.ARMS_UP, PlayerPoser.Animation.Recipient.ANYONE, 10);
                    stack.method_7970(1, pony.asEntity(), class_1304.field_6173);
                    pony.subtractEnergyCost(4.0);
                });
            }
        }
    }

    @Override
    protected boolean castContainedEffect(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (attacker.method_5715()) {
            CustomisedSpellType<?> spellType = EnchantableItem.getSpellEffect(stack);
            if (Charges.discharge(stack, 1)) {
                stack.method_7970(50, attacker, class_1304.field_6173);
                Caster.of((class_1297)attacker).ifPresent(c -> c.subtractEnergyCost(4.0));
                Caster.of((class_1297)target).ifPresent(c -> spellType.apply((Caster<?>)c, CastingMethod.STAFF));
            }
        }
        return false;
    }

    public void method_7852(class_1937 world, class_1309 entity, class_1799 stack, int ticksRemaining) {
        class_1309 living;
        if (entity instanceof class_1309 && (living = entity).method_6030().method_7909() == this) {
            class_243 eyes = entity.method_5836(1.0f);
            float i = this.method_7881(stack, entity) - ticksRemaining;
            world.method_8406((class_2394)(i > 150.0f ? class_2398.field_11237 : class_2398.field_11204), eyes.field_1352, eyes.field_1351, eyes.field_1350, (world.field_9229.method_43059() - 0.5) / 10.0, (world.field_9229.method_43059() - 0.5) / 10.0, (world.field_9229.method_43059() - 0.5) / 10.0);
            world.method_8396(null, entity.method_24515(), USounds.ITEM_MAGIC_STAFF_CHARGE, class_3419.field_15248, 1.0f, i / 20.0f);
            if (i > 200.0f) {
                living.method_6021();
                living.method_5643(entity.method_48923().method_48831(), 1.0f);
                if (EnchantableItem.isEnchanted(stack)) {
                    CustomisedSpellType<?> spellType = EnchantableItem.getSpellEffect(stack);
                    if (Charges.discharge(stack, 1)) {
                        Caster.of((class_1297)entity).ifPresent(c -> spellType.apply((Caster<?>)c, CastingMethod.STAFF));
                    }
                }
            }
        }
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 72000;
    }

    public class_2561 method_7864(class_1799 stack) {
        if (EnchantableItem.isEnchanted(stack) && Charges.of(stack).energy() > 0) {
            return class_2561.method_43469((String)(this.method_7866(stack) + ".enchanted"), (Object[])new Object[]{super.method_7864(stack), EnchantableItem.getSpellKey(stack).getName()});
        }
        return super.method_7864(stack);
    }

    @Override
    public void onDischarge(class_1799 stack) {
        if (Charges.of(stack).energy() == 0) {
            EnchantableItem.unenchant(stack);
        }
    }

    static {
        EnchantedStaffItem.register(class_1299.field_6123, SpellType.BUBBLE);
        EnchantedStaffItem.register(class_1299.field_6087, SpellType.BUBBLE);
        EnchantedStaffItem.register(class_1299.field_6099, SpellType.FIRE_BOLT);
        EnchantedStaffItem.register(class_1299.field_6132, SpellType.FEATHER_FALL);
        EnchantedStaffItem.register(class_1299.field_6046, SpellType.CATAPULT);
        EnchantedStaffItem.register(class_1299.field_6071, SpellType.HYDROPHOBIC);
        EnchantedStaffItem.register(class_1299.field_6047, SpellType.FROST);
        EnchantedStaffItem.register(class_1299.field_6042, SpellType.FROST);
        EnchantedStaffItem.register(class_1299.field_6066, SpellType.FLAME);
        EnchantedStaffItem.register(class_1299.field_6049, SpellType.FLAME);
        EnchantedStaffItem.register(class_1299.field_6116, SpellType.DISPLACEMENT);
        EnchantedStaffItem.register(class_1299.field_6118, SpellType.AWKWARD);
        EnchantedStaffItem.register(class_1299.field_6086, SpellType.AWKWARD);
        EnchantedStaffItem.register(class_1299.field_6129, SpellType.INFERNAL);
        EnchantedStaffItem.register(class_1299.field_6084, SpellType.REVEALING);
        EnchantedStaffItem.register(class_1299.field_6051, SpellType.NECROMANCY);
        EnchantedStaffItem.register(class_1299.field_6059, SpellType.NECROMANCY);
        EnchantedStaffItem.register(class_1299.field_6137, SpellType.CATAPULT);
        EnchantedStaffItem.register(class_1299.field_6076, SpellType.CATAPULT);
        EnchantedStaffItem.register(class_1299.field_6075, SpellType.CATAPULT);
        EnchantedStaffItem.register(UEntities.TWITTERMITE, SpellType.LIGHT);
    }
}

