/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.projectile;

import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.WeaklyOwned;
import com.minelittlepony.unicopia.entity.EntityReference;
import com.minelittlepony.unicopia.entity.mob.UEntities;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.projectile.ProjectileDelegate;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1540;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3857;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class MagicProjectileEntity
extends class_3857
implements WeaklyOwned.Mutable<class_1309> {
    private static final class_2940<Float> DAMAGE = class_2945.method_12791(MagicProjectileEntity.class, (class_2941)class_2943.field_13320);
    public static final byte PROJECTILE_COLLISSION = 3;
    private final EntityReference<class_1297> homingTarget = new EntityReference();
    private EntityReference<class_1309> owner;
    private int maxAge = 90;

    public MagicProjectileEntity(class_1299<? extends MagicProjectileEntity> type, class_1937 world) {
        super(type, world);
    }

    public MagicProjectileEntity(class_1937 world) {
        this(UEntities.THROWN_ITEM, world);
    }

    public MagicProjectileEntity(class_1937 world, class_1309 thrower) {
        super(UEntities.THROWN_ITEM, thrower, world);
    }

    protected MagicProjectileEntity(class_1299<? extends MagicProjectileEntity> type, class_1937 world, class_1309 thrower) {
        super(type, thrower, world);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    @Override
    public class_1937 asWorld() {
        return this.method_37908();
    }

    protected class_1792 method_16942() {
        return UItems.GEMSTONE;
    }

    @Override
    public final void setMaster(class_1309 owner) {
        this.method_7432((class_1297)owner);
    }

    public void method_7432(@Nullable class_1297 entity) {
        super.method_7432(entity);
        if (entity instanceof class_1309) {
            class_1309 l = (class_1309)entity;
            WeaklyOwned.Mutable.super.setMaster(l);
        }
    }

    @Nullable
    public final class_1297 method_24921() {
        return this.getMaster();
    }

    @Override
    public EntityReference<class_1309> getMasterReference() {
        if (this.owner == null) {
            this.owner = new EntityReference();
        }
        return this.owner;
    }

    public void setHomingTarget(@Nullable class_1297 target) {
        this.homingTarget.set(target);
    }

    public void addThrowDamage(float damage) {
        this.setThrowDamage(this.getThrowDamage() + damage);
    }

    public void setThrowDamage(float damage) {
        this.method_5841().method_12778(DAMAGE, (Object)Float.valueOf(Math.max(0.0f, damage)));
    }

    public float getThrowDamage() {
        return ((Float)this.method_5841().method_12789(DAMAGE)).floatValue();
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public void method_5773() {
        if (this.maxAge > 0 && !this.method_37908().method_8608() && this.homingTarget.getOrEmpty(this.asWorld()).isEmpty() && (this.method_18798().method_1033() < 0.1 || this.field_6012 > this.maxAge)) {
            this.method_31472();
        }
        super.method_5773();
        this.homingTarget.ifPresent(this.method_37908(), e -> {
            this.method_5875(true);
            this.field_5960 = true;
            this.method_18799(this.method_18798().method_1019(e.method_19538().method_1020(this.method_19538()).method_1029().method_1021(0.2)).method_18805(0.6, 0.6, 0.6));
        });
    }

    private class_2394 getParticleParameters() {
        class_1799 stack = this.method_7495();
        if (stack.method_7960()) {
            return class_2398.field_11230;
        }
        if (stack.method_31574(UItems.FILLED_JAR)) {
            stack = UItems.EMPTY_JAR.method_7854();
        }
        return new class_2392(class_2398.field_11218, stack);
    }

    public void method_5711(byte id) {
        if (id == 3) {
            class_2394 effect = this.getParticleParameters();
            for (int i = 0; i < 8; ++i) {
                this.method_37908().method_8406(effect, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
            }
        } else {
            super.method_5711(id);
        }
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.homingTarget.fromNBT(compound.method_10562("homingTarget"), (class_7225.class_7874)this.method_56673());
        this.getMasterReference().fromNBT(compound.method_10562("owner"), (class_7225.class_7874)this.method_56673());
        if (compound.method_10573("maxAge", 3)) {
            this.maxAge = compound.method_10550("maxAge");
        }
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10566("homingTarget", (class_2520)this.homingTarget.toNBT((class_7225.class_7874)this.method_56673()));
        compound.method_10566("owner", (class_2520)this.getMasterReference().toNBT((class_7225.class_7874)this.method_56673()));
        compound.method_10569("maxAge", this.maxAge);
    }

    protected void method_7488(class_239 result) {
        if (!this.method_31481()) {
            super.method_7488(result);
            if (!this.method_37908().method_8608()) {
                this.method_37908().method_8421((class_1297)this, (byte)3);
                this.method_31472();
            }
        }
    }

    protected void method_24920(class_3965 hit) {
        super.method_24920(hit);
        this.forEachDelegates(effect -> effect.onImpact(this, hit), ProjectileDelegate.BlockHitListener.PREDICATE);
    }

    protected void method_7454(class_3966 hit) {
        class_1297 entity = hit.method_17782();
        if (!(entity instanceof class_1540) && EquinePredicates.IS_MAGIC_IMMUNE.test(entity)) {
            return;
        }
        if (entity != null) {
            float damage = this.getThrowDamage();
            if (damage > 0.0f) {
                entity.method_5643(this.method_48923().method_48811((class_1297)this, this.method_24921()), this.getThrowDamage());
            }
            this.forEachDelegates(effect -> effect.onImpact(this, hit), ProjectileDelegate.EntityHitListener.PREDICATE);
        }
    }

    public void knockback(class_1309 target, class_1282 source, class_1799 weapon) {
        float f;
        class_1937 class_19372;
        if (weapon != null && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            f = class_1890.method_60175((class_3218)serverWorld, (class_1799)weapon, (class_1297)target, (class_1282)source, (float)0.0f);
        } else {
            f = 0.0f;
        }
        double d = f;
        if (d > 0.0) {
            double e = Math.max(0.0, 1.0 - target.method_45325(class_5134.field_23718));
            class_243 vec3d = this.method_18798().method_18805(1.0, 0.0, 1.0).method_1029().method_1021(d * 0.6 * e);
            if (vec3d.method_1027() > 0.0) {
                target.method_5762(vec3d.field_1352, 0.1, vec3d.field_1350);
            }
        }
    }

    protected <T extends ProjectileDelegate> void forEachDelegates(Consumer<T> consumer, Function<Object, T> predicate) {
        try {
            Optional.ofNullable((ProjectileDelegate)predicate.apply(this.method_7495().method_7909())).ifPresent(consumer);
        }
        catch (Throwable t) {
            Unicopia.LOGGER.error("Error whilst ticking spell on entity {}", this.getMasterReference(), (Object)t);
        }
    }
}

