/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.server.world;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.network.Channel;
import com.minelittlepony.unicopia.network.MsgZapAppleStage;
import com.minelittlepony.unicopia.particle.LightningBoltParticleEffect;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.server.world.WorldOverlay;
import com.minelittlepony.unicopia.util.MeteorlogicalUtil;
import com.minelittlepony.unicopia.util.Tickable;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.stream.StreamSupport;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class ZapAppleStageStore
extends class_18
implements Tickable {
    private static final class_2960 ID = Unicopia.id("zap_apple_stage");
    static final long DAY_LENGTH = 24000L;
    static final long MOON_PHASES = class_2874.field_24752.length;
    private final class_1937 world;
    private Stage lastStage = Stage.HIBERNATING;
    private boolean stageChanged;
    private boolean playedMoonEffect;
    private int nextLightningEvent = 1200;
    private float prevSkyAngle;

    public static ZapAppleStageStore get(class_1937 world) {
        return WorldOverlay.getPersistableStorage(world, ID, ZapAppleStageStore::new, ZapAppleStageStore::new);
    }

    ZapAppleStageStore(class_1937 world, class_2487 compound) {
        this(world);
        this.lastStage = Stage.VALUES[Math.max(0, compound.method_10550("stage")) % Stage.VALUES.length];
        this.stageChanged = compound.method_10577("stageChanged");
        this.playedMoonEffect = compound.method_10577("playedMoonEffect");
        this.nextLightningEvent = compound.method_10550("nextLightningEvent");
    }

    ZapAppleStageStore(class_1937 world) {
        this.world = world;
    }

    @Override
    public void tick() {
        float skyAngle = MeteorlogicalUtil.getSkyAngle(this.world);
        if (skyAngle > 1.0f) {
            if (this.nextLightningEvent > 0) {
                --this.nextLightningEvent;
                this.method_80();
            }
            if (!this.stageChanged && class_3532.method_15347((float)skyAngle, (float)1.5f) || MeteorlogicalUtil.isBetween(skyAngle, 1.5f, 2.0f) && MeteorlogicalUtil.isBetween(this.prevSkyAngle, 1.0f, 1.5f)) {
                this.stageChanged = true;
                if (this.lastStage != Stage.HIBERNATING || this.world.method_30273() == 0) {
                    this.lastStage = this.lastStage.getNext();
                    this.playedMoonEffect = false;
                    this.method_80();
                    this.sendUpdate();
                }
            }
        } else if (this.stageChanged) {
            this.stageChanged = false;
            this.method_80();
        }
        this.prevSkyAngle = skyAngle;
    }

    protected void sendUpdate() {
        Channel.SERVER_ZAP_STAGE.sendToAllPlayers((Object)new MsgZapAppleStage(this.getStage()), this.world);
    }

    public void playMoonEffect(class_2338 pos) {
        if (!this.playedMoonEffect) {
            this.playedMoonEffect = true;
            this.method_80();
            this.world.method_47967(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), USounds.Vanilla.field_15117, class_3419.field_15245, 1.5f, 0.3f, (long)this.world.field_9229.method_43048(1200));
        }
    }

    public void triggerLightningStrike(class_2338 pos) {
        this.world.method_43276((class_6880)class_5712.field_28152, pos, class_5712.class_7397.method_43287((class_2680)this.world.method_8320(pos)));
        ParticleUtils.spawnParticle(this.world, LightningBoltParticleEffect.DEFAULT, class_243.method_24953((class_2382)pos), class_243.field_1353);
        if (this.nextLightningEvent <= 0) {
            StreamSupport.stream(class_2338.method_34848((class_5819)this.world.field_9229, (int)20, (class_2338)pos, (int)10).spliterator(), false).filter(p -> this.world.method_22347(p) && !this.world.method_22347(p.method_10074()) && this.world.method_8311(p)).findFirst().ifPresent(p -> {
                class_1538 bolt = (class_1538)class_1299.field_6112.method_5883(this.world);
                bolt.method_29495(class_243.method_24955((class_2382)pos));
                bolt.method_29498(true);
                this.world.method_8649((class_1297)bolt);
                this.nextLightningEvent = this.world.method_8409().method_39332(1200, 8000);
                this.method_80();
            });
        }
    }

    public boolean hasStageChanged() {
        return this.stageChanged;
    }

    public Stage getStage() {
        return this.lastStage;
    }

    public class_2487 method_75(class_2487 compound, class_7225.class_7874 lookup) {
        compound.method_10569("stage", this.lastStage.ordinal());
        compound.method_10556("stageChanged", this.stageChanged);
        compound.method_10556("playedMoonEffect", this.playedMoonEffect);
        compound.method_10569("nextLightningEvent", this.nextLightningEvent);
        return compound;
    }

    public static enum Stage implements class_3542
    {
        HIBERNATING,
        GREENING,
        FLOWERING,
        FRUITING,
        RIPE;

        static final Stage[] VALUES;
        static final float MAX;
        public static final class_9139<ByteBuf, Stage> PACKET_CODEC;
        private final float ordinal = this.ordinal();

        public Stage getNext() {
            return Stage.byId((this.ordinal() + 1) % VALUES.length);
        }

        public Stage getPrevious() {
            return Stage.byId((this.ordinal() - 1 + VALUES.length) % VALUES.length);
        }

        public float getStageProgress(@Nullable class_1937 world) {
            if (world == null) {
                return 0.0f;
            }
            float skyAngle = MeteorlogicalUtil.getSkyAngle(world);
            float dayProgress = (skyAngle + 1.5f) % 3.0f / 3.0f;
            if (this == HIBERNATING) {
                return ((float)world.method_30273() + dayProgress) / (float)MOON_PHASES;
            }
            return dayProgress;
        }

        public float getCycleProgress(@Nullable class_1937 world) {
            return class_3532.method_16439((float)this.getStageProgress(world), (float)this.ordinal, (float)(this.ordinal + 1.0f)) / MAX;
        }

        private static Stage byId(int id) {
            return VALUES[class_3532.method_15340((int)id, (int)0, (int)VALUES.length)];
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            VALUES = Stage.values();
            MAX = VALUES.length;
            PACKET_CODEC = class_9135.method_56375(i -> VALUES[i], Enum::ordinal);
        }
    }
}

