/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.server.world.chunk;

import com.minelittlepony.unicopia.server.world.chunk.PositionalDataMap;
import com.minelittlepony.unicopia.server.world.chunk.Section;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_4076;

public class Chunk<T extends PositionalDataMap.Hotspot> {
    private final Long2ObjectMap<Section<T>> sections = new Long2ObjectOpenHashMap();
    private final Map<T, Set<Section<T>>> entryToSections = new WeakHashMap<T, Set<Section<T>>>();

    Chunk(long pos) {
    }

    public synchronized Set<T> getState(class_2338 pos) {
        Section section = (Section)this.sections.get((long)class_4076.method_18675((int)pos.method_10264()));
        return section == null ? Set.of() : section.getState(pos);
    }

    public synchronized Set<T> getStates() {
        return new HashSet<T>(this.entryToSections.keySet());
    }

    public synchronized boolean remove(T entry) {
        Set<Section<Section>> sections = this.entryToSections.remove(entry);
        if (sections != null) {
            sections.forEach(section -> {
                if (section.remove(entry) && section.isEmpty()) {
                    this.sections.remove(section.pos);
                }
            });
            return true;
        }
        return false;
    }

    public synchronized boolean update(T entry, class_238 entryBox) {
        Set<Section<Section>> oldSections = this.entryToSections.get(entry);
        Set<Section<Section>> newSections = this.getIntersectingSections(entryBox);
        if (oldSections != null) {
            oldSections.forEach(section -> {
                if (!newSections.contains(section) && section.remove(entry) && section.isEmpty()) {
                    this.sections.remove(section.pos);
                }
            });
        }
        newSections.forEach(chunk -> chunk.update(entry, entryBox));
        this.entryToSections.put(entry, newSections);
        return true;
    }

    private Set<Section<T>> getIntersectingSections(class_238 entryBox) {
        HashSet<Section<T>> sections = new HashSet<Section<T>>();
        int minY = class_4076.method_32204((double)entryBox.field_1322);
        int maxY = class_4076.method_32204((double)entryBox.field_1325);
        for (int y = minY; y <= maxY; ++y) {
            sections.add((Section)this.sections.computeIfAbsent((long)y, Section::new));
        }
        return sections;
    }
}

