/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.util;

import com.minelittlepony.unicopia.Unicopia;
import net.minecraft.class_156;
import net.minecraft.class_3532;

public class Lerp {
    private long duration;
    private long startTime;
    private float start;
    private float end;
    private boolean finished = true;
    private final boolean angle;

    public Lerp(float initial) {
        this(initial, false);
    }

    public Lerp(float initial, boolean angle) {
        this.end = initial;
        this.angle = angle;
    }

    public boolean update(float newTarget, long changeDuration) {
        if (Float.isNaN(newTarget) || Float.isInfinite(newTarget)) {
            Unicopia.LOGGER.error("Invalid lerp target. Target cannot be NaN or Infinity");
        }
        if (class_3532.method_15347((float)this.end, (float)newTarget)) {
            return false;
        }
        if (changeDuration == 0L) {
            this.start = newTarget;
            this.end = newTarget;
            this.finished = true;
            return false;
        }
        this.start = this.getValue();
        this.startTime = class_156.method_658();
        this.end = newTarget;
        this.duration = changeDuration;
        this.finished = false;
        if (Float.isNaN(this.start) || Float.isInfinite(this.start)) {
            Unicopia.LOGGER.error("Invalid lerp start. Value cannot be NaN or Infinity");
        }
        if (Float.isNaN(this.end) || Float.isInfinite(this.end)) {
            Unicopia.LOGGER.error("Invalid lerp end. Value cannot be NaN or Infinity");
        }
        return true;
    }

    public float getValue() {
        if (this.finished) {
            return this.end;
        }
        float delta = this.getDelta();
        boolean bl = this.finished = delta >= 1.0f;
        if (this.angle) {
            return class_3532.method_17821((float)delta, (float)this.start, (float)this.end);
        }
        return class_3532.method_16439((float)delta, (float)this.start, (float)this.end);
    }

    public float getTarget() {
        return this.end;
    }

    public boolean isFinished() {
        return this.finished;
    }

    private float getDelta() {
        if (this.duration == 0L) {
            return 1.0f;
        }
        return class_3532.method_15363((float)((float)(class_156.method_658() - this.startTime) / (float)this.duration), (float)0.0f, (float)1.0f);
    }
}

