/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_3545;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public final class Weighted {
    private static final Supplier<Optional<?>> EMPTY = Optional::empty;

    public static <T> Supplier<Optional<T>> of() {
        return EMPTY;
    }

    public static <T> Supplier<Optional<T>> of(Consumer<Builder<T>> constructor) {
        Builder result = new Builder();
        constructor.accept(result);
        return result.build();
    }

    public static <T> Supplier<Optional<T>> of(Collection<? extends Buildable<T>> entries) {
        return Weighted.of((Builder<T> builder) -> entries.forEach(entry -> entry.appendTo(builder)));
    }

    public static class_5819 getRng() {
        return Builder.RANDOM;
    }

    public static final class Builder<T> {
        public static final class_5819 RANDOM = class_5819.method_43047();
        private float totalWeight = 0.0f;
        private final List<class_3545<WeightedValue<T>, Range>> entries = new ArrayList<class_3545<WeightedValue<T>, Range>>();

        public Builder<T> putAll(Map<Integer, T> map) {
            map.forEach(this::put);
            return this;
        }

        public Builder<T> put(int weight, @NotNull T value) {
            this.entries.add(new class_3545(new WeightedValue<T>(weight, value), (Object)new Range(this)));
            this.totalWeight += (float)weight;
            float rangeStart = 0.0f;
            for (class_3545<WeightedValue<T>, Range> i : this.entries) {
                rangeStart = ((Range)i.method_15441()).set(rangeStart, ((WeightedValue)i.method_15442()).weight() / this.totalWeight);
            }
            return this;
        }

        public Supplier<Optional<T>> build() {
            if (this.entries.isEmpty()) {
                return Weighted.of();
            }
            if (this.entries.size() == 1) {
                Optional val = Optional.ofNullable(((WeightedValue)this.entries.get(0).method_15442()).result());
                return () -> val;
            }
            ArrayList entries = new ArrayList(this.entries);
            return () -> {
                float pointer = RANDOM.method_43057();
                return entries.stream().filter(i -> ((Range)i.method_15441()).isIn(pointer)).map(i -> ((WeightedValue)i.method_15442()).result()).findFirst();
            };
        }

        private record WeightedValue<T>(float weight, T result) {
        }

        private final class Range {
            float min;
            float max;

            private Range(Builder builder) {
            }

            public boolean isIn(float pointer) {
                return pointer >= this.min && pointer <= this.max;
            }

            public float set(float start, float size) {
                this.min = start;
                this.max = start + size;
                return this.max;
            }
        }
    }

    public static interface Buildable<T> {
        public void appendTo(Builder<T> var1);
    }
}

