/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia;

import com.google.common.collect.Sets;
import com.minelittlepony.unicopia.UTags;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.entity.mob.AirBalloonEntity;
import com.minelittlepony.unicopia.entity.mob.UEntities;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7134;
import net.minecraft.class_7923;

public interface Debug {
    public static final boolean SPELLBOOK_CHAPTERS = Boolean.getBoolean("unicopia.debug.spellbookChapters");
    public static final boolean CHECK_GAME_VALUES = Boolean.getBoolean("unicopia.debug.checkGameValues");
    public static final boolean CHECK_TRAIT_COVERAGE = Boolean.getBoolean("unicopia.debug.checkTraitCoverage");
    public static final AtomicReference<class_1937> LAST_TESTED_WORLD = new AtomicReference<Object>(null);

    public static void runTests(class_1937 world) {
        if (!CHECK_GAME_VALUES || !world.method_40134().method_40225(class_7134.field_37666) || LAST_TESTED_WORLD.getAndSet(world) == world) {
            return;
        }
        if (CHECK_TRAIT_COVERAGE) {
            Debug.testTraitCoverage();
        }
        try {
            for (class_1690.class_1692 type : class_1690.class_1692.values()) {
                AirBalloonEntity balloon = (AirBalloonEntity)UEntities.AIR_BALLOON.method_5883(world);
                balloon.setBasketType(AirBalloonEntity.BasketType.of(type));
                balloon.asItem();
            }
        }
        catch (Throwable t) {
            throw new IllegalStateException("Tests failed", t);
        }
    }

    private static void testTraitCoverage() {
        class_7923.field_41178.method_29722().stream().collect(Collectors.toMap(entry -> ((class_5321)entry.getKey()).method_29177().method_12836(), Set::of, Sets::union)).forEach((namespace, entries) -> {
            List<String> unregistered = entries.stream().filter(entry -> !((class_1792)entry.getValue()).method_40131().method_40220(UTags.Items.HAS_NO_TRAITS) && SpellTraits.of((class_1792)entry.getValue()).isEmpty()).map(entry -> {
                String id = ((class_5321)entry.getKey()).method_29177().toString();
                return id + "(" + class_7923.field_41178.method_40273().filter(arg_0 -> ((class_6880.class_6883)((class_1792)entry.getValue()).method_40131()).method_40220(arg_0)).map(class_6862::comp_327).map(class_2960::toString).collect(Collectors.joining(", ")) + ")";
            }).toList();
            if (!unregistered.isEmpty()) {
                Unicopia.LOGGER.warn("No traits registered for {} items in namepsace {} {}", (Object)unregistered.size(), namespace, (Object)String.join((CharSequence)",\r\n", unregistered));
            }
        });
    }
}

