/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia;

import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.entity.Equine;
import com.minelittlepony.unicopia.entity.MagicImmune;
import com.minelittlepony.unicopia.item.enchantment.EnchantmentUtil;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1530;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1690;

public interface EquinePredicates {
    public static final Predicate<class_1297> IS_PLAYER = e -> e instanceof class_1657;
    public static final Predicate<class_1297> BAT = EquinePredicates.physicalRaceMatches(Race.BAT::equals);
    public static final Predicate<class_1297> CHANGELING = EquinePredicates.physicalRaceMatches(Race.CHANGELING::equals);
    public static final Predicate<class_1297> RACE_CAN_INFLUENCE_WEATHER = EquinePredicates.raceMatches(Race::canInfluenceWeather);
    public static final Predicate<class_1297> RAGING = IS_PLAYER.and(SpellType.RAGE::isOn);
    public static final Predicate<class_1297> PLAYER_EARTH = IS_PLAYER.and(EquinePredicates.ofRace(Race.EARTH));
    public static final Predicate<class_1297> PLAYER_BAT = IS_PLAYER.and(BAT);
    public static final Predicate<class_1297> PLAYER_UNICORN = IS_PLAYER.and(EquinePredicates.raceMatches(Race::canCast));
    public static final Predicate<class_1297> PLAYER_CHANGELING = IS_PLAYER.and(EquinePredicates.ofRace(Race.CHANGELING));
    public static final Predicate<class_1297> PLAYER_KIRIN = IS_PLAYER.and(EquinePredicates.ofRace(Race.KIRIN));
    public static final Predicate<class_1297> PLAYER_SEAPONY = IS_PLAYER.and(EquinePredicates.raceMatches(Race::isFish));
    public static final Predicate<class_1297> PLAYER_CAN_USE_EARTH = IS_PLAYER.and(EquinePredicates.raceMatches(Race::canUseEarth));
    public static final Predicate<class_1297> IS_CASTER = e -> !e.method_31481() && (e instanceof Caster || IS_PLAYER.test((class_1297)e));
    public static final Predicate<class_1297> IS_PLACED_SPELL = e -> e instanceof Caster && !e.method_31481();
    public static final Predicate<class_1297> IS_MAGIC_IMMUNE = class_1301.field_6154.negate().or(class_1301.field_6156.negate().or(e -> (e instanceof MagicImmune || !(e instanceof class_1309)) && !(e instanceof class_1542) && !(e instanceof class_1303) && !(e instanceof class_1690) && !(e instanceof class_1676)));
    public static final Predicate<class_1297> EXCEPT_MAGIC_IMMUNE = IS_MAGIC_IMMUNE.negate();
    public static final Predicate<class_1297> VALID_LIVING_AND_NOT_MAGIC_IMMUNE = class_1301.field_6157.and(EXCEPT_MAGIC_IMMUNE);
    public static final Predicate<class_1309> LIVING_HAS_WANT_IT_NEED_IT = e -> EnchantmentUtil.getWantItNeedItLevel(e) > 0;
    public static final Predicate<class_1297> VALID_FOR_DISGUISE = class_1301.field_6155.and(e -> !(e instanceof class_1538) && !(e instanceof class_1530));

    public static Predicate<class_1297> ofRace(Race race) {
        return EquinePredicates.raceMatches(race::equals);
    }

    public static Predicate<class_1297> raceMatches(Predicate<Race> predicate) {
        return e -> Equine.of(e).filter(pony -> pony.getCompositeRace().any(predicate)).isPresent();
    }

    public static Predicate<class_1297> physicalRaceMatches(Predicate<Race> predicate) {
        return e -> Equine.of(e).filter(pony -> predicate.test(pony.getCompositeRace().physical())).isPresent();
    }
}

