/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia;

import com.minelittlepony.unicopia.EquineContext;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.SyncedConfig;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.container.spellbook.SpellbookChapter;
import com.minelittlepony.unicopia.entity.mob.LevitatingItemEntity;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.entity.player.dummy.DummyPlayerEntity;
import com.minelittlepony.unicopia.particle.ParticleSpawner;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.Stack;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InteractionManager {
    public static final int SOUND_EARS_RINGING = 0;
    public static final int SOUND_CHANGELING_BUZZ = 1;
    public static final int SOUND_BEE = 2;
    public static final int SOUND_MINECART = 3;
    public static final int SOUND_GLIDING = 4;
    public static final int SOUND_MAGIC_BEAM = 5;
    public static final int SOUND_HEART_BEAT = 6;
    public static final int SOUND_KIRIN_RAGE = 7;
    public static final int SOUND_GEM_FINDING_MAGIC_HUM = 8;
    public static final int SCREEN_DISPELL_ABILITY = 0;
    private static InteractionManager INSTANCE = new InteractionManager();
    @Nullable
    private SyncedConfig config;
    private final Stack<EquineContext> equineContext = new Stack();

    public static InteractionManager getInstance() {
        return INSTANCE;
    }

    public InteractionManager() {
        INSTANCE = this;
    }

    public ParticleSpawner createBoundParticle(UUID id) {
        return ParticleSpawner.EMPTY;
    }

    public SpellbookChapter readChapter(class_2540 buf) {
        throw new RuntimeException("Method not supported");
    }

    public void playLoopingSound(class_1297 source, int type, long seed) {
    }

    public boolean isClientPlayer(@Nullable class_1657 player) {
        return false;
    }

    public int getViewMode() {
        return 0;
    }

    public float getTickRate() {
        return 20.0f;
    }

    public void openScreen(int type) {
    }

    @NotNull
    public final class_1657 createPlayer(class_1297 observer, GameProfile profile) {
        return this.createPlayer(observer.method_37908(), profile);
    }

    @NotNull
    public class_1657 createPlayer(class_1937 world, GameProfile profile) {
        return new DummyPlayerEntity(world, profile);
    }

    public void sendPlayerLookAngles(class_1657 player) {
    }

    public void addBlockBreakingParticles(class_2338 pos, class_2350 direction) {
    }

    public void interactLevitatingItem(LevitatingItemEntity entity, class_1657 player) {
        if (player != entity.getMaster()) {
            entity.handleAction(LevitatingItemEntity.Action.GRAB, player, Optional.empty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEquineContext(EquineContext context) {
        Stack<EquineContext> stack = this.equineContext;
        synchronized (stack) {
            this.equineContext.push(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearEquineContext() {
        Stack<EquineContext> stack = this.equineContext;
        synchronized (stack) {
            if (!this.equineContext.isEmpty()) {
                this.equineContext.pop();
            }
        }
    }

    public EquineContext getEquineContext() {
        return this.getClientPony().map(EquineContext.class::cast).orElseGet(this::getPathingEquineContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EquineContext getPathingEquineContext() {
        Stack<EquineContext> stack = this.equineContext;
        synchronized (stack) {
            return this.equineContext.isEmpty() ? EquineContext.ABSENT : this.equineContext.peek();
        }
    }

    public Optional<Pony> getClientPony() {
        return Optional.empty();
    }

    public final Race getClientSpecies() {
        return this.getClientPony().map(Pony::getSpecies).orElse(Race.HUMAN);
    }

    public void setSyncedConfig(SyncedConfig config) {
        this.config = config;
    }

    public SyncedConfig getSyncedConfig() {
        if (this.config == null) {
            this.config = Unicopia.getConfig().toSynced();
        }
        return this.config;
    }
}

