/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia;

import com.google.common.base.Strings;
import com.minelittlepony.unicopia.Affinity;
import com.minelittlepony.unicopia.AllowList;
import com.minelittlepony.unicopia.Availability;
import com.minelittlepony.unicopia.FlightType;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.Abilities;
import com.minelittlepony.unicopia.ability.Ability;
import com.minelittlepony.unicopia.ability.magic.Affine;
import com.minelittlepony.unicopia.util.RegistryUtils;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7079;
import org.jetbrains.annotations.Nullable;

public record Race(List<Ability<?>> abilities, Affinity affinity, Availability availability, FlightType flightType, boolean canCast, boolean hasIronGut, boolean canUseEarth, boolean isNocturnal, boolean canHang, boolean isFish, boolean canInfluenceWeather, boolean canInteractWithClouds) implements Affine
{
    public static final String DEFAULT_ID = "unicopia:unset";
    public static final class_2378<Race> REGISTRY = RegistryUtils.createSynced(Unicopia.id("race"), "unicopia:unset");
    public static final class_2378<Race> COMMAND_REGISTRY = RegistryUtils.createSynced(Unicopia.id("race/grantable"), "unicopia:unset");
    public static final class_5321<? extends class_2378<Race>> REGISTRY_KEY = REGISTRY.method_30517();
    private static final DynamicCommandExceptionType UNKNOWN_RACE_EXCEPTION = new DynamicCommandExceptionType(id -> class_2561.method_43469((String)"commands.race.fail", (Object[])new Object[]{id}));
    private static final Function<Race, Composite> COMPOSITES = class_156.method_34866(race -> new Composite((Race)race, null, null));
    public static final Codec<Race> CODEC = RecordCodecBuilder.create(i -> i.group((App)Abilities.REGISTRY.method_39673().listOf().fieldOf("abilities").forGetter(Race::abilities), (App)Affinity.CODEC.fieldOf("affinity").forGetter(Race::affinity), (App)Availability.CODEC.fieldOf("availability").forGetter(Race::availability), (App)FlightType.CODEC.fieldOf("flight").forGetter(Race::flightType), (App)Codec.BOOL.fieldOf("magic").forGetter(Race::canCast), (App)Codec.BOOL.fieldOf("can_forage").forGetter(Race::hasIronGut), (App)Codec.BOOL.fieldOf("earth_pony_strength").forGetter(Race::canUseEarth), (App)Codec.BOOL.fieldOf("nocturnal").forGetter(Race::isNocturnal), (App)Codec.BOOL.fieldOf("hanging").forGetter(Race::canHang), (App)Codec.BOOL.fieldOf("aquatic").forGetter(Race::isFish), (App)Codec.BOOL.fieldOf("weather_magic").forGetter(Race::canInfluenceWeather), (App)Codec.BOOL.fieldOf("cloud_magic").forGetter(Race::canInteractWithClouds)).apply((Applicative)i, Race::new));
    public static final Race UNSET = Race.register("unset", new Builder().availability(Availability.COMMANDS));
    public static final Race HUMAN = Race.register("human", new Builder());
    public static final Race EARTH = Race.register("earth", new Builder().foraging().earth().abilities(Abilities.HUG, Abilities.STOMP, Abilities.KICK, Abilities.GROW));
    public static final Race UNICORN = Race.register("unicorn", new Builder().foraging().magic().abilities(Abilities.TELEPORT, Abilities.CAST, Abilities.GROUP_TELEPORT, Abilities.SHOOT, Abilities.DISPELL, Abilities.TELEKINESIS));
    public static final Race PEGASUS = Race.register("pegasus", new Builder().foraging().flight(FlightType.AVIAN).weatherMagic().cloudMagic().abilities(Abilities.TOGGLE_FLIGHT, Abilities.RAINBOOM, Abilities.CAPTURE_CLOUD, Abilities.CARRY));
    public static final Race BAT = Race.register("bat", new Builder().foraging().flight(FlightType.AVIAN).canHang().cloudMagic().nocturnal().abilities(Abilities.TOGGLE_FLIGHT, Abilities.CARRY, Abilities.HANG, Abilities.EEEE));
    public static final Race ALICORN = Race.register("alicorn", new Builder().foraging().availability(Availability.COMMANDS).flight(FlightType.AVIAN).earth().magic().weatherMagic().cloudMagic().abilities(Abilities.TELEPORT, Abilities.GROUP_TELEPORT, Abilities.CAST, Abilities.SHOOT, Abilities.DISPELL, Abilities.TELEKINESIS, Abilities.TOGGLE_FLIGHT, Abilities.RAINBOOM, Abilities.CAPTURE_CLOUD, Abilities.CARRY, Abilities.HUG, Abilities.STOMP, Abilities.KICK, Abilities.GROW, Abilities.TIME));
    public static final Race CHANGELING = Race.register("changeling", new Builder().foraging().affinity(Affinity.BAD).flight(FlightType.INSECTOID).canHang().abilities(Abilities.DISPELL, Abilities.TOGGLE_FLIGHT, Abilities.FEED, Abilities.DISGUISE, Abilities.CARRY, Abilities.TELEKINESIS));
    public static final Race KIRIN = Race.register("kirin", new Builder().foraging().magic().abilities(Abilities.DISPELL, Abilities.RAGE, Abilities.NIRIK_BLAST, Abilities.KIRIN_CAST, Abilities.TELEKINESIS));
    public static final Race HIPPOGRIFF = Race.register("hippogriff", new Builder().foraging().flight(FlightType.AVIAN).cloudMagic().abilities(Abilities.TOGGLE_FLIGHT, Abilities.SCREECH, Abilities.PECK, Abilities.DASH, Abilities.CARRY));
    public static final Race SEAPONY = Race.register("seapony", new Builder().availability(Availability.COMMANDS).foraging().fish().abilities(Abilities.SONAR_PULSE));

    public static void bootstrap() {
    }

    public Composite composite() {
        return COMPOSITES.apply(this);
    }

    public Composite composite(@Nullable Race pseudo, @Nullable Race potential) {
        return pseudo == null && potential == null ? this.composite() : new Composite(this, pseudo, potential);
    }

    @Override
    public Affinity getAffinity() {
        return this.affinity;
    }

    public boolean isUnset() {
        return this == UNSET;
    }

    public boolean isEquine() {
        return !this.isHuman();
    }

    public boolean isHuman() {
        return this.isUnset() || this == HUMAN;
    }

    public boolean isDayurnal() {
        return !this.isNocturnal();
    }

    public boolean canFly() {
        return !this.flightType().isGrounded();
    }

    public boolean hasPersistentWeatherMagic() {
        return this.canInfluenceWeather();
    }

    public boolean canUse(Ability<?> ability) {
        return this.abilities.contains(ability);
    }

    public class_2960 getId() {
        return REGISTRY.method_10221((Object)this);
    }

    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)this.getTranslationKey());
    }

    public class_2561 getAltDisplayName() {
        return class_2561.method_43471((String)(this.getTranslationKey() + ".alt"));
    }

    public String getTranslationKey() {
        return class_156.method_646((String)"race", (class_2960)this.getId());
    }

    public class_2960 getIcon() {
        return this.getId().method_45134(p -> "textures/gui/race/" + p + ".png");
    }

    public boolean isPermitted(@Nullable class_1657 sender) {
        return AllowList.INSTANCE.permits(this);
    }

    public Race validate(class_1657 sender) {
        if (!this.isPermitted(sender)) {
            Race alternative;
            Race race = alternative = this == EARTH ? HUMAN : EARTH.validate(sender);
            if (alternative != this && sender instanceof class_3222) {
                class_3222 spe = (class_3222)sender;
                spe.method_43502((class_2561)class_2561.method_43469((String)"respawn.reason.illegal_race", (Object[])new Object[]{this.getDisplayName()}), false);
            }
            return alternative;
        }
        return this;
    }

    public Race or(Race other) {
        return this.isEquine() ? this : other;
    }

    @Override
    public String toString() {
        return "Race{ " + this.getId().toString() + " }";
    }

    public boolean equals(String s) {
        return this.getId().toString().equalsIgnoreCase(s) || this.getTranslationKey().equalsIgnoreCase(s);
    }

    public static Race fromName(String s, Race def) {
        class_2960 id;
        if (!Strings.isNullOrEmpty((String)s) && (id = class_2960.method_12829((String)s)) != null) {
            if (id.method_12836() == "minecraft") {
                id = Unicopia.id(id.method_12832());
            }
            return REGISTRY.method_17966(id).orElse(def);
        }
        return def;
    }

    public static Race register(String name, Builder builder) {
        return Race.register(Unicopia.id(name), builder);
    }

    public static Race register(class_2960 id, Builder builder) {
        Race race = (Race)class_2378.method_10230(REGISTRY, (class_2960)id, (Object)builder.build());
        if (race.availability().isGrantable()) {
            class_2378.method_10230(COMMAND_REGISTRY, (class_2960)id, (Object)race);
        }
        return race;
    }

    public static class_7079<Race> argument() {
        return class_7079.method_41224((class_5321)COMMAND_REGISTRY.method_30517());
    }

    public static Race fromArgument(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        class_2960 id;
        class_2960 idf = id = ((class_5321)context.getArgument(name, class_5321.class)).method_29177();
        if (id.method_12836() == "minecraft" && !REGISTRY.method_10250(id)) {
            id = REGISTRY_KEY.method_29177().method_45136(id.method_12832());
        }
        return (Race)REGISTRY.method_17966(id).orElseThrow(() -> UNKNOWN_RACE_EXCEPTION.create((Object)idf));
    }

    public static Set<Race> allPermitted(class_1657 player) {
        return REGISTRY.method_10220().filter(r -> r.isPermitted(player)).collect(Collectors.toSet());
    }

    public record Composite(Race physical, @Nullable Race pseudo, @Nullable Race potential) {
        public Race collapsed() {
            return this.pseudo == null ? this.physical : this.pseudo;
        }

        public boolean includes(Race race) {
            return this.physical == race || this.pseudo == race;
        }

        public boolean any(Predicate<Race> test) {
            return test.test(this.physical) || this.pseudo != null && test.test(this.pseudo);
        }

        public boolean canUseEarth() {
            return this.any(Race::canUseEarth);
        }

        public boolean canFly() {
            return this.any(Race::canFly);
        }

        public boolean canCast() {
            return this.any(Race::canCast);
        }

        public boolean canUse(Ability<?> ability) {
            return this.any(r -> r.canUse(ability));
        }

        public boolean canInteractWithClouds() {
            return this.any(Race::canInteractWithClouds);
        }

        public boolean canInfluenceWeather() {
            return this.any(Race::canInfluenceWeather);
        }

        public boolean hasPersistentWeatherMagic() {
            return this.any(Race::hasPersistentWeatherMagic);
        }

        public FlightType flightType() {
            if (this.pseudo() == null) {
                return this.physical().flightType();
            }
            return this.physical().flightType().or(this.pseudo().flightType());
        }
    }

    public static final class Builder {
        private final List<Ability<?>> abilities = new ArrayList();
        private Affinity affinity = Affinity.NEUTRAL;
        private Availability availability = Availability.DEFAULT;
        private boolean canCast;
        private boolean hasIronGut;
        private FlightType flightType = FlightType.NONE;
        private boolean canUseEarth;
        private boolean isNocturnal;
        private boolean canHang;
        private boolean isFish;
        private boolean canInfluenceWeather;
        private boolean canInteractWithClouds;

        public Builder abilities(Ability<?> ... abilities) {
            this.abilities.addAll(List.of(abilities));
            return this;
        }

        public Builder foraging() {
            this.hasIronGut = true;
            return this;
        }

        public Builder affinity(Affinity affinity) {
            this.affinity = affinity;
            return this;
        }

        public Builder availability(Availability availability) {
            this.availability = availability;
            return this;
        }

        public Builder flight(FlightType flight) {
            this.flightType = flight;
            return this;
        }

        public Builder magic() {
            this.canCast = true;
            return this;
        }

        public Builder earth() {
            this.canUseEarth = true;
            return this;
        }

        public Builder nocturnal() {
            this.isNocturnal = true;
            return this;
        }

        public Builder canHang() {
            this.canHang = true;
            return this;
        }

        public Builder fish() {
            this.isFish = true;
            return this;
        }

        public Builder weatherMagic() {
            this.canInfluenceWeather = true;
            return this;
        }

        public Builder cloudMagic() {
            this.canInteractWithClouds = true;
            return this;
        }

        public Race build() {
            return new Race(List.copyOf(this.abilities), this.affinity, this.availability, this.flightType, this.canCast, this.hasIronGut, this.canUseEarth, this.isNocturnal, this.canHang, this.isFish, this.canInfluenceWeather, this.canInteractWithClouds);
        }
    }
}

