/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability;

import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.Ability;
import com.minelittlepony.unicopia.ability.AbilitySlot;
import com.minelittlepony.unicopia.ability.data.Hit;
import com.minelittlepony.unicopia.advancement.UCriteria;
import com.minelittlepony.unicopia.compat.trinkets.TrinketsDelegate;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.AmuletItem;
import com.minelittlepony.unicopia.item.FriendshipBraceletItem;
import com.minelittlepony.unicopia.item.UItems;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1935;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class ChangeFormAbility
implements Ability<Hit> {
    @Override
    public int getWarmupTime(Pony player) {
        return 10;
    }

    @Override
    public int getCooldownTime(Pony player) {
        return 1000;
    }

    @Override
    public boolean canUse(Race.Composite race) {
        return race.potential() != null && race.potential() != race.physical();
    }

    @Override
    public boolean canUse(Race race) {
        return true;
    }

    @Override
    public class_2960 getIcon(Pony player) {
        Race potential = player.getCompositeRace().potential();
        if (potential == null) {
            return Ability.super.getIcon(player);
        }
        return this.getId().method_45134(p -> "textures/gui/ability/" + p + "_" + potential.getId().method_12832() + ".png");
    }

    @Override
    @Nullable
    public Optional<Hit> prepare(Pony player) {
        return Hit.of(this.canUse(player.getCompositeRace()));
    }

    @Override
    public class_9139<? super class_9129, Hit> getSerializer() {
        return Hit.CODEC;
    }

    @Override
    public double getCostEstimate(Pony player) {
        return 5.0;
    }

    @Override
    public boolean apply(Pony player, Hit data) {
        if (this.prepare(player).isEmpty()) {
            return false;
        }
        List<Pony> targets = this.getTargets(player).toList();
        player.subtractEnergyCost(5 * targets.size());
        TrinketsDelegate.EquippedStack amulet = AmuletItem.getForEntity(player.asEntity(), (class_1935)UItems.PEARL_NECKLACE);
        if (!amulet.stack().method_7960()) {
            amulet.stack().method_7956(1, (class_3218)player.asWorld(), (class_3222)player.asEntity(), amulet.breakStatusSender());
        }
        boolean isTransforming = player.getSuppressedRace().isUnset();
        targets.forEach(target -> {
            Race supressed = target.getSuppressedRace();
            if (target == player || supressed.isUnset() == isTransforming) {
                Race actualRace = isTransforming ? target.getPersistentSpecies() : Race.UNSET;
                target.setSpecies(supressed.or(player.getCompositeRace().potential()));
                target.setSuppressedRace(actualRace);
                UCriteria.SEAPONY_TRANSITION.trigger((class_1297)target.asEntity());
            }
        });
        return true;
    }

    @Override
    public void warmUp(Pony player, AbilitySlot slot) {
        player.getMagicalReserves().getExertion().addPercent(6.0f);
        this.getTargets(player).forEach(target -> {
            if (player.getAbilities().getStat(slot).getWarmup() % 5.0f == 0.0f) {
                player.asWorld().method_45447((class_1657)target.asEntity(), target.getOrigin(), class_3417.field_19196, class_3419.field_15248);
            }
            if (player.asWorld().field_9229.method_43048(5) == 0) {
                player.asWorld().method_45447((class_1657)target.asEntity(), target.getOrigin(), USounds.Vanilla.field_15065, class_3419.field_15248);
            }
            target.spawnParticles((class_2394)class_2398.field_11238, 15);
            target.spawnParticles((class_2394)class_2398.field_11241, 15);
        });
    }

    @Override
    public void coolDown(Pony player, AbilitySlot slot) {
    }

    private Stream<Pony> getTargets(Pony player) {
        return Stream.concat(Stream.of(player), FriendshipBraceletItem.getPartyMembers(player, 3.0));
    }
}

