/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.UTags;
import com.minelittlepony.unicopia.ability.Ability;
import com.minelittlepony.unicopia.ability.AbilitySlot;
import com.minelittlepony.unicopia.ability.data.Pos;
import com.minelittlepony.unicopia.block.UBlocks;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.particle.MagicParticleEffect;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.recipe.TransformCropsRecipe;
import com.minelittlepony.unicopia.recipe.URecipes;
import com.minelittlepony.unicopia.server.world.BlockDestructionManager;
import com.minelittlepony.unicopia.server.world.ModificationType;
import com.minelittlepony.unicopia.util.TraceHelper;
import com.minelittlepony.unicopia.util.VecHelper;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1752;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2271;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9695;

public class EarthPonyGrowAbility
implements Ability<Pos> {
    @Override
    public int getWarmupTime(Pony player) {
        return 10;
    }

    @Override
    public int getCooldownTime(Pony player) {
        return 50;
    }

    @Override
    public Optional<Pos> prepare(Pony player) {
        return TraceHelper.findBlock(player.asEntity(), 3.0, 1.0f).map(Pos::new);
    }

    @Override
    public class_9139<? super class_9129, Pos> getSerializer() {
        return Pos.CODEC;
    }

    @Override
    public double getCostEstimate(Pony player) {
        return 10.0;
    }

    @Override
    public boolean apply(Pony player, Pos data) {
        int count = 0;
        if (!this.applyDirectly(player, data.pos())) {
            for (class_2338 pos : class_2338.method_10097((class_2338)data.pos().method_10069(-2, -2, -2), (class_2338)data.pos().method_10069(2, 2, 2))) {
                if (!player.canModifyAt(pos, ModificationType.PHYSICAL)) continue;
                count += this.applySingle(player, player.asWorld(), player.asWorld().method_8320(pos), pos);
            }
        } else {
            count = 1;
        }
        if (count > 0) {
            player.subtractEnergyCost((double)count / 5.0);
        }
        return true;
    }

    protected int applySingle(Pony player, class_1937 w, class_2680 state, class_2338 pos) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8324);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof Growable) {
            Growable growable = (Growable)class_22482;
            return growable.grow(w, state, pos) ? 1 : 0;
        }
        if (state.method_27852(class_2246.field_10609) && (Integer)state.method_11654((class_2769)class_2271.field_10835) == 7) {
            boolean transform = w.field_9229.method_43048(3) == 0;
            EarthPonyGrowAbility.spawnConversionParticles(w, pos, transform);
            if (transform) {
                w.method_8501(pos, (class_2680)UBlocks.GOLD_ROOT.method_9564().method_11657((class_2769)class_2271.field_10835, (Comparable)Integer.valueOf(7)));
            }
            return 5;
        }
        if (w.method_8320(pos).method_26164(UTags.Blocks.UNAFFECTED_BY_GROW_ABILITY)) {
            return 0;
        }
        if (class_1752.method_7720((class_1799)stack, (class_1937)w, (class_2338)pos)) {
            if (w.field_9229.method_43048(350) == 0) {
                if (w.method_8320(pos.method_10074()).method_27852(class_2246.field_10362)) {
                    class_2344.method_10125(null, (class_2680)state, (class_1937)w, (class_2338)pos.method_10074());
                }
                w.method_8501(pos, UBlocks.PLUNDER_VINE_BUD.method_9564());
            } else if (w.field_9229.method_43048(5000) == 0) {
                if (w.method_8320(pos.method_10074()).method_27852(class_2246.field_10362)) {
                    class_2344.method_10125(null, (class_2680)state, (class_1937)w, (class_2338)pos.method_10074());
                }
                UBlocks.CURING_JOKE.grow(w, state, pos);
            }
            return 1;
        }
        if (class_1752.method_7719((class_1799)stack, (class_1937)w, (class_2338)pos, (class_2350)class_2350.field_11036)) {
            return 1;
        }
        return 0;
    }

    private boolean applyDirectly(Pony player, class_2338 pos) {
        return player.asWorld().method_8433().method_17877(URecipes.GROWING, (class_9695)new TransformCropsRecipe.PlacementArea(player, pos), player.asWorld()).stream().map(recipe -> ((TransformCropsRecipe)recipe.comp_1933()).checkPattern(player.asWorld(), pos)).filter(result -> result.matchedLocations().size() + 1 >= 9).filter(result -> {
            boolean transform = result.shoudTransform(player.asWorld().field_9229);
            player.playSound(USounds.ENTITY_CRYSTAL_SHARDS_AMBIENT, 1.0f);
            result.matchedLocations().forEach(cell -> {
                EarthPonyGrowAbility.spawnConversionParticles(player.asWorld(), cell.method_10084(), false);
                BlockDestructionManager manager = BlockDestructionManager.of(player.asWorld());
                if (transform) {
                    if (manager.damageBlock((class_2338)cell, 8.0f) >= 10.0f || player.asWorld().field_9229.method_43048(20) == 0) {
                        player.asWorld().method_8501(cell, class_2246.field_10566.method_9564());
                        player.asWorld().method_20290(2001, cell, class_2248.method_9507((class_2680)player.asWorld().method_8320(cell)));
                    }
                } else if (manager.damageBlock((class_2338)cell, 4.0f) >= 10.0f || player.asWorld().field_9229.method_43048(20) == 0) {
                    player.asWorld().method_8501(cell, class_2246.field_10566.method_9564());
                    player.asWorld().method_20290(2001, cell, class_2248.method_9507((class_2680)player.asWorld().method_8320(cell)));
                }
            });
            EarthPonyGrowAbility.spawnConversionParticles(player.asWorld(), pos, transform);
            if (transform) {
                player.asWorld().method_8501(pos, result.recipe().getResult(player.asWorld(), pos));
            }
            return true;
        }).findFirst().isPresent();
    }

    private static void spawnConversionParticles(class_1937 w, class_2338 pos, boolean success) {
        Supplier<class_243> posSupplier = () -> pos.method_46558().method_1019(VecHelper.triangular(w.field_9229, 0.0, 0.5));
        for (int i = 0; i < 25; ++i) {
            ParticleUtils.spawnParticle(w, new MagicParticleEffect(0xFFFF00), posSupplier.get(), class_243.field_1353);
            if (!success) continue;
            ParticleUtils.spawnParticle(w, (class_2394)class_2398.field_11204, posSupplier.get(), class_243.field_1353);
        }
    }

    @Override
    public void warmUp(Pony player, AbilitySlot slot) {
        player.getMagicalReserves().getExertion().addPercent(30.0f);
        if (player.asWorld().method_8608()) {
            player.spawnParticles(MagicParticleEffect.UNICORN, 1);
        }
    }

    @Override
    public void coolDown(Pony player, AbilitySlot slot) {
    }

    public static interface Growable {
        public boolean grow(class_1937 var1, class_2680 var2, class_2338 var3);
    }
}

