/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability;

import com.minelittlepony.unicopia.ability.Ability;
import com.minelittlepony.unicopia.ability.AbilitySlot;
import com.minelittlepony.unicopia.ability.ActivationType;
import com.minelittlepony.unicopia.ability.data.Hit;
import com.minelittlepony.unicopia.entity.player.Pony;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class FlyingDashAbility
implements Ability<Hit> {
    @Override
    public int getWarmupTime(Pony player) {
        return 19;
    }

    @Override
    public int getCooldownTime(Pony player) {
        return 30;
    }

    @Override
    @Nullable
    public Optional<Hit> prepare(Pony player) {
        return Hit.of(player.getPhysics().isFlying());
    }

    @Override
    public class_9139<? super class_9129, Hit> getSerializer() {
        return Hit.CODEC;
    }

    @Override
    public double getCostEstimate(Pony player) {
        return 0.0;
    }

    @Override
    public boolean onQuickAction(Pony player, ActivationType type, Optional<Hit> data) {
        if (type == ActivationType.TAP && !player.getMotion().isRainbooming() && player.getPhysics().isFlying() && player.getMagicalReserves().getMana().get() > 40.0f) {
            player.getPhysics().dashForward((float)player.asWorld().field_9229.method_43385(2.5, (double)0.3f));
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsQuickAction(Pony player, ActivationType type) {
        return type == ActivationType.NONE || type == ActivationType.TAP;
    }

    @Override
    public boolean apply(Pony player, Hit data) {
        player.getPhysics().dashForward((float)player.asWorld().field_9229.method_43385(2.5, (double)0.3f));
        player.subtractEnergyCost(2.0);
        return true;
    }

    @Override
    public void warmUp(Pony player, AbilitySlot slot) {
        player.getMagicalReserves().getExertion().addPercent(6.0f);
    }

    @Override
    public void coolDown(Pony player, AbilitySlot slot) {
        float velocityScale = player.getAbilities().getStat(slot).getCooldown();
        float multiplier = 1.0f + 0.02f * velocityScale;
        ((class_1657)player.asEntity()).method_18798().method_18805((double)multiplier, 1.0, (double)multiplier);
    }
}

