/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability;

import com.minelittlepony.unicopia.ability.Ability;
import com.minelittlepony.unicopia.ability.AbilitySlot;
import com.minelittlepony.unicopia.ability.ActivationType;
import com.minelittlepony.unicopia.ability.data.Hit;
import com.minelittlepony.unicopia.ability.magic.spell.CastingMethod;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.particle.MagicParticleEffect;
import java.util.Optional;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class PegasusRainboomAbility
implements Ability<Hit> {
    @Override
    public int getWarmupTime(Pony player) {
        return 59;
    }

    @Override
    public int getCooldownTime(Pony player) {
        return 60;
    }

    @Override
    @Nullable
    public Optional<Hit> prepare(Pony player) {
        return Hit.of(player.canUseSuperMove() && player.getPhysics().isFlying() && !player.getMotion().isRainbooming());
    }

    @Override
    public class_9139<? super class_9129, Hit> getSerializer() {
        return Hit.CODEC;
    }

    @Override
    public double getCostEstimate(Pony player) {
        return 0.0;
    }

    @Override
    public boolean onQuickAction(Pony player, ActivationType type, Optional<Hit> data) {
        if (type == ActivationType.TAP && !player.getMotion().isRainbooming() && player.getPhysics().isFlying() && player.getMagicalReserves().getMana().get() > 40.0f) {
            player.getPhysics().dashForward((float)player.asWorld().field_9229.method_43385(2.5, (double)0.3f));
            player.subtractEnergyCost(4.0);
            player.getMagicalReserves().getCharge().add(2.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsQuickAction(Pony player, ActivationType type) {
        return type == ActivationType.NONE || type == ActivationType.TAP;
    }

    @Override
    public boolean apply(Pony player, Hit data) {
        if (this.prepare(player).isEmpty()) {
            return false;
        }
        if (player.consumeSuperMove()) {
            SpellType.RAINBOOM.withTraits().apply(player, CastingMethod.INNATE);
        }
        return true;
    }

    @Override
    public void warmUp(Pony player, AbilitySlot slot) {
        player.getMagicalReserves().getExertion().addPercent(6.0f);
    }

    @Override
    public void coolDown(Pony player, AbilitySlot slot) {
        player.spawnParticles(MagicParticleEffect.UNICORN, 5);
    }
}

