/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability;

import com.minelittlepony.unicopia.AwaitTickQueue;
import com.minelittlepony.unicopia.UPOIs;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.Ability;
import com.minelittlepony.unicopia.ability.AbilitySlot;
import com.minelittlepony.unicopia.ability.data.Hit;
import com.minelittlepony.unicopia.client.render.PlayerPoser;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.particle.UParticles;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_4153;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class SeaponySonarPulseAbility
implements Ability<Hit> {
    @Override
    public int getWarmupTime(Pony player) {
        return 10;
    }

    @Override
    public int getCooldownTime(Pony player) {
        return 100;
    }

    @Override
    @Nullable
    public Optional<Hit> prepare(Pony player) {
        return Hit.INSTANCE;
    }

    @Override
    public class_9139<? super class_9129, Hit> getSerializer() {
        return Hit.CODEC;
    }

    @Override
    public double getCostEstimate(Pony player) {
        return 5.0;
    }

    @Override
    public boolean apply(Pony player, Hit data) {
        player.setAnimation(PlayerPoser.Animation.ARMS_UP, PlayerPoser.Animation.Recipient.ANYONE);
        for (class_1297 target : player.findAllEntitiesInRange(64.0, e -> e instanceof class_1309 && (e instanceof class_1588 || SeaponySonarPulseAbility.isWaterCreature(((class_1309)e).method_5864().method_5891())) && e.method_5869()).sorted(Comparator.comparing(e -> Float.valueOf(e.method_5739(player.asEntity())))).toList()) {
            class_243 offset = target.method_19538().method_1020(player.getOriginVector());
            float distance = target.method_5739(player.asEntity());
            if (distance < 4.0f) {
                float scale = 1.0f - distance / 10.0f;
                ((class_1309)target).method_6005(0.7 * (double)scale, -offset.field_1352, -offset.field_1350);
                target.method_5643(target.method_48923().method_48821(player.asEntity()), 10.0f * scale);
                continue;
            }
            this.emitPing(player, target.method_19538(), 10, 1.0f, 1.3f);
        }
        player.subtractEnergyCost(5.0);
        class_1937 class_19372 = player.asWorld();
        if (class_19372 instanceof class_3218) {
            class_3218 sw = (class_3218)class_19372;
            sw.method_19494().method_34712(UPOIs::isChest, pos -> player.asWorld().method_8316(pos).method_15767(class_3486.field_15517) && player.asWorld().method_8320(pos).method_26204() instanceof class_2281, player.getOrigin(), 64, class_4153.class_4155.field_18489).ifPresent(chestPos -> this.emitPing(player, chestPos.method_46558(), 20, 0.5f, 2.0f));
        }
        player.playSound(USounds.ENTITY_PLAYER_SEAPONY_SONAR, 1.0f);
        player.spawnParticles((class_2394)UParticles.SHOCKWAVE, 1);
        ((class_1657)player.asEntity()).method_32876((class_6880)class_5712.field_39415);
        return true;
    }

    private void emitPing(Pony player, class_243 pos, int delay, float volume, float pitch) {
        AwaitTickQueue.scheduleTask(player.asWorld(), w -> {
            ParticleUtils.spawnParticle(w, (class_2394)UParticles.SHOCKWAVE, pos, class_243.field_1353);
            float loudness = Math.max(0.0f, 1.4f - (float)Math.log10(player.getOriginVector().method_1022(pos)));
            w.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, USounds.ENTITY_PLAYER_SEAPONY_SONAR, class_3419.field_15256, volume * loudness, pitch);
            w.method_43275(player.asEntity(), (class_6880)class_5712.field_39415, pos);
        }, delay + (int)player.getOriginVector().method_1022(pos));
    }

    @Override
    public void warmUp(Pony player, AbilitySlot slot) {
        player.getMagicalReserves().getExertion().addPercent(6.0f);
    }

    @Override
    public void coolDown(Pony player, AbilitySlot slot) {
    }

    private static boolean isWaterCreature(class_1311 group) {
        return switch (group) {
            case class_1311.field_34447, class_1311.field_30092, class_1311.field_6300, class_1311.field_24460 -> true;
            default -> false;
        };
    }
}

