/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability;

import com.minelittlepony.unicopia.EntityConvertable;
import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.InteractionManager;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.ability.Abilities;
import com.minelittlepony.unicopia.ability.Ability;
import com.minelittlepony.unicopia.ability.AbilitySlot;
import com.minelittlepony.unicopia.ability.ActivationType;
import com.minelittlepony.unicopia.ability.data.Pos;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.client.render.PlayerPoser;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.particle.MagicParticleEffect;
import com.minelittlepony.unicopia.util.TraceHelper;
import com.minelittlepony.unicopia.util.VecHelper;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1924;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class UnicornDispellAbility
implements Ability<Pos> {
    @Override
    public int getWarmupTime(Pony player) {
        return 4;
    }

    @Override
    public int getCooldownTime(Pony player) {
        return 0;
    }

    @Override
    public int getColor(Pony player) {
        return SpellType.PORTAL.getColor();
    }

    @Override
    public class_2960 getIcon(Pony player) {
        return Abilities.REGISTRY.method_10221((Object)this).method_45134(p -> "textures/gui/ability/" + p + (player.getSpecies() == Race.CHANGELING ? "_changeling" : "") + ".png");
    }

    @Override
    public class_9139<? super class_9129, Pos> getSerializer() {
        return Pos.CODEC;
    }

    @Override
    public boolean onQuickAction(Pony player, ActivationType type, Optional<Pos> data) {
        if (player.getSpecies() != Race.CHANGELING) {
            if (type.getTapCount() > 1) {
                player.setAnimation(PlayerPoser.Animation.WOLOLO, PlayerPoser.Animation.Recipient.ANYONE, 10);
                if (player.getSpellSlot().clear()) {
                    ((class_1657)player.asEntity()).method_7353((class_2561)class_2561.method_43471((String)"gui.unicopia.action.spells_cleared"), true);
                } else {
                    ((class_1657)player.asEntity()).method_7353((class_2561)class_2561.method_43471((String)"gui.unicopia.action.no_spells_cleared"), true);
                }
                return true;
            }
            if (type == ActivationType.TAP && player.isClient()) {
                InteractionManager.getInstance().openScreen(0);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean acceptsQuickAction(Pony player, ActivationType type) {
        return type == ActivationType.NONE || player.getSpecies() != Race.CHANGELING && type == ActivationType.TAP;
    }

    @Override
    public double getCostEstimate(Pony player) {
        return this.getTarget(player).filter(caster -> !caster.hasCommonOwner(player)).isPresent() ? 10.0 : 0.0;
    }

    @Override
    public Optional<Pos> prepare(Pony player) {
        return this.getTarget(player).map(EntityConvertable::getOrigin).map(Pos::new);
    }

    @Override
    public boolean apply(Pony player, Pos data) {
        player.setAnimation(PlayerPoser.Animation.WOLOLO, PlayerPoser.Animation.Recipient.ANYONE);
        Caster.stream(VecHelper.findInRange(player.asEntity(), (class_1924)player.asWorld(), data.vec(), 3.0, EquinePredicates.IS_PLACED_SPELL).stream()).forEach(target -> target.getSpellSlot().clear(false));
        return true;
    }

    private Optional<Caster<?>> getTarget(Pony player) {
        int maxDistance = ((class_1657)player.asEntity()).method_7337() ? 1000 : 100;
        return TraceHelper.findEntity(player.asEntity(), maxDistance, 1.0f, EquinePredicates.IS_PLACED_SPELL).flatMap(Caster::of);
    }

    @Override
    public void warmUp(Pony player, AbilitySlot slot) {
        player.getMagicalReserves().getExhaustion().multiply(3.3f);
        player.spawnParticles(MagicParticleEffect.UNICORN, 5);
    }

    @Override
    public void coolDown(Pony player, AbilitySlot slot) {
    }
}

