/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability;

import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.ability.AbilitySlot;
import com.minelittlepony.unicopia.ability.AbstractSpellCastingAbility;
import com.minelittlepony.unicopia.ability.ActivationType;
import com.minelittlepony.unicopia.ability.data.Hit;
import com.minelittlepony.unicopia.ability.magic.spell.HomingSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.client.render.PlayerPoser;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.particle.MagicParticleEffect;
import com.minelittlepony.unicopia.util.TraceHelper;
import java.util.Optional;
import net.minecraft.class_1269;
import net.minecraft.class_1271;

public class UnicornProjectileAbility
extends AbstractSpellCastingAbility {
    @Override
    public int getWarmupTime(Pony player) {
        return 1;
    }

    @Override
    public Optional<Hit> prepare(Pony player) {
        return Hit.of(player.getCharms().getSpellInHand(false).method_5467() != class_1269.field_5814);
    }

    @Override
    public double getCostEstimate(Pony player) {
        return 7.0;
    }

    @Override
    public boolean onQuickAction(Pony player, ActivationType type, Optional<Hit> data) {
        if (type == ActivationType.DOUBLE_TAP) {
            Object spell;
            class_1271<CustomisedSpellType<?>> thrown;
            if (!player.isClient() && (thrown = player.getCharms().getSpellInHand(true)).method_5467() != class_1269.field_5814 && (spell = ((CustomisedSpellType)thrown.method_5466()).create()) != null) {
                spell.toThrowable().throwProjectile(player).ifPresent(projectile -> {
                    player.subtractEnergyCost(this.getCostEstimate(player));
                    player.setAnimation(PlayerPoser.Animation.ARMS_FORWARD, PlayerPoser.Animation.Recipient.ANYONE, 2);
                });
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsQuickAction(Pony player, ActivationType type) {
        return type == ActivationType.NONE || type == ActivationType.DOUBLE_TAP;
    }

    @Override
    public boolean apply(Pony player, Hit data) {
        Object spell;
        class_1271<CustomisedSpellType<?>> thrown = player.getCharms().getSpellInHand(true);
        if (thrown.method_5467() != class_1269.field_5814 && (spell = ((CustomisedSpellType)thrown.method_5466()).create()) != null) {
            spell.toThrowable().throwProjectile(player).ifPresent(projectile -> {
                player.subtractEnergyCost(this.getCostEstimate(player));
                player.setAnimation(PlayerPoser.Animation.ARMS_FORWARD, PlayerPoser.Animation.Recipient.ANYONE);
                projectile.setHydrophobic();
                if (spell instanceof HomingSpell) {
                    HomingSpell homer = (HomingSpell)spell;
                    TraceHelper.findEntity(player.asEntity(), homer.getRange(player), 1.0f, EquinePredicates.VALID_LIVING_AND_NOT_MAGIC_IMMUNE).filter(((HomingSpell)spell)::setTarget).ifPresent(projectile::setHomingTarget);
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public void warmUp(Pony player, AbilitySlot slot) {
        player.getMagicalReserves().getExhaustion().multiply(3.3f);
        player.spawnParticles(MagicParticleEffect.UNICORN, 5);
    }
}

