/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.data.tree;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.data.tree.TreeTraverser;
import com.minelittlepony.unicopia.ability.data.tree.TreeTypeImpl;
import com.minelittlepony.unicopia.ability.data.tree.TreeTypes;
import com.minelittlepony.unicopia.util.PosHelper;
import com.minelittlepony.unicopia.util.Weighted;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5819;

public interface TreeType {
    public static final TreeType NONE = new TreeTypeImpl(Unicopia.id("none"), false, Set.of(), Set.of(), Weighted.of(), 0, 0.5f);

    public static TreeType at(class_2338 pos, class_1937 world) {
        return TreeTypes.get(world.method_8320(pos), pos, world);
    }

    public static TreeType of(class_2680 state) {
        return TreeTypes.get(state);
    }

    public static TreeType of(final TreeType logs, final TreeType leaves) {
        if (logs == NONE || leaves == NONE || Objects.equals(logs, leaves)) {
            return logs;
        }
        return new TreeType(){

            @Override
            public boolean isLeaves(class_2680 state) {
                return leaves.isLeaves(state);
            }

            @Override
            public boolean isLog(class_2680 state) {
                return logs.isLog(state);
            }

            @Override
            public class_1799 pickRandomStack(class_5819 random, class_2680 state) {
                return (this.isLeaves(state) ? leaves : logs).pickRandomStack(random, state);
            }

            @Override
            public boolean isWide() {
                return logs.isWide();
            }

            @Override
            public float leavesRatio() {
                return logs.leavesRatio();
            }
        };
    }

    public boolean isLeaves(class_2680 var1);

    public boolean isLog(class_2680 var1);

    default public boolean matches(class_2680 state) {
        return this.isLeaves(state) || this.isLog(state);
    }

    public class_1799 pickRandomStack(class_5819 var1, class_2680 var2);

    public boolean isWide();

    public float leavesRatio();

    default public Optional<Tree> collectBlocks(class_1937 w, class_2338 pos) {
        if (this == NONE) {
            return Optional.empty();
        }
        TreeTraverser traverser = new TreeTraverser(this);
        return traverser.findBase(w, pos).map(base -> {
            PosHelper.PositionRecord logs = traverser.collectLogs(w, (class_2338)base);
            PosHelper.PositionRecord leaves = traverser.collectLeaves(w, (class_2338)base);
            return (float)logs.size() <= (float)leaves.size() * this.leavesRatio() ? new Tree(logs, leaves) : null;
        });
    }

    public record Tree(PosHelper.PositionRecord logs, PosHelper.PositionRecord leaves) {
    }
}

