/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.data.tree;

import com.minelittlepony.unicopia.ability.data.tree.TreeType;
import com.minelittlepony.unicopia.ability.data.tree.TreeTypeImpl;
import com.minelittlepony.unicopia.ability.data.tree.TreeTypeLoader;
import com.minelittlepony.unicopia.util.PosHelper;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_5819;

public class TreeTypes {
    private static Set<TreeType> entries = new HashSet<TreeType>();
    private static final TreeType any1x = TreeTypes.createDynamic(false);
    private static final TreeType any2x = TreeTypes.createDynamic(true);

    public static void load(Map<class_2960, TreeTypeLoader.TreeTypeDef> types) {
        entries = types.entrySet().stream().map(e -> ((TreeTypeLoader.TreeTypeDef)e.getValue()).toTreeType((class_2960)e.getKey())).collect(Collectors.toSet());
    }

    static TreeType get(class_2680 state, class_2338 pos, class_1937 world) {
        return entries.stream().filter(type -> type.matches(state)).findFirst().map(type -> TreeType.of(type, TreeTypes.findLeavesType(type, world, pos))).orElseGet(() -> any1x.matches(state) ? (PosHelper.fastAny(pos, p -> world.method_8320(p).method_27852(state.method_26204()), PosHelper.HORIZONTAL) ? any2x : any1x) : TreeType.NONE);
    }

    static TreeType get(class_2680 state) {
        return entries.stream().filter(type -> type.matches(state)).findFirst().orElse(TreeType.NONE);
    }

    private static TreeType findLeavesType(TreeType baseType, class_1937 w, class_2338 pos) {
        class_2338.class_2339 mutable = pos.method_25503();
        while (baseType.isLog(w.method_8320((class_2338)mutable.method_10098(class_2350.field_11036)))) {
            if (!PosHelper.fastAny((class_2338)mutable, p -> baseType.isLeaves(w.method_8320(p)), PosHelper.HORIZONTAL)) continue;
            return baseType;
        }
        return TreeType.of(w.method_8320((class_2338)mutable));
    }

    private static TreeType createDynamic(final boolean wide) {
        return new TreeType(){

            @Override
            public boolean isLeaves(class_2680 state) {
                return (state.method_26164(class_3481.field_15503) || state.method_26204() instanceof class_2397 || entries.stream().anyMatch(t -> t.isLeaves(state))) && TreeTypeImpl.isNonPersistent(state);
            }

            @Override
            public boolean isLog(class_2680 state) {
                return state.method_26164(class_3481.field_23210) || entries.stream().anyMatch(t -> t.isLog(state));
            }

            @Override
            public class_1799 pickRandomStack(class_5819 random, class_2680 state) {
                TreeType type = TreeTypes.get(state);
                if (type == TreeType.NONE) {
                    type = TreeTypes.get(class_2246.field_10431.method_9564());
                }
                return type.pickRandomStack(random, state);
            }

            @Override
            public boolean isWide() {
                return wide;
            }

            @Override
            public float leavesRatio() {
                return 0.5f;
            }
        };
    }
}

